/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.mongodb;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.api.DBObject;
import ch.agent.crnickl.api.DBObjectId;
import ch.agent.crnickl.api.DBObjectType;
import ch.agent.crnickl.api.Database;
import ch.agent.crnickl.api.Surrogate;
import ch.agent.crnickl.impl.DatabaseMethodsImpl;
import ch.agent.crnickl.mongodb.MongoDB;
import ch.agent.crnickl.mongodb.MongoDBObjectId;
import ch.agent.crnickl.mongodb.MongoDatabase;
import ch.agent.crnickl.mongodb.T2DBMMsg;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bson.types.ObjectId;

public class MongoDatabaseMethods
extends DatabaseMethodsImpl {
    private static Matcher regex;

    public MongoDB getMongoDB(Database db) {
        return ((MongoDatabase)db).getMongoDB();
    }

    public MongoDB getMongoDB(DBObject dbObj) {
        return ((MongoDatabase)dbObj.getSurrogate().getDatabase()).getMongoDB();
    }

    public MongoDB getMongoDB(Surrogate surr) {
        return ((MongoDatabase)surr.getDatabase()).getMongoDB();
    }

    public com.mongodb.DBObject getObject(Surrogate s, boolean mustExist) throws T2DBException {
        DBCollection coll = this.getMongoDB(s).getCollection(s);
        Exception cause = null;
        com.mongodb.DBObject obj = null;
        try {
            obj = coll.findOne(this.asQuery(s.getId()));
        }
        catch (Exception e) {
            cause = e;
        }
        if (cause != null || obj == null && mustExist) {
            throw T2DBMMsg.exception(cause, "J80020", s.toString());
        }
        return obj;
    }

    public ObjectId getObjectId(BasicDBObject bdo) {
        return bdo.getObjectId("_id");
    }

    public ObjectId getIdOrZero(DBObject dBObject) {
        try {
            if (dBObject != null && !dBObject.inConstruction()) {
                return ((MongoDBObjectId)dBObject.getId()).value();
            }
            return null;
        }
        catch (ClassCastException e) {
            throw new RuntimeException("bug: " + dBObject.toString(), e);
        }
    }

    protected ObjectId getId(DBObject dBObject) {
        if (dBObject == null) {
            throw new IllegalArgumentException();
        }
        ObjectId id = this.getIdOrZero(dBObject);
        if (id == null) {
            throw new RuntimeException("bug (database integrity violation)");
        }
        return id;
    }

    public ObjectId getId(Surrogate surrogate) {
        return this.getId(surrogate.getObject());
    }

    public Surrogate makeSurrogate(Database db, DBObjectType dot, ObjectId id) {
        return super.makeSurrogate(db, dot, (DBObjectId)new MongoDBObjectId(id));
    }

    protected <T> com.mongodb.DBObject asQuery(DBObjectId id) throws T2DBException {
        BasicDBObject bo = new BasicDBObject(1);
        try {
            bo.put("_id", (Object)((MongoDBObjectId)id).value());
        }
        catch (ClassCastException e) {
            throw T2DBMMsg.exception(e, "J81012", id.toString());
        }
        return bo;
    }

    protected String extractRegexp(String pattern) {
        if (regex == null) {
            regex = Pattern.compile("^/(.*)/$").matcher("");
        }
        regex.reset(pattern);
        if (regex.matches()) {
            return regex.group(1);
        }
        return null;
    }

    protected void addOperation(com.mongodb.DBObject operation, Operator op, Object ... arg) {
        operation.put(op.op(), (Object)this.mongoObject(arg));
    }

    protected com.mongodb.DBObject operation(Operator op, Object ... arg) {
        BasicDBObject operation = new BasicDBObject();
        this.addOperation((com.mongodb.DBObject)operation, op, arg);
        return operation;
    }

    protected com.mongodb.DBObject mongoObject(Object ... arg) {
        if (arg.length == 0 || arg.length % 2 != 0) {
            throw new IllegalArgumentException(new T2DBMMsg("J81014", arg.length).toString());
        }
        BasicDBObject operand = new BasicDBObject(arg.length / 2);
        for (int i = 0; i < arg.length; ++i) {
            if (arg[i] == null) {
                throw new IllegalArgumentException(new T2DBMMsg("J81016", i).toString());
            }
            try {
                operand.put((String)arg[i], arg[++i]);
                continue;
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(new T2DBMMsg("J81016", i).toString(), e);
            }
        }
        return operand;
    }

    protected String compositeName(String ... names) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < names.length; ++i) {
            if (i > 0) {
                b.append('.');
            }
            b.append(names[i]);
        }
        return b.toString();
    }

    public static enum Operator {
        AND("$and"),
        OR("$or"),
        IN("$in"),
        INC("$inc"),
        SET("$set"),
        PUSH("$push");

        private String op;

        private Operator(String op) {
            this.op = op;
        }

        public String op() {
            return this.op;
        }
    }
}

