/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.mongodb;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.T2DBMsg;
import ch.agent.crnickl.api.Database;
import ch.agent.crnickl.api.Property;
import ch.agent.crnickl.api.ValueType;
import ch.agent.crnickl.impl.DatabaseBackend;
import ch.agent.crnickl.impl.SchemaUpdatePolicyImpl;
import ch.agent.crnickl.mongodb.MongoDatabase;
import ch.agent.crnickl.mongodb.MongoDatabaseMethods;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.bson.types.ObjectId;

public class MongoDBSchemaUpdatePolicy
extends SchemaUpdatePolicyImpl {
    private MongoDatabaseMethods methods;

    public MongoDBSchemaUpdatePolicy(MongoDatabase database) {
        super((DatabaseBackend)database);
        this.methods = database.getReadMethodsForProperty();
    }

    public <T> void willDelete(Property<T> property) throws T2DBException {
        super.willDelete(property);
        if (this.atLeastOneSchema(property)) {
            throw T2DBMsg.exception((String)"E20119", (Object[])new Object[]{property.getName()});
        }
    }

    public <T> void willDelete(ValueType<T> valueType) throws T2DBException {
        super.willDelete(valueType);
        if (this.atLeastOneProperty(valueType)) {
            throw T2DBMsg.exception((String)"E10149", (Object[])new Object[]{valueType.getName()});
        }
    }

    public <T> void willDelete(ValueType<T> vt, T value) throws T2DBException {
        super.willDelete(vt, value);
        if (this.atLeastOneActualValue(vt, value)) {
            throw T2DBMsg.exception((String)"E10158", (Object[])new Object[]{vt.getName(), vt.toString(value)});
        }
        if (this.atLeastOneDefaultValue(vt, value)) {
            throw T2DBMsg.exception((String)"E10157", (Object[])new Object[]{vt.getName(), vt.toString(value)});
        }
    }

    private <T> boolean atLeastOneProperty(ValueType<T> vt) throws T2DBException {
        return this.getProperties(vt).size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<ObjectId> getProperties(ValueType<?> vt) throws T2DBException {
        try {
            Database database = vt.getDatabase();
            DBCollection coll = this.methods.getMongoDB(database).getProperties();
            DBObject query = this.methods.mongoObject("type", this.methods.getId((ch.agent.crnickl.api.DBObject)vt));
            DBCursor cursor = coll.find(query);
            ArrayList<ObjectId> result = new ArrayList<ObjectId>();
            try {
                while (cursor.hasNext()) {
                    result.add(((BasicDBObject)cursor.next()).getObjectId("_id"));
                }
            }
            finally {
                cursor.close();
            }
            return result;
        }
        catch (Exception e) {
            throw T2DBMsg.exception((Throwable)e, (String)"E10107", (Object[])new Object[]{vt.getName()});
        }
    }

    private <T> boolean atLeastOneDefaultValue(ValueType<T> vt, T value) throws T2DBException {
        boolean foundOne = false;
        try {
            Collection<ObjectId> propOids = this.getProperties(vt);
            Database database = vt.getDatabase();
            DBCollection coll = this.methods.getMongoDB(database).getSchemas();
            for (ObjectId propOid : propOids) {
                foundOne = coll.findOne(this.methods.mongoObject(MongoDatabaseMethods.Operator.OR.op(), new DBObject[]{this.methods.mongoObject(this.methods.compositeName("attribs", "prop"), propOid, this.methods.compositeName("attribs", "val"), value), this.methods.mongoObject(this.methods.compositeName("series", "attribs", "prop"), propOid, this.methods.compositeName("series", "attribs", "val"), value)})) != null;
                if (!foundOne) continue;
                break;
            }
        }
        catch (Exception e) {
            throw T2DBMsg.exception((Throwable)e, (String)"E10112", (Object[])new Object[]{vt.toString(), value});
        }
        return foundOne;
    }

    private <T> boolean atLeastOneActualValue(ValueType<T> vt, T value) throws T2DBException {
        boolean foundOne = false;
        try {
            ObjectId propOid;
            Collection<ObjectId> propOids = this.getProperties(vt);
            Database database = vt.getDatabase();
            DBCollection coll = this.methods.getMongoDB(database).getAttributes();
            Iterator<ObjectId> iterator = propOids.iterator();
            while (iterator.hasNext() && !(foundOne = coll.findOne(this.methods.mongoObject("prop", propOid = iterator.next(), "val", value)) != null)) {
            }
        }
        catch (Exception e) {
            throw T2DBMsg.exception((Throwable)e, (String)"E10113", (Object[])new Object[]{vt.toString(), value});
        }
        return foundOne;
    }

    private <T> boolean atLeastOneSchema(Property<T> prop) throws T2DBException {
        try {
            Database database = prop.getDatabase();
            DBCollection coll = this.methods.getMongoDB(database).getSchemas();
            ObjectId propOid = this.methods.getId((ch.agent.crnickl.api.DBObject)prop);
            return coll.findOne(this.methods.mongoObject(MongoDatabaseMethods.Operator.OR.op(), new DBObject[]{this.methods.mongoObject(this.methods.compositeName("attribs", "prop"), propOid), this.methods.mongoObject(this.methods.compositeName("series", "attribs", "prop"), propOid)})) != null;
        }
        catch (Exception e) {
            throw T2DBMsg.exception((Throwable)e, (String)"E20107", (Object[])new Object[]{prop.toString()});
        }
    }
}

