/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.mongodb;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.T2DBMsg;
import ch.agent.crnickl.api.DBObject;
import ch.agent.crnickl.api.Series;
import ch.agent.crnickl.api.Surrogate;
import ch.agent.crnickl.api.UpdatableSeries;
import ch.agent.crnickl.impl.ChronicleUpdatePolicy;
import ch.agent.crnickl.impl.Permission;
import ch.agent.crnickl.impl.ValueAccessMethods;
import ch.agent.crnickl.mongodb.MongoDatabaseMethods;
import ch.agent.t2.time.Range;
import ch.agent.t2.time.TimeDomain;
import ch.agent.t2.time.TimeIndex;
import ch.agent.t2.timeseries.Observation;
import ch.agent.t2.timeseries.SparseTimeSeries;
import ch.agent.t2.timeseries.TimeAddressable;
import com.mongodb.BasicDBObject;
import java.util.Map;
import java.util.TreeMap;

public class AccessMethodsForNumber
extends MongoDatabaseMethods
implements ValueAccessMethods<Double> {
    public Range getRange(Series<Double> series) throws T2DBException {
        Range range = null;
        try {
            this.check(Permission.READ, (DBObject)series);
            Surrogate s = series.getSurrogate();
            BasicDBObject obj = (BasicDBObject)this.getObject(s, false);
            if (obj != null) {
                long first = obj.getLong("first");
                long last = obj.getLong("last");
                range = new Range(series.getTimeDomain(), first, last);
            }
        }
        catch (Exception e) {
            throw T2DBMsg.exception((Throwable)e, (String)"E50122", (Object[])new Object[]{series.getName(true)});
        }
        if (range == null) {
            range = new Range(series.getTimeDomain());
        }
        return range;
    }

    public long getValues(Series<Double> series, Range range, TimeAddressable<Double> ts) throws T2DBException {
        if (range != null && range.isEmpty()) {
            return 0L;
        }
        long count = 0L;
        try {
            this.check(Permission.READ, (DBObject)series);
            Surrogate s = series.getSurrogate();
            com.mongodb.DBObject obj = this.getObject(s, true);
            count = this.extractValues(obj, range, ts);
        }
        catch (Exception e) {
            if (range == null) {
                throw T2DBMsg.exception((Throwable)e, (String)"E50121", (Object[])new Object[]{series.getName(true)});
            }
            throw T2DBMsg.exception((Throwable)e, (String)"E50120", (Object[])new Object[]{series.getName(true), range.toString()});
        }
        return count;
    }

    private long extractValues(com.mongodb.DBObject obj, Range range, TimeAddressable<Double> ts) throws Exception {
        if (range != null && range.isEmpty()) {
            return 0L;
        }
        long count = 0L;
        Map values = (Map)obj.get("values");
        for (String k : values.keySet()) {
            long t = Long.valueOf(k);
            if (range != null && !range.isInRange(t)) continue;
            ts.put(t, values.get(k));
            ++count;
        }
        return count;
    }

    private Observation<Double> extractLastValue(BasicDBObject obj, TimeDomain domain, TimeIndex t) throws Exception {
        long time;
        long first = obj.getLong("first");
        long last = obj.getLong("last");
        Observation obs = null;
        long l = time = t == null ? last : t.asLong();
        if (last >= first && time >= first) {
            Map values = (Map)obj.get("values");
            String key = null;
            if (time >= last) {
                key = Long.toString(last);
            } else {
                TreeMap sorted = new TreeMap(values);
                key = sorted.headMap(Long.toString(time + 1L)).lastKey();
            }
            obs = new Observation(domain.time(Long.valueOf(key).longValue()), values.get(key));
        }
        return obs;
    }

    private Observation<Double> extractFirstValue(BasicDBObject obj, TimeDomain domain, TimeIndex t) throws Exception {
        long time;
        long first = obj.getLong("first");
        long last = obj.getLong("last");
        Observation obs = null;
        long l = time = t == null ? first : t.asLong();
        if (last >= first && time <= last) {
            Map values = (Map)obj.get("values");
            String key = null;
            if (time <= first) {
                key = Long.toString(first);
            } else {
                TreeMap sorted = new TreeMap(values);
                key = sorted.tailMap(Long.toString(time)).firstKey();
            }
            obs = new Observation(domain.time(Long.valueOf(key).longValue()), values.get(key));
        }
        return obs;
    }

    public Observation<Double> getFirst(Series<Double> series, TimeIndex time) throws T2DBException {
        try {
            this.check(Permission.READ, (DBObject)series);
            Surrogate s = series.getSurrogate();
            com.mongodb.DBObject obj = this.getObject(s, true);
            return this.extractFirstValue((BasicDBObject)obj, series.getTimeDomain(), time);
        }
        catch (Exception e) {
            throw T2DBMsg.exception((Throwable)e, (String)"E50123", (Object[])new Object[]{series.getName(true), time.toString()});
        }
    }

    public Observation<Double> getLast(Series<Double> series, TimeIndex time) throws T2DBException {
        try {
            this.check(Permission.READ, (DBObject)series);
            Surrogate s = series.getSurrogate();
            com.mongodb.DBObject obj = this.getObject(s, true);
            return this.extractLastValue((BasicDBObject)obj, series.getTimeDomain(), time);
        }
        catch (Exception e) {
            throw T2DBMsg.exception((Throwable)e, (String)"E50124", (Object[])new Object[]{series.getName(true), time.toString()});
        }
    }

    public boolean deleteValue(UpdatableSeries<Double> series, TimeIndex t, ChronicleUpdatePolicy policy) throws T2DBException {
        boolean done = false;
        try {
            this.check(Permission.MODIFY, (DBObject)series);
            policy.willDelete(series, t);
            policy.deleteValue(series, t);
            Surrogate s = series.getSurrogate();
            com.mongodb.DBObject obj = this.getObject(s, true);
            SparseTimeSeries values = new SparseTimeSeries(Double.class, series.getTimeDomain());
            this.extractValues(obj, null, (TimeAddressable<Double>)values);
            if (values.getRange().isInRange(t)) {
                values.put(t, values.getMissingValue());
                done = true;
            }
            this.update((Series)series, (TimeAddressable<Double>)values);
        }
        catch (Exception e) {
            throw T2DBMsg.exception((Throwable)e, (String)"E50113", (Object[])new Object[]{series.getName(true), t.toString()});
        }
        return done;
    }

    public boolean updateSeries(UpdatableSeries<Double> series, Range range, ChronicleUpdatePolicy policy) throws T2DBException {
        boolean done = false;
        try {
            this.check(Permission.MODIFY, (DBObject)series);
            policy.willUpdate(series, range);
            done = policy.update(series, range);
            Surrogate s = series.getSurrogate();
            com.mongodb.DBObject obj = this.getObject(s, true);
            SparseTimeSeries values = new SparseTimeSeries(Double.class, series.getTimeDomain());
            this.extractValues(obj, null, (TimeAddressable<Double>)values);
            if (values.setRange(range)) {
                done = true;
            }
            this.update((Series)series, (TimeAddressable<Double>)values);
        }
        catch (Exception e) {
            throw T2DBMsg.exception((Throwable)e, (String)"E50109", (Object[])new Object[]{series.getName(true)});
        }
        return done;
    }

    public long updateValues(UpdatableSeries<Double> series, TimeAddressable<Double> values, ChronicleUpdatePolicy policy) throws T2DBException {
        long count = 0L;
        try {
            this.check(Permission.MODIFY, (DBObject)series);
            Surrogate s = series.getSurrogate();
            com.mongodb.DBObject obj = this.getObject(s, true);
            SparseTimeSeries current = new SparseTimeSeries(Double.class, series.getTimeDomain());
            this.extractValues(obj, null, (TimeAddressable<Double>)current);
            for (Observation obs : values) {
                current.put(obs.getIndex(), obs.getValue());
                ++count;
            }
            this.update((Series)series, (TimeAddressable<Double>)current);
        }
        catch (Exception e) {
            throw T2DBMsg.exception((Throwable)e, (String)"E50114", (Object[])new Object[]{series.getName(true)});
        }
        return count;
    }

    private <T> void update(Series<T> series, TimeAddressable<Double> values) throws T2DBException {
        com.mongodb.DBObject operation = null;
        Range range = values.getRange();
        TreeMap<String, Object> data = new TreeMap<String, Object>();
        for (Observation obs : values) {
            data.put(Long.toString(obs.getIndex()), obs.getValue());
        }
        operation = this.operation(MongoDatabaseMethods.Operator.SET, "first", range.getFirstIndex(), "last", range.getLastIndex(), "values", data);
        Surrogate s = series.getSurrogate();
        this.getMongoDB(s).getSeries().update(this.asQuery(s.getId()), operation);
    }
}

