/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.mongodb;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.T2DBMsg;
import ch.agent.crnickl.api.AttributeDefinition;
import ch.agent.crnickl.api.DBObject;
import ch.agent.crnickl.api.DBObjectId;
import ch.agent.crnickl.api.DBObjectType;
import ch.agent.crnickl.api.Database;
import ch.agent.crnickl.api.Property;
import ch.agent.crnickl.api.Schema;
import ch.agent.crnickl.api.SeriesDefinition;
import ch.agent.crnickl.api.Surrogate;
import ch.agent.crnickl.api.UpdatableSchema;
import ch.agent.crnickl.impl.Permission;
import ch.agent.crnickl.impl.SchemaUpdatePolicy;
import ch.agent.crnickl.mongodb.MongoDBObjectId;
import ch.agent.crnickl.mongodb.MongoDatabase;
import ch.agent.crnickl.mongodb.ReadMethodsForSchema;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.WriteConcern;
import java.util.Collection;
import org.bson.types.ObjectId;

public class WriteMethodsForSchema
extends ReadMethodsForSchema {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSchema(UpdatableSchema schema) throws T2DBException {
        Surrogate surrogate = null;
        Exception cause = null;
        try {
            this.check(Permission.CREATE, (DBObject)schema);
            UpdatableSchema base = schema.getBase();
            if (base != null) {
                this.check(Permission.READ, (DBObject)base);
            }
            DBObjectId ox = this.insert(schema);
            surrogate = this.makeSurrogate((DBObject)schema, ox);
        }
        catch (Exception e) {
            cause = e;
        }
        if (surrogate == null || cause != null) {
            throw T2DBMsg.exception((Throwable)cause, (String)"E30122", (Object[])new Object[]{schema.getName()});
        }
        schema.getSurrogate().upgrade(surrogate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSchema(UpdatableSchema schema, SchemaUpdatePolicy policy) throws T2DBException {
        boolean done = false;
        Exception cause = null;
        Surrogate s = schema.getSurrogate();
        MongoDatabase database = (MongoDatabase)s.getDatabase();
        try {
            this.check(Permission.MODIFY, (DBObject)schema);
            policy.willDelete(schema);
            UpdatableSchema original = database.getReadMethodsForSchema().getSchema(s);
            DBCollection coll = this.getMongoDB(s).getSchemas();
            coll.remove(this.asQuery(s.getId()), WriteConcern.SAFE);
            database.sleep();
            try {
                policy.willDelete(schema);
            }
            catch (T2DBException e) {
                this.createSchema(original);
                throw e;
            }
            done = true;
        }
        catch (Exception e) {
            cause = e;
        }
        if (!done || cause != null) {
            throw T2DBMsg.exception((Throwable)cause, (String)"E30123", (Object[])new Object[]{schema.getName()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateSchema(UpdatableSchema schema, SchemaUpdatePolicy policy) throws T2DBException {
        boolean done = false;
        Exception cause = null;
        Surrogate s = schema.getSurrogate();
        MongoDatabase database = (MongoDatabase)s.getDatabase();
        try {
            this.check(Permission.MODIFY, (DBObject)schema);
            UpdatableSchema original = database.getReadMethodsForSchema().getSchema(s);
            UpdatableSchema base = schema.getBase();
            if (base != null && !base.equals(original.getBase())) {
                this.check(Permission.READ, (DBObject)base);
            }
            DBCollection coll = this.getMongoDB(s).getSchemas();
            com.mongodb.DBObject operation = this.mongoObject("name", schema.getName(), "base", this.getIdOrZero((DBObject)schema.getBase()), "attribs", this.attributeDefinitions(schema.getAttributeDefinitions()), "series", this.seriesDefinitions(schema.getSeriesDefinitions()));
            coll.update(this.asQuery(s.getId()), operation, false, false, WriteConcern.SAFE);
            database.sleep();
            try {
                policy.willUpdate(schema);
            }
            catch (T2DBException e) {
                operation = this.mongoObject("name", original.getName(), "base", this.getId((DBObject)original.getBase()), "attribs", original.getAttributeDefinitions(), "series", original.getSeriesDefinitions());
                coll.update(this.asQuery(s.getId()), operation);
                throw e;
            }
            done = true;
        }
        catch (Exception e) {
            cause = e;
        }
        if (cause != null) {
            throw T2DBMsg.exception((Throwable)cause, (String)"E30122", (Object[])new Object[]{schema.getName()});
        }
        return done;
    }

    public Surrogate findChronicle(Schema schema) throws T2DBException {
        Surrogate result = null;
        try {
            Database db = schema.getDatabase();
            BasicDBObject query = new BasicDBObject();
            query.put("schema", (Object)this.getId((DBObject)schema));
            com.mongodb.DBObject obj = this.getMongoDB(db).getChronicles().findOne((com.mongodb.DBObject)query);
            if (obj != null) {
                result = this.makeSurrogate(db, DBObjectType.CHRONICLE, this.getObjectId((BasicDBObject)obj));
            }
        }
        catch (Exception e) {
            throw T2DBMsg.exception((Throwable)e, (String)"E30117", (Object[])new Object[0]);
        }
        return result;
    }

    public Surrogate findChronicle(Property<?> property, Schema schema) throws T2DBException {
        Surrogate result = null;
        DBCursor cursor = null;
        try {
            Database db = schema.getDatabase();
            cursor = this.getMongoDB(db).getAttributes().find(this.mongoObject("prop", this.getId((DBObject)property)));
            while (cursor.hasNext()) {
                ObjectId chrOid = ((BasicDBObject)cursor.next()).getObjectId("chron");
                Surrogate entityKey = this.makeSurrogate(db, DBObjectType.CHRONICLE, chrOid);
                Schema s = db.getChronicle(entityKey).getSchema(true);
                if (!s.dependsOnSchema(schema)) continue;
                result = entityKey;
                break;
            }
        }
        catch (Exception e) {
            throw T2DBMsg.exception((Throwable)e, (String)"E30117", (Object[])new Object[0]);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return result;
    }

    public Surrogate findChronicle(SeriesDefinition ss, Schema schema) throws T2DBException {
        Surrogate result;
        block9: {
            result = null;
            DBCursor cursor1 = null;
            DBCursor cursor2 = null;
            try {
                Database db = schema.getDatabase();
                cursor1 = this.getMongoDB(db).getChronicles().find(this.mongoObject("schema", this.getId((DBObject)schema)));
                while (cursor1.hasNext()) {
                    ObjectId chronicleOid = this.getObjectId((BasicDBObject)cursor1.next());
                    cursor2 = this.getMongoDB(db).getSeries().find(this.mongoObject("chron", chronicleOid, "number", ss.getNumber()));
                    while (cursor2.hasNext()) {
                        Surrogate entityKey = this.makeSurrogate(db, DBObjectType.CHRONICLE, chronicleOid);
                        Schema s = db.getChronicle(entityKey).getSchema(true);
                        if (!s.dependsOnSchema(schema)) continue;
                        result = entityKey;
                        break block9;
                    }
                }
            }
            catch (Exception e) {
                throw T2DBMsg.exception((Throwable)e, (String)"E30117", (Object[])new Object[0]);
            }
            finally {
                if (cursor1 != null) {
                    cursor1.close();
                }
                if (cursor2 != null) {
                    cursor2.close();
                }
            }
        }
        return result;
    }

    private <T> DBObjectId insert(UpdatableSchema schema) throws T2DBException {
        BasicDBObject bo = new BasicDBObject();
        Surrogate s = schema.getSurrogate();
        if (!s.inConstruction()) {
            bo.put("_id", (Object)this.getId((DBObject)schema));
        }
        bo.put("name", (Object)schema.getName());
        bo.put("base", (Object)this.getIdOrZero((DBObject)schema.getBase()));
        bo.put("attribs", (Object)this.attributeDefinitions(schema.getAttributeDefinitions()));
        bo.put("series", (Object)this.seriesDefinitions(schema.getSeriesDefinitions()));
        this.getMongoDB(s).getSchemas().insert(new com.mongodb.DBObject[]{bo});
        ObjectId ox = this.getObjectId(bo);
        return new MongoDBObjectId(ox);
    }

    private BasicDBList attributeDefinitions(Collection<AttributeDefinition<?>> defs) throws T2DBException {
        BasicDBList list = new BasicDBList();
        if (defs != null) {
            int i = 0;
            for (AttributeDefinition<?> def : defs) {
                list.put(i++, (Object)this.attributeDefinition(def));
            }
        }
        return list;
    }

    private BasicDBObject attributeDefinition(AttributeDefinition<?> def) throws T2DBException {
        BasicDBObject bo = new BasicDBObject();
        bo.put("num", (Object)def.getNumber());
        bo.put("erasing", (Object)def.isErasing());
        bo.put("prop", def.isErasing() ? null : this.getId((DBObject)def.getProperty()));
        bo.put("val", def.isErasing() ? null : def.getProperty().getValueType().toString(def.getValue()));
        return bo;
    }

    private BasicDBList seriesDefinitions(Collection<SeriesDefinition> defs) throws T2DBException {
        BasicDBList list = new BasicDBList();
        if (defs != null) {
            int i = 0;
            for (SeriesDefinition def : defs) {
                list.put(i++, (Object)this.seriesDefinition(def));
            }
        }
        return list;
    }

    private BasicDBObject seriesDefinition(SeriesDefinition def) throws T2DBException {
        BasicDBObject bo = new BasicDBObject();
        bo.put("num", (Object)def.getNumber());
        bo.put("erasing", (Object)def.isErasing());
        bo.put("desc", (Object)(def.isErasing() ? null : def.getDescription()));
        bo.put("attribs", (Object)(def.isErasing() ? this.attributeDefinitions(null) : this.attributeDefinitions(def.getAttributeDefinitions())));
        return bo;
    }
}

