/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.mongodb;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.T2DBMsg;
import ch.agent.crnickl.api.DBObjectType;
import ch.agent.crnickl.api.Database;
import ch.agent.crnickl.api.Surrogate;
import ch.agent.crnickl.api.ValueType;
import ch.agent.crnickl.impl.ValueTypeImpl;
import ch.agent.crnickl.mongodb.MongoDBObjectId;
import ch.agent.crnickl.mongodb.MongoDatabaseMethods;
import ch.agent.crnickl.mongodb.T2DBMMsg;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import org.bson.types.ObjectId;

public class ReadMethodsForValueType
extends MongoDatabaseMethods {
    public <T> ValueType<T> getValueType(Database database, String name) throws T2DBException {
        try {
            BasicDBObject obj = (BasicDBObject)this.getMongoDB(database).getValueTypes().findOne(this.mongoObject("name", name));
            if (obj != null) {
                return this.unpack(database, obj);
            }
            return null;
        }
        catch (Exception e) {
            throw T2DBMsg.exception((Throwable)e, (String)"E10104", (Object[])new Object[]{name});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ValueType<?>> getValueTypes(Database database, String pattern) throws T2DBException {
        try {
            DBObject query = null;
            if (pattern != null && pattern.length() > 0) {
                String regexp = this.extractRegexp(pattern);
                pattern = regexp == null ? pattern.replace("*", ".*") : regexp;
                query = this.mongoObject("name", Pattern.compile(pattern));
            }
            DBCursor cursor = this.getMongoDB(database).getValueTypes().find(query);
            ArrayList result = new ArrayList();
            try {
                while (cursor.hasNext()) {
                    result.add(this.unpack(database, (BasicDBObject)cursor.next()));
                }
            }
            finally {
                cursor.close();
            }
            return result;
        }
        catch (Exception e) {
            throw T2DBMsg.exception((Throwable)e, (String)"E10106", (Object[])new Object[]{pattern});
        }
    }

    public <T> ValueType<T> getValueType(Surrogate s) throws T2DBException {
        try {
            DBObject obj = this.getObject(s, false);
            if (obj != null) {
                return this.unpack(s.getDatabase(), (BasicDBObject)obj);
            }
            return null;
        }
        catch (Exception e) {
            throw T2DBMsg.exception((Throwable)e, (String)"E10105", (Object[])new Object[]{s.toString()});
        }
    }

    private <T> ValueType<T> unpack(Database db, BasicDBObject obj) throws T2DBException {
        try {
            ObjectId id = obj.getObjectId("_id");
            String name = obj.getString("name");
            String type = obj.getString("type");
            Object values = obj.get("values");
            boolean restricted = values != null;
            Map valueMap = null;
            if (restricted) {
                valueMap = ((BasicDBObject)values).toMap();
            }
            Surrogate s = this.makeSurrogate(db, DBObjectType.VALUE_TYPE, new MongoDBObjectId(id));
            return new ValueTypeImpl(name, restricted, type, valueMap, s);
        }
        catch (ClassCastException e) {
            throw T2DBMMsg.exception(e, "J81010", obj.toString());
        }
    }
}

