/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.mongodb;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.T2DBMsg;
import ch.agent.crnickl.api.AttributeDefinition;
import ch.agent.crnickl.api.DBObject;
import ch.agent.crnickl.api.DBObjectType;
import ch.agent.crnickl.api.Database;
import ch.agent.crnickl.api.Property;
import ch.agent.crnickl.api.SeriesDefinition;
import ch.agent.crnickl.api.Surrogate;
import ch.agent.crnickl.api.UpdatableSchema;
import ch.agent.crnickl.impl.AttributeDefinitionImpl;
import ch.agent.crnickl.impl.SeriesDefinitionImpl;
import ch.agent.crnickl.impl.UpdatableSchemaImpl;
import ch.agent.crnickl.mongodb.MongoDBObjectId;
import ch.agent.crnickl.mongodb.MongoDatabase;
import ch.agent.crnickl.mongodb.MongoDatabaseMethods;
import ch.agent.crnickl.mongodb.T2DBMMsg;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.bson.types.ObjectId;

public class ReadMethodsForSchema
extends MongoDatabaseMethods {
    public UpdatableSchema getSchema(Surrogate surrogate) throws T2DBException {
        return this.getSchema(surrogate, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Surrogate> getSchemaSurrogateList(Database db, String pattern) throws T2DBException {
        try {
            ArrayList<Surrogate> result = new ArrayList<Surrogate>();
            DBCollection coll = this.getMongoDB(db).getSchemas();
            com.mongodb.DBObject query = null;
            if (pattern != null && pattern.length() > 0) {
                String regexp = this.extractRegexp(pattern);
                if (regexp == null && (regexp = pattern.replace("*", ".*")).equals(pattern)) {
                    regexp = null;
                }
                query = this.mongoObject("name", regexp == null ? pattern : Pattern.compile(regexp));
            }
            DBCursor cursor = coll.find(query);
            try {
                while (cursor.hasNext()) {
                    ObjectId id = (ObjectId)cursor.next().get("_id");
                    Surrogate s = this.makeSurrogate(db, DBObjectType.SCHEMA, new MongoDBObjectId(id));
                    result.add(s);
                }
            }
            finally {
                cursor.close();
            }
            return result;
        }
        catch (Exception e) {
            throw T2DBMsg.exception((Throwable)e, (String)"E30105", (Object[])new Object[]{pattern});
        }
    }

    private UpdatableSchema getSchema(Surrogate s, Set<ObjectId> cycleDetector) throws T2DBException {
        try {
            com.mongodb.DBObject obj = this.getObject(s, false);
            return obj == null ? null : this.unpack(s.getDatabase(), (BasicDBObject)obj, cycleDetector);
        }
        catch (Exception e) {
            throw T2DBMsg.exception((Throwable)e, (String)"E30104", (Object[])new Object[]{s.toString()});
        }
    }

    private UpdatableSchema unpack(Database db, BasicDBObject obj, Set<ObjectId> cycleDetector) throws T2DBException {
        if (cycleDetector == null) {
            cycleDetector = new HashSet<ObjectId>();
        }
        try {
            ObjectId id = obj.getObjectId("_id");
            Surrogate s = this.makeSurrogate(db, DBObjectType.SCHEMA, new MongoDBObjectId(id));
            boolean cycleDetected = !cycleDetector.add(id);
            String name = obj.getString("name");
            UpdatableSchema base = null;
            ObjectId baseId = obj.getObjectId("base");
            if (baseId != null && !cycleDetected) {
                Surrogate baseSurr = this.makeSurrogate(db, DBObjectType.SCHEMA, new MongoDBObjectId(baseId));
                base = this.getSchema(baseSurr, cycleDetector);
            }
            Collection<AttributeDefinition<?>> attribs = this.attributeDefinitions(s, 0, db, (BasicDBList)obj.get("attribs"));
            Collection<SeriesDefinition> series = this.seriesDefinitions(s, db, (BasicDBList)obj.get("series"));
            return new UpdatableSchemaImpl(name, base, attribs, series, s);
        }
        catch (ClassCastException e) {
            throw T2DBMMsg.exception(e, "J81010", obj.toString());
        }
    }

    private Collection<AttributeDefinition<?>> attributeDefinitions(Surrogate schemaSurrogate, int seriesNr, Database db, BasicDBList list) throws T2DBException {
        ArrayList result = new ArrayList(list.size());
        for (int i = 0; i < list.size(); ++i) {
            result.add(this.attributeDefinition(schemaSurrogate, seriesNr, db, (BasicDBObject)list.get(i)));
        }
        return result;
    }

    private AttributeDefinition<?> attributeDefinition(Surrogate schemaSurrogate, int seriesNr, Database db, BasicDBObject bo) throws T2DBException {
        int number = bo.getInt("num");
        boolean era = bo.getBoolean("erasing");
        AttributeDefinitionImpl def = null;
        if (era) {
            def = new AttributeDefinitionImpl(seriesNr, number, null, null);
            def.edit();
            def.setErasing(true);
        } else {
            ObjectId propId = bo.getObjectId("prop");
            Surrogate propSurr = this.makeSurrogate(db, DBObjectType.PROPERTY, new MongoDBObjectId(propId));
            Property prop = ((MongoDatabase)db).getReadMethodsForProperty().getProperty(propSurr);
            String val = bo.getString("val");
            this.checkIntegrity((DBObject)prop, propSurr, schemaSurrogate);
            def = new AttributeDefinitionImpl(seriesNr, number, prop, prop.getValueType().scan(val));
        }
        return def;
    }

    private Collection<SeriesDefinition> seriesDefinitions(Surrogate schemaSurrogate, Database db, BasicDBList list) throws T2DBException {
        ArrayList<SeriesDefinition> result = new ArrayList<SeriesDefinition>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            result.add(this.seriesDefinition(schemaSurrogate, db, (BasicDBObject)list.get(i)));
        }
        return result;
    }

    private SeriesDefinition seriesDefinition(Surrogate schemaSurrogate, Database db, BasicDBObject bo) throws T2DBException {
        int number = bo.getInt("num");
        boolean era = bo.getBoolean("erasing");
        SeriesDefinitionImpl def = null;
        if (era) {
            def = new SeriesDefinitionImpl(number, null, null);
            def.edit();
            def.setErasing(true);
        } else {
            String desc = bo.getString("desc");
            BasicDBList list = (BasicDBList)bo.get("attribs");
            Collection<AttributeDefinition<?>> attribs = this.attributeDefinitions(schemaSurrogate, number, db, list);
            def = new SeriesDefinitionImpl(number, desc, attribs);
        }
        return def;
    }
}

