/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.mongodb;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.T2DBMsg;
import ch.agent.crnickl.api.DBObject;
import ch.agent.crnickl.api.DBObjectType;
import ch.agent.crnickl.api.Database;
import ch.agent.crnickl.api.Property;
import ch.agent.crnickl.api.Surrogate;
import ch.agent.crnickl.api.ValueType;
import ch.agent.crnickl.impl.PropertyImpl;
import ch.agent.crnickl.mongodb.MongoDBObjectId;
import ch.agent.crnickl.mongodb.MongoDatabaseMethods;
import ch.agent.crnickl.mongodb.T2DBMMsg;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;
import org.bson.types.ObjectId;

public class ReadMethodsForProperty
extends MongoDatabaseMethods {
    public <T> Property<T> getProperty(Database database, String name) throws T2DBException {
        try {
            DBCollection coll = this.getMongoDB(database).getProperties();
            com.mongodb.DBObject obj = coll.findOne(this.mongoObject("name", name));
            if (obj != null) {
                return this.unpack(database, (BasicDBObject)obj);
            }
            return null;
        }
        catch (Exception e) {
            throw T2DBMsg.exception((Throwable)e, (String)"E20104", (Object[])new Object[]{name});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Property<?>> getProperties(Database database, String pattern) throws T2DBException {
        try {
            DBCollection coll = this.getMongoDB(database).getProperties();
            com.mongodb.DBObject query = null;
            if (pattern != null && pattern.length() > 0) {
                String regexp = this.extractRegexp(pattern);
                pattern = regexp == null ? pattern.replace("*", ".*") : regexp;
                query = this.mongoObject("name", Pattern.compile(pattern));
            }
            DBCursor cursor = coll.find(query);
            ArrayList result = new ArrayList();
            try {
                while (cursor.hasNext()) {
                    result.add(this.unpack(database, (BasicDBObject)cursor.next()));
                }
            }
            finally {
                cursor.close();
            }
            return result;
        }
        catch (Exception e) {
            throw T2DBMsg.exception((Throwable)e, (String)"E20106", (Object[])new Object[]{pattern});
        }
    }

    public <T> Property<T> getProperty(Surrogate s) throws T2DBException {
        try {
            com.mongodb.DBObject obj = this.getObject(s, false);
            if (obj != null) {
                return this.unpack(s.getDatabase(), (BasicDBObject)obj);
            }
            return null;
        }
        catch (Exception e) {
            throw T2DBMsg.exception((Throwable)e, (String)"E20105", (Object[])new Object[]{s.toString()});
        }
    }

    private <T> Property<T> unpack(Database db, BasicDBObject obj) throws T2DBException {
        try {
            ObjectId id = obj.getObjectId("_id");
            String name = obj.getString("name");
            ObjectId vtId = obj.getObjectId("type");
            Boolean indexed = obj.getBoolean("indexed");
            Surrogate vts = this.makeSurrogate(db, DBObjectType.VALUE_TYPE, new MongoDBObjectId(vtId));
            ValueType vt = db.getValueType(vts);
            Surrogate s = this.makeSurrogate(db, DBObjectType.PROPERTY, new MongoDBObjectId(id));
            this.checkIntegrity((DBObject)vt, vts, s);
            return new PropertyImpl(name, vt, indexed.booleanValue(), s);
        }
        catch (ClassCastException e) {
            throw T2DBMMsg.exception(e, "J81010", obj.toString());
        }
    }
}

