/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.mongodb;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.T2DBMsg;
import ch.agent.crnickl.api.Attribute;
import ch.agent.crnickl.api.Chronicle;
import ch.agent.crnickl.api.DBObject;
import ch.agent.crnickl.api.DBObjectType;
import ch.agent.crnickl.api.Database;
import ch.agent.crnickl.api.Property;
import ch.agent.crnickl.api.Series;
import ch.agent.crnickl.api.Surrogate;
import ch.agent.crnickl.impl.ChronicleImpl;
import ch.agent.crnickl.impl.Permission;
import ch.agent.crnickl.impl.SeriesImpl;
import ch.agent.crnickl.mongodb.MongoDatabaseMethods;
import ch.agent.crnickl.mongodb.T2DBMMsg;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCursor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.bson.types.ObjectId;

public class ReadMethodsForChroniclesAndSeries
extends MongoDatabaseMethods {
    public Chronicle getChronicle(Surrogate s) throws T2DBException {
        com.mongodb.DBObject obj = this.getObject(s, false);
        Exception cause = null;
        if (obj != null) {
            try {
                Chronicle chronicle = this.unpack(s.getDatabase(), (BasicDBObject)obj);
                this.check(Permission.READ, (DBObject)chronicle);
                return chronicle;
            }
            catch (Exception e) {
                cause = e;
            }
        }
        throw T2DBMsg.exception((Throwable)cause, (String)"E40104", (Object[])new Object[]{s.toString()});
    }

    public Chronicle getChronicleOrNull(Chronicle parent, String name) throws T2DBException {
        try {
            Database database = parent.getDatabase();
            com.mongodb.DBObject obj = this.getMongoDB(database).getChronicles().findOne(this.mongoObject("parent", this.getIdOrZero((DBObject)parent), "name", name));
            if (obj != null) {
                Chronicle chronicle = this.unpack(database, (BasicDBObject)obj);
                this.check(Permission.READ, (DBObject)chronicle);
                return chronicle;
            }
            return null;
        }
        catch (Exception e) {
            throw T2DBMsg.exception((Throwable)e, (String)"E40123", (Object[])new Object[]{name, parent.getName(true)});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Chronicle> getChroniclesByParent(Chronicle parent) throws T2DBException {
        ArrayList<Chronicle> result = new ArrayList<Chronicle>();
        if (this.check(Permission.DISCOVER, (DBObject)parent, false)) {
            try {
                Database db = parent.getDatabase();
                DBCursor cursor = this.getMongoDB(db).getChronicles().find(this.mongoObject("parent", this.getIdOrZero((DBObject)parent)));
                try {
                    while (cursor.hasNext()) {
                        Chronicle chronicle = this.unpack(db, (BasicDBObject)cursor.next());
                        this.check(Permission.READ, (DBObject)chronicle);
                        result.add(chronicle);
                    }
                }
                finally {
                    cursor.close();
                }
            }
            catch (Exception e) {
                throw T2DBMsg.exception((Throwable)e, (String)"E40122", (Object[])new Object[]{parent.getName(true)});
            }
        }
        return result;
    }

    public boolean getAttributeValue(List<Chronicle> chronicles, Attribute<?> attribute) throws T2DBException {
        boolean found = false;
        Surrogate s = attribute.getProperty().getSurrogate();
        Database db = s.getDatabase();
        try {
            ObjectId[] chrOids = new ObjectId[chronicles.size()];
            int offset = 0;
            for (Chronicle chronicle : chronicles) {
                chrOids[offset++] = this.getId((DBObject)chronicle);
            }
            DBCursor cursor = this.getMongoDB(db).getAttributes().find(this.mongoObject("prop", this.getId(s), "chron", this.mongoObject(MongoDatabaseMethods.Operator.IN.op(), chrOids)));
            offset = Integer.MAX_VALUE;
            BasicDBObject objAtOffset = null;
            while (cursor.hasNext()) {
                BasicDBObject obj = (BasicDBObject)cursor.next();
                ObjectId chrOid = obj.getObjectId("chron");
                int offset1 = this.findOffset(chrOid, chronicles);
                if (offset1 < offset) {
                    offset = offset1;
                    objAtOffset = obj;
                }
                if (offset != 0) continue;
                break;
            }
            if (objAtOffset != null) {
                ObjectId chrOid = objAtOffset.getObjectId("chron");
                Surrogate chronicle = this.makeSurrogate(db, DBObjectType.CHRONICLE, chrOid);
                this.check(Permission.READ, chronicle);
                attribute.scan((Object)objAtOffset.getString("val"));
                String description = objAtOffset.getString("descr");
                if (description.length() > 0) {
                    attribute.setDescription(description);
                }
                found = true;
            }
        }
        catch (Exception e) {
            throw T2DBMsg.exception((Throwable)e, (String)"E40120", (Object[])new Object[]{attribute.getProperty().getName()});
        }
        return found;
    }

    public <T> List<Chronicle> getChroniclesByAttributeValue(Property<T> property, T value, int maxSize) throws T2DBException {
        ArrayList<Chronicle> result = new ArrayList<Chronicle>();
        Surrogate s = property.getSurrogate();
        Database db = s.getDatabase();
        try {
            DBCursor cursor = this.getMongoDB(db).getAttributes().find(this.mongoObject("prop", this.getId(s), "val", property.getValueType().toString(value)));
            while (cursor.hasNext()) {
                BasicDBObject obj = (BasicDBObject)cursor.next();
                ObjectId chrOid = obj.getObjectId("chron");
                Surrogate chronicle = this.makeSurrogate(db, DBObjectType.CHRONICLE, chrOid);
                try {
                    this.check(Permission.READ, chronicle);
                    result.add((Chronicle)new ChronicleImpl(chronicle));
                }
                catch (T2DBException e) {}
            }
        }
        catch (Exception e) {
            throw T2DBMsg.exception((Throwable)e, (String)"E40119", (Object[])new Object[]{property.getName(), value});
        }
        return result;
    }

    public <T> Series<T> getSeries(Surrogate s) throws T2DBException {
        BasicDBObject obj = (BasicDBObject)this.getObject(s, false);
        Exception cause = null;
        if (obj != null) {
            try {
                ObjectId chrOid = obj.getObjectId("chron");
                int serNum = obj.getInt("number");
                ChronicleImpl chronicle = new ChronicleImpl(this.makeSurrogate(s.getDatabase(), DBObjectType.CHRONICLE, chrOid));
                this.check(Permission.READ, (DBObject)chronicle);
                SeriesImpl series = new SeriesImpl((Chronicle)chronicle, null, serNum, s);
                return series;
            }
            catch (Exception e) {
                cause = e;
            }
        }
        throw T2DBMsg.exception((Throwable)cause, (String)"E40104", (Object[])new Object[]{s.toString()});
    }

    public <T> Series<T>[] getSeries(Chronicle chronicle, String[] names, int[] numbers) throws T2DBException {
        if (names.length != numbers.length) {
            throw new IllegalArgumentException("lengths of names[] and numbers[] differ");
        }
        SeriesImpl[] result = new SeriesImpl[numbers.length];
        if (result.length > 0) {
            HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
            for (int i = 0; i < numbers.length; ++i) {
                if (numbers[i] <= 0 || map.put(numbers[i], i) == null) continue;
                throw new IllegalArgumentException("duplicate number: " + numbers[i]);
            }
            Surrogate s = chronicle.getSurrogate();
            Database db = s.getDatabase();
            try {
                this.check(Permission.READ, (DBObject)chronicle);
            }
            catch (Exception e) {
                throw T2DBMsg.exception((Throwable)e, (String)"E40104", (Object[])new Object[]{s.toString()});
            }
            try {
                DBCursor cursor = this.getMongoDB(db).getSeries().find(this.mongoObject("chron", this.getId((DBObject)chronicle), "number", this.mongoObject(MongoDatabaseMethods.Operator.IN.op(), numbers)), this.mongoObject("number", 1));
                while (cursor.hasNext()) {
                    BasicDBObject obj = (BasicDBObject)cursor.next();
                    ObjectId serOid = obj.getObjectId("_id");
                    int serNumber = obj.getInt("number");
                    int i = (Integer)map.get(serNumber);
                    result[i] = new SeriesImpl(chronicle, names[i], numbers[i], this.makeSurrogate(db, DBObjectType.SERIES, serOid));
                }
            }
            catch (Exception e) {
                throw T2DBMsg.exception((Throwable)e, (String)"E40121", (Object[])new Object[]{chronicle.getName(true)});
            }
        }
        return result;
    }

    private Chronicle unpack(Database db, BasicDBObject obj) throws T2DBException {
        try {
            ObjectId id = obj.getObjectId("_id");
            Surrogate s = this.makeSurrogate(db, DBObjectType.CHRONICLE, id);
            ChronicleImpl.RawData data = new ChronicleImpl.RawData();
            data.setSurrogate(s);
            data.setName(obj.getString("name"));
            data.setDescription(obj.getString("desc"));
            ObjectId parentId = obj.getObjectId("parent");
            data.setCollection((Chronicle)(parentId == null ? db.getTopChronicle() : new ChronicleImpl(this.makeSurrogate(db, DBObjectType.CHRONICLE, parentId))));
            ObjectId schemaId = obj.getObjectId("schema");
            data.setSchema(schemaId == null ? null : this.makeSurrogate(db, DBObjectType.SCHEMA, schemaId));
            ChronicleImpl chronicle = new ChronicleImpl(data);
            return chronicle;
        }
        catch (ClassCastException e) {
            throw T2DBMMsg.exception(e, "J81010", obj.toString());
        }
    }

    private int findOffset(ObjectId id, List<Chronicle> chronicles) {
        int found = -1;
        int offset = 0;
        for (Chronicle chronicle : chronicles) {
            if (this.getId((DBObject)chronicle).equals((Object)id)) {
                found = offset;
                break;
            }
            ++offset;
        }
        if (found < 0) {
            throw new RuntimeException("chronicle not found: " + id);
        }
        return found;
    }
}

