/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.mongodb;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.T2DBMsg;
import ch.agent.crnickl.api.Attribute;
import ch.agent.crnickl.api.AttributeDefinition;
import ch.agent.crnickl.api.Chronicle;
import ch.agent.crnickl.api.DBObject;
import ch.agent.crnickl.api.DBObjectType;
import ch.agent.crnickl.api.Database;
import ch.agent.crnickl.api.DatabaseConfiguration;
import ch.agent.crnickl.api.Property;
import ch.agent.crnickl.api.Schema;
import ch.agent.crnickl.api.Series;
import ch.agent.crnickl.api.SeriesDefinition;
import ch.agent.crnickl.api.Surrogate;
import ch.agent.crnickl.api.UpdatableChronicle;
import ch.agent.crnickl.api.UpdatableProperty;
import ch.agent.crnickl.api.UpdatableSchema;
import ch.agent.crnickl.api.UpdatableSeries;
import ch.agent.crnickl.api.UpdatableValueType;
import ch.agent.crnickl.api.UpdateEvent;
import ch.agent.crnickl.api.UpdateEventOperation;
import ch.agent.crnickl.api.ValueType;
import ch.agent.crnickl.impl.DatabaseBackendImpl;
import ch.agent.crnickl.impl.SchemaUpdatePolicy;
import ch.agent.crnickl.impl.UpdateEventImpl;
import ch.agent.crnickl.impl.UpdateEventPublisherImpl;
import ch.agent.crnickl.mongodb.AccessMethodsForNumber;
import ch.agent.crnickl.mongodb.MongoDB;
import ch.agent.crnickl.mongodb.MongoDBSchemaUpdatePolicy;
import ch.agent.crnickl.mongodb.ReadMethodsForChroniclesAndSeries;
import ch.agent.crnickl.mongodb.ReadMethodsForProperty;
import ch.agent.crnickl.mongodb.ReadMethodsForSchema;
import ch.agent.crnickl.mongodb.ReadMethodsForValueType;
import ch.agent.crnickl.mongodb.WriteMethodsForChroniclesAndSeries;
import ch.agent.crnickl.mongodb.WriteMethodsForProperty;
import ch.agent.crnickl.mongodb.WriteMethodsForSchema;
import ch.agent.crnickl.mongodb.WriteMethodsForValueType;
import java.util.Collection;
import java.util.List;
import java.util.Random;

public class MongoDatabase
extends DatabaseBackendImpl {
    public static final String FLD_ID = "_id";
    public static final String COLL_CHRON = "CHRON";
    public static final String FLD_CHRON_NAME = "name";
    public static final String FLD_CHRON_DESC = "desc";
    public static final String FLD_CHRON_PARENT = "parent";
    public static final String FLD_CHRON_SCHEMA = "schema";
    public static final String COLL_SER = "SER";
    public static final String FLD_SER_CHRON = "chron";
    public static final String FLD_SER_NUM = "number";
    public static final String FLD_SER_FIRST = "first";
    public static final String FLD_SER_LAST = "last";
    public static final String FLD_SER_VALUES = "values";
    public static final String COLL_ATTR = "ATTR";
    public static final String FLD_ATTR_CHRON = "chron";
    public static final String FLD_ATTR_PROP = "prop";
    public static final String FLD_ATTR_VALUE = "val";
    public static final String FLD_ATTR_DESC = "descr";
    public static final String COLL_PROP = "PROP";
    public static final String FLD_PROP_NAME = "name";
    public static final String FLD_PROP_VT = "type";
    public static final String FLD_PROP_INDEXED = "indexed";
    public static final String COLL_SCHEMA = "SCH";
    public static final String FLD_SCHEMA_NAME = "name";
    public static final String FLD_SCHEMA_BASE = "base";
    public static final String FLD_SCHEMA_ATTRIBS = "attribs";
    public static final String FLD_SCHEMA_SERIES = "series";
    public static final String FLD_ATTRIBDEF_NUM = "num";
    public static final String FLD_ATTRIBDEF_PROP = "prop";
    public static final String FLD_ATTRIBDEF_VAL = "val";
    public static final String FLD_ATTRIBDEF_ERASING = "erasing";
    public static final String FLD_SERIESDEF_NUM = "num";
    public static final String FLD_SERIESDEF_DESC = "desc";
    public static final String FLD_SERIESDEF_ATTRIBS = "attribs";
    public static final String FLD_SERIESDEF_ERASING = "erasing";
    public static final String COLL_VT = "VT";
    public static final String FLD_VT_NAME = "name";
    public static final String FLD_VT_TYPE = "type";
    public static final String FLD_VT_VALUES = "values";
    public static final String DB_PARAM_IntInt_WAITING_DELAY_RANGE = "dbWaitingDelayRange";
    public static final String DB_PARAM_IntInt_WAITING_DELAY_RANGE_DEFAULT = "3000-6000";
    private ReadMethodsForChroniclesAndSeries esRMethods;
    private WriteMethodsForChroniclesAndSeries esWMethods;
    private ReadMethodsForValueType vtRMethods;
    private WriteMethodsForValueType vtWMethods;
    private ReadMethodsForProperty pRMethods;
    private WriteMethodsForProperty pWMethods;
    private ReadMethodsForSchema sRMethods;
    private WriteMethodsForSchema sWMethods;
    private MongoDB mongoDB;
    private MongoDBSchemaUpdatePolicy msup;
    private static Random random;
    private int minDelay = 3000;
    private int maxDelay = 6000;

    public MongoDatabase(String name) {
        super(name);
    }

    protected boolean isChronicleUpdatePolicyExtensionAllowed() {
        return false;
    }

    public void configure(DatabaseConfiguration configuration) throws T2DBException {
        super.configure(configuration);
        new MongoDB((Database)this, configuration);
        this.setAccessMethods(ValueType.StandardValueType.NUMBER.name(), new AccessMethodsForNumber());
        String parameter = configuration.getParameter(DB_PARAM_IntInt_WAITING_DELAY_RANGE, false);
        if (parameter == null) {
            parameter = DB_PARAM_IntInt_WAITING_DELAY_RANGE_DEFAULT;
        }
        try {
            String[] bounds = parameter.split("-");
            switch (bounds.length) {
                case 1: {
                    this.maxDelay = this.minDelay = new Integer(bounds[0]).intValue();
                    break;
                }
                case 2: {
                    this.minDelay = new Integer(bounds[0]);
                    this.maxDelay = new Integer(bounds[1]);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("min[-max] ?");
                }
            }
            if (this.minDelay > this.maxDelay) {
                throw new IllegalArgumentException("min<=max ?");
            }
        }
        catch (Exception e) {
            throw T2DBMsg.exception((Throwable)e, (String)"D00108", (Object[])new Object[]{DB_PARAM_IntInt_WAITING_DELAY_RANGE, parameter});
        }
    }

    public SchemaUpdatePolicy getSchemaUpdatePolicy() {
        if (this.msup == null) {
            this.msup = new MongoDBSchemaUpdatePolicy(this);
        }
        return this.msup;
    }

    public MongoDB getMongoDB() {
        if (this.mongoDB == null) {
            this.mongoDB = MongoDB.getInstance();
        }
        return this.mongoDB;
    }

    public void sleep() throws InterruptedException {
        int delay = this.maxDelay - this.minDelay;
        if (delay > 0 && random == null) {
            random = new Random();
        }
        int millis = this.minDelay + (delay > 0 ? random.nextInt(this.maxDelay - this.minDelay) : 0);
        Thread.sleep(millis);
    }

    public void commit() throws T2DBException {
        ((UpdateEventPublisherImpl)this.getUpdateEventPublisher()).release();
    }

    public void rollback() throws T2DBException {
    }

    protected ReadMethodsForChroniclesAndSeries getReadMethodsForChronicleAndSeries() {
        if (this.esRMethods == null) {
            this.esRMethods = new ReadMethodsForChroniclesAndSeries();
        }
        return this.esRMethods;
    }

    protected WriteMethodsForChroniclesAndSeries getWriteMethodsForChroniclesAndSeries() {
        if (this.esWMethods == null) {
            this.esWMethods = new WriteMethodsForChroniclesAndSeries();
        }
        return this.esWMethods;
    }

    public void create(UpdatableChronicle entity) throws T2DBException {
        this.getWriteMethodsForChroniclesAndSeries().createChronicle((Chronicle)entity);
        this.publish(new UpdateEventImpl(UpdateEventOperation.CREATE, (DBObject)entity).withComment(entity.getDescription(false)));
    }

    public void update(UpdatableChronicle entity) throws T2DBException {
        this.getWriteMethodsForChroniclesAndSeries().updateChronicle(entity, this.getChronicleUpdatePolicy());
        this.publish((UpdateEvent)new UpdateEventImpl(UpdateEventOperation.MODIFY, (DBObject)entity));
    }

    public void deleteAttributeValue(UpdatableChronicle entity, AttributeDefinition<?> def) throws T2DBException {
        this.getWriteMethodsForChroniclesAndSeries().deleteAttribute((Chronicle)entity, def);
        this.publish(new UpdateEventImpl(UpdateEventOperation.MODIFY, (DBObject)entity).withComment("delete attribute #" + def.getNumber()));
    }

    public void update(UpdatableChronicle entity, AttributeDefinition<?> def, String value, String description) throws T2DBException {
        this.getWriteMethodsForChroniclesAndSeries().updateAttribute(entity, def, value, description);
        this.publish(new UpdateEventImpl(UpdateEventOperation.MODIFY, (DBObject)entity).withComment(String.format("%s=%s", def.getProperty().getName(), value)));
    }

    public void deleteChronicle(UpdatableChronicle entity) throws T2DBException {
        this.getWriteMethodsForChroniclesAndSeries().deleteChronicle(entity, this.getChronicleUpdatePolicy());
        String comment = this.getNamingPolicy().joinValueAndDescription(entity.getName(true), entity.getDescription(false));
        this.publish(new UpdateEventImpl(UpdateEventOperation.DELETE, (DBObject)entity).withComment(comment));
    }

    public <T> void create(UpdatableSeries<T> series) throws T2DBException {
        this.getWriteMethodsForChroniclesAndSeries().createSeries((Series<?>)series);
        this.publish((UpdateEvent)new UpdateEventImpl(UpdateEventOperation.CREATE, series));
    }

    public <T> void deleteSeries(UpdatableSeries<T> series) throws T2DBException {
        this.getWriteMethodsForChroniclesAndSeries().deleteSeries(series, this.getChronicleUpdatePolicy());
        String comment = this.getNamingPolicy().joinValueAndDescription(series.getName(true), series.getDescription(false));
        this.publish(new UpdateEventImpl(UpdateEventOperation.DELETE, series).withComment(comment));
    }

    public Chronicle getChronicle(Chronicle chronicle) throws T2DBException {
        return this.getReadMethodsForChronicleAndSeries().getChronicle(chronicle.getSurrogate());
    }

    public Chronicle getChronicleOrNull(Chronicle parent, String simpleName) throws T2DBException {
        return this.getReadMethodsForChronicleAndSeries().getChronicleOrNull(parent, simpleName);
    }

    public Collection<Chronicle> getChroniclesByParent(Chronicle parent) throws T2DBException {
        return this.getReadMethodsForChronicleAndSeries().getChroniclesByParent(parent);
    }

    public <T> List<Chronicle> getChroniclesByAttributeValue(Property<T> property, T value, int maxSize) throws T2DBException {
        return this.getReadMethodsForChronicleAndSeries().getChroniclesByAttributeValue(property, value, maxSize);
    }

    public boolean getAttributeValue(List<Chronicle> chronicles, Attribute<?> attribute) throws T2DBException {
        return this.getReadMethodsForChronicleAndSeries().getAttributeValue(chronicles, attribute);
    }

    public <T> Series<T>[] getSeries(Chronicle chronicle, String[] names, int[] numbers) throws T2DBException {
        return this.getReadMethodsForChronicleAndSeries().getSeries(chronicle, names, numbers);
    }

    public <T> Series<T> getSeries(Surrogate surrogate) throws T2DBException {
        this.checkSurrogate(surrogate, DBObjectType.SERIES);
        Series series = this.getReadMethodsForChronicleAndSeries().getSeries(surrogate);
        if (series == null) {
            throw T2DBMsg.exception((String)"E50104", (Object[])new Object[]{surrogate.toString()});
        }
        return series;
    }

    protected ReadMethodsForProperty getReadMethodsForProperty() {
        if (this.pRMethods == null) {
            this.pRMethods = new ReadMethodsForProperty();
        }
        return this.pRMethods;
    }

    protected WriteMethodsForProperty getWriteMethodsForProperty() {
        if (this.pWMethods == null) {
            this.pWMethods = new WriteMethodsForProperty();
        }
        return this.pWMethods;
    }

    public Collection<Property<?>> getProperties(String pattern) throws T2DBException {
        return this.getReadMethodsForProperty().getProperties((Database)this, pattern);
    }

    public Property<?> getProperty(Surrogate surrogate) throws T2DBException {
        this.checkSurrogate(surrogate, DBObjectType.PROPERTY);
        Property vt = this.getReadMethodsForProperty().getProperty(surrogate);
        if (vt == null) {
            throw T2DBMsg.exception((String)"E20109", (Object[])new Object[]{surrogate.toString()});
        }
        return vt;
    }

    public Property<?> getProperty(String name) throws T2DBException {
        return this.getReadMethodsForProperty().getProperty((Database)this, name);
    }

    public void create(UpdatableProperty<?> property) throws T2DBException {
        this.getWriteMethodsForProperty().createProperty(property);
        this.publish((UpdateEvent)new UpdateEventImpl(UpdateEventOperation.CREATE, property));
    }

    public void deleteProperty(UpdatableProperty<?> property) throws T2DBException {
        this.getWriteMethodsForProperty().deleteProperty(property, this.getSchemaUpdatePolicy());
        String comment = property.getName();
        this.publish(new UpdateEventImpl(UpdateEventOperation.DELETE, property).withComment(comment));
    }

    public void update(UpdatableProperty<?> property) throws T2DBException {
        this.getWriteMethodsForProperty().updateProperty((Property<?>)property, this.getSchemaUpdatePolicy());
        this.publish((UpdateEvent)new UpdateEventImpl(UpdateEventOperation.MODIFY, property));
    }

    protected ReadMethodsForValueType getReadMethodsForValueType() {
        if (this.vtRMethods == null) {
            this.vtRMethods = new ReadMethodsForValueType();
        }
        return this.vtRMethods;
    }

    protected WriteMethodsForValueType getWriteMethodsForValueType() {
        if (this.vtWMethods == null) {
            this.vtWMethods = new WriteMethodsForValueType();
        }
        return this.vtWMethods;
    }

    public Collection<ValueType<?>> getValueTypes(String pattern) throws T2DBException {
        return this.getReadMethodsForValueType().getValueTypes((Database)this, pattern);
    }

    public <T> ValueType<T> getValueType(String name) throws T2DBException {
        ValueType vt = this.getReadMethodsForValueType().getValueType((Database)this, name);
        if (vt == null) {
            throw T2DBMsg.exception((String)"E10109", (Object[])new Object[]{name});
        }
        return vt;
    }

    public <T> ValueType<T> getValueType(Surrogate surrogate) throws T2DBException {
        this.checkSurrogate(surrogate, DBObjectType.VALUE_TYPE);
        ValueType vt = this.getReadMethodsForValueType().getValueType(surrogate);
        if (vt == null) {
            throw T2DBMsg.exception((String)"E10110", (Object[])new Object[]{surrogate.toString()});
        }
        return vt;
    }

    public <T> void create(UpdatableValueType<T> valueType) throws T2DBException {
        this.getWriteMethodsForValueType().createValueType(valueType);
        this.publish((UpdateEvent)new UpdateEventImpl(UpdateEventOperation.CREATE, valueType));
    }

    public void deleteValueType(UpdatableValueType<?> valueType) throws T2DBException {
        this.getWriteMethodsForValueType().deleteValueType(valueType, this.getSchemaUpdatePolicy());
        String comment = valueType.getName();
        this.publish(new UpdateEventImpl(UpdateEventOperation.DELETE, valueType).withComment(comment));
    }

    public void update(UpdatableValueType<?> valueType) throws T2DBException {
        this.getWriteMethodsForValueType().updateValueType(valueType, this.getSchemaUpdatePolicy());
        this.publish((UpdateEvent)new UpdateEventImpl(UpdateEventOperation.MODIFY, valueType));
    }

    protected ReadMethodsForSchema getReadMethodsForSchema() {
        if (this.sRMethods == null) {
            this.sRMethods = new ReadMethodsForSchema();
        }
        return this.sRMethods;
    }

    protected WriteMethodsForSchema getWriteMethodsForSchema() {
        if (this.sWMethods == null) {
            this.sWMethods = new WriteMethodsForSchema();
        }
        return this.sWMethods;
    }

    public Collection<Surrogate> getSchemaSurrogates(String pattern) throws T2DBException {
        return this.getReadMethodsForSchema().getSchemaSurrogateList((Database)this, pattern);
    }

    public UpdatableSchema getUpdatableSchema(Surrogate surrogate) throws T2DBException {
        UpdatableSchema schema = this.getReadMethodsForSchema().getSchema(surrogate);
        if (schema == null) {
            throw T2DBMsg.exception((String)"E30109", (Object[])new Object[]{surrogate.toString()});
        }
        return schema;
    }

    public void create(UpdatableSchema schema) throws T2DBException {
        this.getWriteMethodsForSchema().createSchema(schema);
        this.publish((UpdateEvent)new UpdateEventImpl(UpdateEventOperation.CREATE, (DBObject)schema));
    }

    public void update(UpdatableSchema schema) throws T2DBException {
        this.getWriteMethodsForSchema().updateSchema(schema, this.getSchemaUpdatePolicy());
        ((UpdateEventPublisherImpl)this.getUpdateEventPublisher()).publish((UpdateEvent)new UpdateEventImpl(UpdateEventOperation.MODIFY, (DBObject)schema), false);
    }

    public void deleteSchema(UpdatableSchema schema) throws T2DBException {
        this.getWriteMethodsForSchema().deleteSchema(schema, this.getSchemaUpdatePolicy());
        String comment = schema.getName();
        this.publish(new UpdateEventImpl(UpdateEventOperation.DELETE, (DBObject)schema).withComment(comment));
    }

    public Surrogate findChronicle(Schema schema) throws T2DBException {
        return this.getWriteMethodsForSchema().findChronicle(schema);
    }

    public Surrogate findChronicle(Property<?> property, Schema schema) throws T2DBException {
        return this.getWriteMethodsForSchema().findChronicle(property, schema);
    }

    public Surrogate findChronicle(SeriesDefinition ss, Schema schema) throws T2DBException {
        return this.getWriteMethodsForSchema().findChronicle(ss, schema);
    }

    public String toString() {
        return MongoDB.getInstance().toString();
    }
}

