/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.mongodb;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.T2DBMsg;
import ch.agent.crnickl.api.Database;
import ch.agent.crnickl.api.DatabaseConfiguration;
import ch.agent.crnickl.api.Surrogate;
import ch.agent.crnickl.api.UpdatableProperty;
import ch.agent.crnickl.api.UpdatableValueType;
import ch.agent.crnickl.api.ValueType;
import ch.agent.crnickl.mongodb.T2DBMMsg;
import ch.agent.t2.time.DateTime;
import ch.agent.t2.time.Day;
import ch.agent.t2.time.Month;
import ch.agent.t2.time.Workday;
import ch.agent.t2.time.Year;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.WriteConcern;

public class MongoDB {
    private DatabaseConfiguration configuration;
    private Mongo connection = null;
    private DBCollection properties;
    private DBCollection valueTypes;
    private DBCollection schemas;
    private DBCollection chronicles;
    private DBCollection series;
    private DBCollection attributes;
    private String user;
    public static final String MONGODB_HOST = "mongodb.host";
    public static final String MONGODB_PORT = "mongodb.port";
    public static final String MONGODB_DB = "mongodb.db";
    public static final String MONGODB_WRITE_CONCERN = "mongodb.writeConcern";
    public static final String MONGODB_USER = "mongodb.user";
    public static final String MONGODB_PASSWORD = "mongodb.password";

    private MongoDB() {
    }

    public MongoDB(Database database, DatabaseConfiguration configuration) throws T2DBException {
        if (Singleton.mongo_connection.configuration != null) {
            throw new IllegalStateException("already initialized");
        }
        Singleton.mongo_connection.configuration = configuration;
        Singleton.mongo_connection.open(database);
    }

    public static MongoDB getInstance() {
        if (Singleton.mongo_connection.configuration == null) {
            throw new IllegalStateException("not initialized");
        }
        return Singleton.mongo_connection;
    }

    private void open(Database database) throws T2DBException {
        try {
            String host = this.configuration.getParameter(MONGODB_HOST, false);
            String port = this.configuration.getParameter(MONGODB_PORT, false);
            this.connection = host != null ? (port != null ? new Mongo(host, Integer.parseInt(port)) : new Mongo(host)) : new Mongo();
            this.initialize(this.connection, database);
            this.user = this.configuration.getParameter(MONGODB_USER, true);
            this.configuration.getParameter(MONGODB_PASSWORD, true);
            this.configuration.setParameter(MONGODB_USER, "zzzzz");
            this.configuration.setParameter(MONGODB_PASSWORD, "zzzzz");
        }
        catch (Exception e) {
            throw T2DBMMsg.exception(e, "J80050", this.toString());
        }
    }

    private WriteConcern getWriteConcernFromKeyword(String keyword) throws T2DBException {
        WriteConcern wc = null;
        if (keyword == null) {
            keyword = "SAFE";
        }
        WriteConcernKeyword k = null;
        try {
            k = WriteConcernKeyword.valueOf(keyword);
        }
        catch (IllegalArgumentException e) {
            throw T2DBMMsg.exception(e, "J81020", keyword);
        }
        switch (k) {
            case NONE: {
                wc = WriteConcern.NONE;
                break;
            }
            case NORMAL: {
                wc = WriteConcern.NORMAL;
                break;
            }
            case SAFE: {
                wc = WriteConcern.SAFE;
                break;
            }
            case MAJORITY: {
                wc = WriteConcern.MAJORITY;
                break;
            }
            case FSYNC_SAFE: {
                wc = WriteConcern.FSYNC_SAFE;
                break;
            }
            case JOURNAL_SAFE: {
                wc = WriteConcern.JOURNAL_SAFE;
                break;
            }
            case REPLICAS_SAFE: {
                wc = WriteConcern.REPLICAS_SAFE;
                break;
            }
            default: {
                throw new RuntimeException("bug: " + k.name());
            }
        }
        if (wc != WriteConcern.SAFE) {
            throw T2DBMMsg.exception("J81021", keyword);
        }
        return wc;
    }

    private void initialize(Mongo mongo, Database database) throws T2DBException {
        DB db = mongo.getDB(this.configuration.getParameter(MONGODB_DB, true));
        db.setWriteConcern(this.getWriteConcernFromKeyword(this.configuration.getParameter(MONGODB_WRITE_CONCERN, false)));
        if (!db.collectionExists("VT")) {
            this.valueTypes = this.createCollection(db, "VT", "name");
            this.properties = this.createCollection(db, "PROP", "name");
            this.schemas = this.createCollection(db, "SCH", "name");
            this.chronicles = this.createCollection(db, "CHRON", "parent", "name");
            this.series = this.createCollection(db, "SER", "chron", "number");
            this.attributes = this.createCollection(db, "ATTR", "chron", "prop");
            this.createIndex(this.attributes, "prop", "val");
            this.createBuiltInValueTypes(database);
        } else {
            this.valueTypes = db.getCollection("VT");
            this.properties = db.getCollection("PROP");
            this.schemas = db.getCollection("SCH");
            this.chronicles = db.getCollection("CHRON");
            this.series = db.getCollection("SER");
            this.attributes = db.getCollection("ATTR");
        }
    }

    private void createBuiltInValueTypes(Database db) throws T2DBException {
        UpdatableValueType nameVT = db.createValueType("name", false, "NAME");
        nameVT.applyUpdates();
        UpdatableValueType typeVT = db.createValueType("type", true, "TYPE");
        typeVT.applyUpdates();
        UpdatableValueType tdVT = db.createValueType("timedomain", true, "TIMEDOMAIN");
        tdVT.addValue((Object)Day.DOMAIN, "daily");
        tdVT.addValue((Object)DateTime.DOMAIN, "date and time with second precision");
        tdVT.addValue((Object)Month.DOMAIN, "monthly");
        tdVT.addValue((Object)Workday.DOMAIN, "working days Monday-Friday");
        tdVT.addValue((Object)Year.DOMAIN, "yearly");
        tdVT.applyUpdates();
        UpdatableValueType binaryVT = db.createValueType("binary", false, "BOOLEAN");
        binaryVT.applyUpdates();
        UpdatableProperty symbolProp = db.createProperty("Symbol", (ValueType)nameVT, false);
        symbolProp.applyUpdates();
        UpdatableProperty typeProp = db.createProperty("Type", (ValueType)typeVT, false);
        typeProp.applyUpdates();
        UpdatableProperty calendarProp = db.createProperty("Calendar", (ValueType)tdVT, false);
        calendarProp.applyUpdates();
        UpdatableProperty sparseProp = db.createProperty("Sparsity", (ValueType)binaryVT, false);
        sparseProp.applyUpdates();
    }

    private DBCollection createCollection(DB db, String name, String ... keys) throws T2DBException {
        DBCollection coll = db.getCollection(name);
        if (keys.length > 0) {
            BasicDBObject index = new BasicDBObject();
            BasicDBObject options = new BasicDBObject();
            for (String key : keys) {
                index.put(key, (Object)1);
            }
            options.put("unique", (Object)1);
            coll.ensureIndex((DBObject)index, (DBObject)options);
        }
        return coll;
    }

    private void createIndex(DBCollection coll, String ... keys) throws T2DBException {
        if (keys.length > 0) {
            BasicDBObject index = new BasicDBObject();
            for (String key : keys) {
                index.put(key, (Object)1);
            }
            coll.ensureIndex((DBObject)index);
        }
    }

    public void close(boolean ignoreException) throws T2DBException {
        block3: {
            try {
                if (this.connection != null) {
                    this.connection.close();
                }
                this.connection = null;
            }
            catch (Exception e) {
                if (ignoreException) break block3;
                throw T2DBMsg.exception((String)"E00110", (Object[])new Object[]{this.toString()});
            }
        }
    }

    public void commit() throws T2DBException {
        throw T2DBMMsg.exception("J80100", new Object[0]);
    }

    public void rollback() throws T2DBException {
        throw T2DBMMsg.exception("J80100", new Object[0]);
    }

    public String getUser() {
        return this.user;
    }

    public DBCollection getValueTypes() {
        return this.valueTypes;
    }

    public DBCollection getProperties() {
        return this.properties;
    }

    public DBCollection getSchemas() {
        return this.schemas;
    }

    public DBCollection getChronicles() {
        return this.chronicles;
    }

    public DBCollection getSeries() {
        return this.series;
    }

    public DBCollection getAttributes() {
        return this.attributes;
    }

    public DBCollection getCollection(Surrogate s) throws T2DBException {
        switch (s.getDBObjectType()) {
            case CHRONICLE: {
                return this.chronicles;
            }
            case SERIES: {
                return this.series;
            }
            case SCHEMA: {
                return this.schemas;
            }
            case PROPERTY: {
                return this.properties;
            }
            case VALUE_TYPE: {
                return this.valueTypes;
            }
        }
        throw new RuntimeException("bug " + s.getDBObjectType());
    }

    public String toString() {
        return String.format("%s@%s", this.user, this.connection.toString());
    }

    private static enum WriteConcernKeyword {
        NONE,
        NORMAL,
        SAFE,
        MAJORITY,
        FSYNC_SAFE,
        JOURNAL_SAFE,
        REPLICAS_SAFE;

    }

    private static class Singleton {
        private static MongoDB mongo_connection = new MongoDB();

        private Singleton() {
        }
    }
}

