/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.jdbc;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.T2DBMsg;
import ch.agent.crnickl.api.DBObjectType;
import ch.agent.crnickl.api.Database;
import ch.agent.crnickl.api.Surrogate;
import ch.agent.crnickl.api.ValueType;
import ch.agent.crnickl.impl.ValueTypeImpl;
import ch.agent.crnickl.jdbc.JDBCDatabaseMethods;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class ReadMethodsForValueType
extends JDBCDatabaseMethods {
    private PreparedStatement select_valuetype_by_name;
    private static final String SELECT_VALUETYPE_BY_NAME = "select id, restricted, scanner, lastmod from value_type where label = ?";
    private PreparedStatement select_valuetype_by_pattern;
    private static final String SELECT_VALUETYPE_BY_PATTERN = "select id, label, restricted, scanner, lastmod from value_type where label like ? order by label";
    private PreparedStatement select_valuetype_by_id;
    private static final String SELECT_VALUETYPE_BY_ID = "select label, restricted, scanner, lastmod from value_type where id = ?";
    private PreparedStatement select_valuelist_by_id;
    private static final String SELECT_VALUELIST_BY_ID = "select value, descrip from value_type_value where type = ? order by value";

    public <T> ValueType<T> getValueType(Database database, String name) throws T2DBException {
        try {
            this.select_valuetype_by_name = this.open(SELECT_VALUETYPE_BY_NAME, database, this.select_valuetype_by_name);
            this.select_valuetype_by_name.setString(1, name);
            ResultSet rs = this.select_valuetype_by_name.executeQuery();
            if (rs.next()) {
                Surrogate surrogate = this.makeSurrogate(database, DBObjectType.VALUE_TYPE, rs.getInt(1));
                ValueType<T> valueType = this.getValueType(surrogate, name, rs.getBoolean(2), rs.getString(3));
                return valueType;
            }
            ValueType<T> valueType = null;
            return valueType;
        }
        catch (Exception e) {
            throw T2DBMsg.exception((Throwable)e, (String)"E10104", (Object[])new Object[]{name});
        }
        finally {
            this.select_valuetype_by_name = this.close(this.select_valuetype_by_name);
        }
    }

    public Collection<ValueType<?>> getValueTypes(Database database, String pattern) throws T2DBException {
        if (pattern == null) {
            pattern = "*";
        }
        pattern = pattern.replace('*', '%');
        ArrayList result = new ArrayList();
        try {
            this.select_valuetype_by_pattern = this.open(SELECT_VALUETYPE_BY_PATTERN, database, this.select_valuetype_by_pattern);
            this.select_valuetype_by_pattern.setString(1, pattern);
            ResultSet rs = this.select_valuetype_by_pattern.executeQuery();
            while (rs.next()) {
                Surrogate surrogate = this.makeSurrogate(database, DBObjectType.VALUE_TYPE, rs.getInt(1));
                result.add(this.getValueType(surrogate, rs.getString(2), rs.getBoolean(3), rs.getString(4)));
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        catch (Exception e) {
            throw T2DBMsg.exception((Throwable)e, (String)"E10106", (Object[])new Object[]{pattern});
        }
        finally {
            this.select_valuetype_by_pattern = this.close(this.select_valuetype_by_pattern);
        }
    }

    public <T> ValueType<T> getValueType(Surrogate surrogate) throws T2DBException {
        try {
            this.select_valuetype_by_id = this.open(SELECT_VALUETYPE_BY_ID, surrogate, this.select_valuetype_by_id);
            this.select_valuetype_by_id.setInt(1, this.getId(surrogate));
            ResultSet rs = this.select_valuetype_by_id.executeQuery();
            if (rs.next()) {
                ValueType<T> valueType = this.getValueType(surrogate, rs.getString(1), rs.getBoolean(2), rs.getString(3));
                return valueType;
            }
            ValueType<T> valueType = null;
            return valueType;
        }
        catch (Exception e) {
            throw T2DBMsg.exception((Throwable)e, (String)"E10105", (Object[])new Object[]{surrogate.toString()});
        }
        finally {
            this.select_valuetype_by_id = this.close(this.select_valuetype_by_id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getValues(Surrogate surrogate) throws T2DBException, SQLException {
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        try {
            this.select_valuelist_by_id = this.open(SELECT_VALUELIST_BY_ID, surrogate, this.select_valuelist_by_id);
            this.select_valuelist_by_id.setInt(1, this.getId(surrogate));
            ResultSet rs = this.select_valuelist_by_id.executeQuery();
            while (rs.next()) {
                values.put(rs.getString(1), rs.getString(2));
            }
        }
        finally {
            this.select_valuelist_by_id = this.close(this.select_valuelist_by_id);
        }
        return values;
    }

    private <T> ValueType<T> getValueType(Surrogate surrogate, String name, boolean restricted, String scannerClassOrKeyword) throws T2DBException, SQLException {
        Map<String, String> values = null;
        if (restricted) {
            values = this.getValues(surrogate);
        }
        return new ValueTypeImpl(name, restricted, scannerClassOrKeyword, values, surrogate);
    }
}

