/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.jdbc;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.T2DBMsg;
import ch.agent.crnickl.api.AttributeDefinition;
import ch.agent.crnickl.api.DBObjectType;
import ch.agent.crnickl.api.Database;
import ch.agent.crnickl.api.Property;
import ch.agent.crnickl.api.SeriesDefinition;
import ch.agent.crnickl.api.Surrogate;
import ch.agent.crnickl.api.UpdatableSchema;
import ch.agent.crnickl.impl.AttributeDefinitionImpl;
import ch.agent.crnickl.impl.SeriesDefinitionImpl;
import ch.agent.crnickl.impl.UpdatableSchemaImpl;
import ch.agent.crnickl.jdbc.JDBCDatabase;
import ch.agent.crnickl.jdbc.JDBCDatabaseMethods;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ReadMethodsForSchema
extends JDBCDatabaseMethods {
    private PreparedStatement select_schema_by_pattern;
    private static final String SELECT_SCHEMA_BY_PATTERN = "select id, parent, label from schema_name where label like ? order by label";
    private PreparedStatement select_schema_by_id;
    private static final String SELECT_SCHEMA_BY_ID = "select id, parent, label from schema_name where id = ?";
    private PreparedStatement select_schema_components;
    private static final String SELECT_SCHEMA_COMPONENTS = "select ssn, attrib, prop, value, descrip from schema_item where id = ? order by ssn, attrib";

    public UpdatableSchema getSchema(Surrogate surrogate) throws T2DBException {
        UpdatableSchema schema = null;
        RawSchema rawSchema = this.getRawSchema(surrogate);
        if (rawSchema != null) {
            schema = this.getSchema(surrogate.getDatabase(), rawSchema, null);
        }
        return schema;
    }

    public Collection<Surrogate> getSchemaSurrogateList(Database database, String pattern) throws T2DBException {
        Collection<RawSchema> rawSchemas = this.getRawSchemas(database, pattern);
        ArrayList<Surrogate> result = new ArrayList<Surrogate>(rawSchemas.size());
        for (RawSchema rs : rawSchemas) {
            result.add(this.makeSurrogate(database, DBObjectType.SCHEMA, rs.getId()));
        }
        return result;
    }

    private Collection<RawSchema> getRawSchemas(Database database, String pattern) throws T2DBException {
        this.select_schema_by_pattern = this.open(SELECT_SCHEMA_BY_PATTERN, database, this.select_schema_by_pattern);
        if (pattern == null) {
            pattern = "*";
        }
        pattern = pattern.replace('*', '%');
        ArrayList<RawSchema> result = new ArrayList<RawSchema>();
        try {
            this.select_schema_by_pattern.setString(1, pattern);
            ResultSet rs = this.select_schema_by_pattern.executeQuery();
            while (rs.next()) {
                result.add(new RawSchema(rs.getString(3), rs.getInt(1), rs.getInt(2)));
            }
            ArrayList<RawSchema> arrayList = result;
            return arrayList;
        }
        catch (Exception e) {
            throw T2DBMsg.exception((Throwable)e, (String)"E30105", (Object[])new Object[]{pattern});
        }
        finally {
            this.select_schema_by_pattern = this.close(this.select_schema_by_pattern);
        }
    }

    protected RawSchema getRawSchema(Surrogate surrogate) throws T2DBException {
        try {
            this.select_schema_by_id = this.open(SELECT_SCHEMA_BY_ID, surrogate, this.select_schema_by_id);
            this.select_schema_by_id.setInt(1, this.getId(surrogate));
            ResultSet rs = this.select_schema_by_id.executeQuery();
            if (rs.next()) {
                RawSchema rawSchema = new RawSchema(rs.getString(3), rs.getInt(1), rs.getInt(2));
                return rawSchema;
            }
            RawSchema rawSchema = null;
            return rawSchema;
        }
        catch (Exception e) {
            throw T2DBMsg.exception((Throwable)e, (String)"E30104", (Object[])new Object[]{surrogate.toString()});
        }
        finally {
            this.select_schema_by_id = this.close(this.select_schema_by_id);
        }
    }

    private RawSchemaComponents getRawSchemaComponents(Surrogate surrogate) throws T2DBException {
        ArrayList<RawSchemaComponent> result = new ArrayList<RawSchemaComponent>();
        try {
            this.select_schema_components = this.open(SELECT_SCHEMA_COMPONENTS, surrogate, this.select_schema_components);
            this.select_schema_components.setInt(1, this.getId(surrogate));
            ResultSet rs = this.select_schema_components.executeQuery();
            while (rs.next()) {
                result.add(new RawSchemaComponent(rs.getInt(1), rs.getInt(2), rs.getInt(3), rs.getString(4), rs.getString(5)));
            }
            RawSchemaComponents rawSchemaComponents = this.getRawSchemaComponents(result);
            return rawSchemaComponents;
        }
        catch (Exception e) {
            throw T2DBMsg.exception((Throwable)e, (String)"E30114", (Object[])new Object[]{surrogate.toString()});
        }
        finally {
            this.select_schema_components = this.close(this.select_schema_components);
        }
    }

    private RawSchemaComponents getRawSchemaComponents(Collection<RawSchemaComponent> list) throws T2DBException {
        RawSchemaComponents rscs = null;
        if (list.size() != 0) {
            rscs = new RawSchemaComponents();
            for (RawSchemaComponent rsc : list) {
                if (rsc.seriesNr == 0) {
                    rscs.attributes.add(rsc);
                    continue;
                }
                List<RawSchemaComponent> series = rscs.getSeries(rsc.seriesNr);
                series.add(rsc);
            }
        }
        return rscs;
    }

    private Collection<AttributeDefinition<?>> makeAttributeDefinitions(Database database, Collection<RawSchemaComponent> allAttr) throws T2DBException {
        ArrayList defs = new ArrayList();
        for (RawSchemaComponent oneAttr : allAttr) {
            AttributeDefinitionImpl def = null;
            if (oneAttr.propId < 1) {
                def = new AttributeDefinitionImpl(oneAttr.seriesNr, oneAttr.attribNr, null, null);
                def.edit();
                def.setErasing(true);
            } else {
                Property<?> property = ((JDBCDatabase)database).getReadMethodsForProperty().getProperty(this.makeSurrogate(database, DBObjectType.PROPERTY, oneAttr.propId));
                def = new AttributeDefinitionImpl(oneAttr.seriesNr, oneAttr.attribNr, property, property.getValueType().scan(oneAttr.value));
            }
            defs.add((AttributeDefinition<?>)def);
        }
        return defs;
    }

    private RawSchemaComponent find(List<RawSchemaComponent> list, int index) {
        RawSchemaComponent found = null;
        for (RawSchemaComponent rsc : list) {
            if (rsc.attribNr != index) continue;
            found = rsc;
            break;
        }
        return found;
    }

    private Collection<SeriesDefinition> makeSeriesSchemas(Database database, List<List<RawSchemaComponent>> allSeries) throws T2DBException {
        ArrayList<SeriesDefinition> schemas = new ArrayList<SeriesDefinition>();
        for (List<RawSchemaComponent> oneSeries : allSeries) {
            SeriesDefinitionImpl sch = null;
            String description = null;
            RawSchemaComponent rsc = this.find(oneSeries, 1);
            if (rsc != null) {
                if (rsc.propId < 1) {
                    sch = new SeriesDefinitionImpl(rsc.seriesNr, null, null);
                    sch.edit();
                    sch.setErasing(true);
                } else {
                    description = rsc.description;
                }
            }
            if (sch == null) {
                sch = new SeriesDefinitionImpl(oneSeries.get(0).seriesNr, description, this.makeAttributeDefinitions(database, oneSeries));
            }
            schemas.add((SeriesDefinition)sch);
        }
        return schemas;
    }

    private UpdatableSchema getSchema(Database database, RawSchema rawSchema, Set<Integer> cycleDetector) throws T2DBException {
        UpdatableSchemaImpl schema = null;
        if (cycleDetector == null) {
            cycleDetector = new HashSet<Integer>();
        }
        boolean cycleDetected = !cycleDetector.add(rawSchema.getId());
        String name = rawSchema.getName();
        UpdatableSchema base = null;
        if (rawSchema.getParent() > 0 && !cycleDetected) {
            Surrogate parentKey = this.makeSurrogate(database, DBObjectType.SCHEMA, rawSchema.getParent());
            RawSchema rawBaseSchema = this.getRawSchema(parentKey);
            if (rawBaseSchema == null) {
                throw T2DBMsg.exception((String)"E30116", (Object[])new Object[]{rawSchema.getParent(), name});
            }
            base = this.getSchema(database, rawBaseSchema, cycleDetector);
        }
        Surrogate surrogate = this.makeSurrogate(database, DBObjectType.SCHEMA, rawSchema.getId());
        RawSchemaComponents rawComponents = this.getRawSchemaComponents(surrogate);
        Collection<AttributeDefinition<?>> attributeDefs = null;
        Collection<SeriesDefinition> seriesDefinitions = null;
        if (rawComponents != null) {
            attributeDefs = this.makeAttributeDefinitions(database, rawComponents.attributes);
            seriesDefinitions = this.makeSeriesSchemas(database, rawComponents.series);
        }
        schema = new UpdatableSchemaImpl(name, base, attributeDefs, seriesDefinitions, surrogate);
        return schema;
    }

    private class RawSchemaComponents {
        private List<RawSchemaComponent> attributes = new ArrayList<RawSchemaComponent>();
        private List<List<RawSchemaComponent>> series = new ArrayList<List<RawSchemaComponent>>();

        public List<RawSchemaComponent> getSeries(int id) {
            List<Object> list = null;
            for (List<RawSchemaComponent> seriesAttrList : this.series) {
                if (seriesAttrList.size() <= 0 || seriesAttrList.get(0).seriesNr != id) continue;
                list = seriesAttrList;
                break;
            }
            if (list == null) {
                list = new ArrayList();
                this.series.add(list);
            }
            return list;
        }
    }

    private class RawSchemaComponent {
        private int seriesNr;
        private int attribNr;
        private int propId;
        private String value;
        private String description;

        public RawSchemaComponent(int seriesNr, int attribNr, int propId, String value, String description) {
            this.seriesNr = seriesNr;
            this.attribNr = attribNr;
            this.propId = propId;
            this.value = value;
            this.description = description;
        }
    }

    protected class RawSchema {
        private String name;
        private int id;
        private int parent;

        public RawSchema(String name, int id, int parent) {
            this.name = name;
            this.id = id;
            this.parent = parent;
        }

        protected String getName() {
            return this.name;
        }

        protected int getId() {
            return this.id;
        }

        protected int getParent() {
            return this.parent;
        }
    }
}

