/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.jdbc;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.T2DBMsg;
import ch.agent.crnickl.api.Attribute;
import ch.agent.crnickl.api.Chronicle;
import ch.agent.crnickl.api.DBObject;
import ch.agent.crnickl.api.DBObjectType;
import ch.agent.crnickl.api.Database;
import ch.agent.crnickl.api.Property;
import ch.agent.crnickl.api.Series;
import ch.agent.crnickl.api.Surrogate;
import ch.agent.crnickl.impl.ChronicleImpl;
import ch.agent.crnickl.impl.Permission;
import ch.agent.crnickl.impl.SeriesImpl;
import ch.agent.crnickl.jdbc.JDBCDatabaseMethods;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class ReadMethodsForChroniclesAndSeries
extends JDBCDatabaseMethods {
    private static int MAX_ENTITY_DEPTH = 6;
    private PreparedStatement select_entity_by_id;
    private static final String SELECT_ENTITY_BY_ID = "select parent, name, schema_id, descrip from chronicle where id = ?";
    private PreparedStatement select_entity_by_parent_and_name;
    private static final String SELECT_ENTITY_BY_PARENT_AND_NAME = "select id, schema_id, descrip from chronicle where parent = ? and name = ?";
    private PreparedStatement select_entities_by_parent;
    private static final String SELECT_ENTITIES_BY_PARENT = "select id, schema_id, name, descrip from chronicle where parent = ?";
    private PreparedStatement[] sel_attibute_prop_in_ent;
    private static final String SEL_ATTRIBUTE_BY_PROP_IN_ENT = "select chronicle, value, descrip from attribute_value where prop = ? and chronicle in (%s)";
    private PreparedStatement sel_entities_by_attribute;
    private static final String SEL_ENTITIES_BY_ATTRIBUTE = "select chronicle from attribute_value where value = ? and prop = ?";
    private PreparedStatement select_series_by_id;
    private static final String SELECT_SERIES_BY_ID = "select chronicle, ssn from series where id = ?";
    private PreparedStatement select_series_by_entity_and_nr;
    private static final String SELECT_SERIES_BY_ENTITY_AND_NR = "select id from series where chronicle = ? and ssn = ?";
    private PreparedStatement select_series_by_entity;
    private static final String SELECT_SERIES_BY_ENTITY = "select id, ssn from series where chronicle = ? order by ssn";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chronicle getChronicle(Surrogate surrogate) throws T2DBException {
        ChronicleImpl chronicle = null;
        SQLException cause = null;
        try {
            this.select_entity_by_id = this.open(SELECT_ENTITY_BY_ID, surrogate, this.select_entity_by_id);
            this.select_entity_by_id.setInt(1, this.getId(surrogate));
            ResultSet rs = this.select_entity_by_id.executeQuery();
            if (rs.next()) {
                ChronicleImpl.RawData data = new ChronicleImpl.RawData();
                data.setSurrogate(surrogate);
                data.setName(rs.getString(2));
                data.setDescription(rs.getString(4));
                int collection = rs.getInt(1);
                data.setCollection((Chronicle)(collection == 0 ? surrogate.getDatabase().getTopChronicle() : new ChronicleImpl(this.makeSurrogate(surrogate.getDatabase(), DBObjectType.CHRONICLE, collection))));
                int schema = rs.getInt(3);
                data.setSchema(schema == 0 ? null : this.makeSurrogate(surrogate.getDatabase(), DBObjectType.SCHEMA, schema));
                chronicle = new ChronicleImpl(data);
                this.check(Permission.READ, (DBObject)chronicle);
            }
            rs.close();
        }
        catch (SQLException e) {
            cause = e;
        }
        finally {
            this.select_entity_by_id = this.close(this.select_entity_by_id);
        }
        if (chronicle == null || cause != null) {
            throw T2DBMsg.exception((Throwable)cause, (String)"E40104", (Object[])new Object[]{surrogate.toString()});
        }
        return chronicle;
    }

    public Chronicle getChronicleOrNull(Chronicle parent, String name) throws T2DBException {
        ChronicleImpl chronicle = null;
        try {
            this.select_entity_by_parent_and_name = this.open(SELECT_ENTITY_BY_PARENT_AND_NAME, (DBObject)parent, this.select_entity_by_parent_and_name);
            this.select_entity_by_parent_and_name.setInt(1, this.getIdOrZero((DBObject)parent));
            this.select_entity_by_parent_and_name.setString(2, name);
            ResultSet rs = this.select_entity_by_parent_and_name.executeQuery();
            if (rs.next()) {
                int id = rs.getInt(1);
                if (id == 0) {
                    throw T2DBMsg.exception((String)"E40105", (Object[])new Object[]{parent == null ? null : parent.toString(), name});
                }
                Surrogate surrogate = this.makeSurrogate(parent.getSurrogate().getDatabase(), DBObjectType.CHRONICLE, id);
                ChronicleImpl.RawData data = new ChronicleImpl.RawData();
                data.setSurrogate(surrogate);
                int schema = rs.getInt(2);
                data.setCollection(parent);
                data.setSchema(schema == 0 ? null : this.makeSurrogate(parent.getSurrogate().getDatabase(), DBObjectType.SCHEMA, schema));
                data.setName(name);
                data.setDescription(rs.getString(3));
                chronicle = new ChronicleImpl(data);
                boolean permitted = this.check(Permission.READ, (DBObject)chronicle, false);
                if (!permitted) {
                    chronicle = null;
                }
            }
            rs.close();
        }
        catch (SQLException e) {
            throw T2DBMsg.exception((Throwable)e, (String)"E40123", (Object[])new Object[]{name, parent.getName(true)});
        }
        finally {
            this.select_entity_by_parent_and_name = this.close(this.select_entity_by_parent_and_name);
        }
        return chronicle;
    }

    public Collection<Chronicle> getChroniclesByParent(Chronicle parent) throws T2DBException {
        ArrayList<Chronicle> result = new ArrayList<Chronicle>();
        if (this.check(Permission.DISCOVER, (DBObject)parent, false)) {
            try {
                this.select_entities_by_parent = this.open(SELECT_ENTITIES_BY_PARENT, (DBObject)parent, this.select_entities_by_parent);
                this.select_entities_by_parent.setInt(1, this.getIdOrZero((DBObject)parent));
                ResultSet rs = this.select_entities_by_parent.executeQuery();
                Database database = parent.getSurrogate().getDatabase();
                while (rs.next()) {
                    int id = rs.getInt(1);
                    if (id == 0) {
                        throw T2DBMsg.exception((String)"E40105", (Object[])new Object[]{parent == null ? null : parent.toString(), rs.getString(3)});
                    }
                    Surrogate surrogate = this.makeSurrogate(database, DBObjectType.CHRONICLE, id);
                    ChronicleImpl.RawData data = new ChronicleImpl.RawData();
                    data.setSurrogate(surrogate);
                    int schema = rs.getInt(2);
                    data.setCollection(parent);
                    data.setSchema(schema == 0 ? null : this.makeSurrogate(database, DBObjectType.SCHEMA, schema));
                    data.setName(rs.getString(3));
                    data.setDescription(rs.getString(4));
                    ChronicleImpl chronicle = new ChronicleImpl(data);
                    this.check(Permission.READ, (DBObject)chronicle);
                    result.add((Chronicle)chronicle);
                }
                rs.close();
            }
            catch (SQLException e) {
                throw T2DBMsg.exception((Throwable)e, (String)"E40122", (Object[])new Object[]{parent.getName(true)});
            }
            finally {
                this.select_entities_by_parent = this.close(this.select_entities_by_parent);
            }
        }
        return result;
    }

    public boolean getAttributeValue(List<Chronicle> chronicles, Attribute<?> attribute) throws T2DBException {
        Database db = null;
        if (this.sel_attibute_prop_in_ent == null) {
            this.sel_attibute_prop_in_ent = new PreparedStatement[MAX_ENTITY_DEPTH];
        }
        int found = 0;
        int size = chronicles.size();
        if (size == 0) {
            throw new IllegalArgumentException("entities list empty");
        }
        try {
            String sql = null;
            PreparedStatement stmt = null;
            int[] ids = new int[size];
            db = chronicles.get(0).getSurrogate().getDatabase();
            if (size > MAX_ENTITY_DEPTH) {
                stmt = this.sel_attibute_prop_in_ent[0];
                if (stmt != null && stmt.getParameterMetaData().getParameterCount() != size + 1) {
                    stmt = null;
                }
                sql = String.format(SEL_ATTRIBUTE_BY_PROP_IN_ENT, this.repeat("?", ",", size));
                this.sel_attibute_prop_in_ent[0] = stmt = this.open(sql, db, stmt);
            } else {
                stmt = this.sel_attibute_prop_in_ent[size];
                sql = String.format(SEL_ATTRIBUTE_BY_PROP_IN_ENT, this.repeat("?", ",", size));
                this.sel_attibute_prop_in_ent[size] = stmt = this.open(sql, db, stmt);
            }
            stmt.setInt(1, this.getId((DBObject)attribute.getProperty()));
            for (int i = 0; i < size; ++i) {
                ids[i] = this.getId((DBObject)chronicles.get(i));
                stmt.setInt(2 + i, ids[i]);
            }
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                int name = rs.getInt(1);
                if (name == 0) {
                    stmt.close();
                    stmt = null;
                    throw T2DBMsg.exception((String)"E40106", (Object[])new Object[]{sql});
                }
                if (found != 0 && !this.moreSpecific(ids, name, found)) continue;
                found = name;
                attribute.scan((Object)rs.getString(2));
                String description = rs.getString(3);
                if (description.length() <= 0) continue;
                attribute.setDescription(description);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw T2DBMsg.exception((Throwable)e, (String)"E40120", (Object[])new Object[]{attribute.getProperty().getName()});
        }
        finally {
            if (size > MAX_ENTITY_DEPTH) {
                this.sel_attibute_prop_in_ent[0] = this.close(this.sel_attibute_prop_in_ent[0]);
            } else if (size > 0) {
                this.sel_attibute_prop_in_ent[size] = this.close(this.sel_attibute_prop_in_ent[size]);
            }
        }
        if (found > 0) {
            Surrogate s = this.makeSurrogate(db, DBObjectType.CHRONICLE, found);
            this.check(Permission.READ, s);
        }
        return found > 0;
    }

    public <T> List<Chronicle> getChroniclesByAttributeValue(Property<T> property, T value, int maxSize) throws T2DBException {
        ArrayList<Chronicle> chronicles = new ArrayList<Chronicle>();
        String stringValue = property.getValueType().toString(value);
        try {
            this.sel_entities_by_attribute = this.open(SEL_ENTITIES_BY_ATTRIBUTE, (DBObject)property, this.sel_entities_by_attribute);
            this.sel_entities_by_attribute.setString(1, stringValue);
            this.sel_entities_by_attribute.setInt(2, this.getId((DBObject)property));
            ResultSet rs = this.sel_entities_by_attribute.executeQuery();
            while (rs.next()) {
                Surrogate surrogate = this.makeSurrogate(property.getSurrogate().getDatabase(), DBObjectType.CHRONICLE, rs.getInt(1));
                ChronicleImpl chronicle = new ChronicleImpl(surrogate);
                this.check(Permission.READ, (DBObject)chronicle);
                chronicles.add((Chronicle)chronicle);
                if (maxSize <= 0 || chronicles.size() < maxSize) continue;
                break;
            }
            rs.close();
        }
        catch (SQLException e) {
            throw T2DBMsg.exception((Throwable)e, (String)"E40119", (Object[])new Object[]{property.getName(), value});
        }
        finally {
            this.sel_entities_by_attribute = this.close(this.sel_entities_by_attribute);
        }
        return chronicles;
    }

    private boolean moreSpecific(int[] ids, int a, int b) {
        for (int id : ids) {
            if (a == id) {
                return true;
            }
            if (b != id) continue;
            return false;
        }
        throw new RuntimeException("bug");
    }

    private String repeat(String s, String separator, int times) {
        if (times < 1) {
            throw new IllegalArgumentException("times not positive");
        }
        StringBuilder b = new StringBuilder();
        int i = times - 1;
        while (i-- > 0) {
            if (s != null) {
                b.append(s);
            }
            if (separator == null) continue;
            b.append(separator);
        }
        if (s != null) {
            b.append(s);
        }
        return b.toString();
    }

    public <T> Series<T> getSeries(Surrogate surrogate) throws T2DBException {
        try {
            this.select_series_by_id = this.open(SELECT_SERIES_BY_ID, surrogate, this.select_series_by_id);
            int id = this.getId(surrogate);
            this.select_series_by_id.setInt(1, id);
            ResultSet rs = this.select_series_by_id.executeQuery();
            if (rs.next()) {
                ChronicleImpl chronicle = new ChronicleImpl(this.makeSurrogate(surrogate.getDatabase(), DBObjectType.CHRONICLE, rs.getInt(1)));
                SeriesImpl seriesImpl = new SeriesImpl((Chronicle)chronicle, null, rs.getInt(2), surrogate);
                return seriesImpl;
            }
            Series<T> series = null;
            return series;
        }
        catch (SQLException e) {
            throw T2DBMsg.exception((Throwable)e, (String)"E50119", (Object[])new Object[]{surrogate.toString()});
        }
        finally {
            this.select_series_by_id = this.close(this.select_series_by_id);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> Series<T>[] getSeries(Chronicle chronicle, String[] names, int[] numbers) throws T2DBException {
        if (names.length != numbers.length) {
            throw new IllegalArgumentException("names and numbers emtpy or unequally sized arrays");
        }
        SeriesImpl[] result = new SeriesImpl[numbers.length];
        int entityId = this.getId((DBObject)chronicle);
        try {
            switch (numbers.length) {
                case 0: {
                    return result;
                }
                case 1: {
                    this.select_series_by_entity_and_nr = this.open(SELECT_SERIES_BY_ENTITY_AND_NR, (DBObject)chronicle, this.select_series_by_entity_and_nr);
                    this.select_series_by_entity_and_nr.setInt(1, entityId);
                    this.select_series_by_entity_and_nr.setInt(2, numbers[0]);
                    ResultSet rs = this.select_series_by_entity_and_nr.executeQuery();
                    if (!rs.next()) return result;
                    result[0] = new SeriesImpl(chronicle, names[0], numbers[0], this.makeSurrogate(chronicle.getSurrogate().getDatabase(), DBObjectType.SERIES, rs.getInt(1)));
                    return result;
                }
                default: {
                    this.select_series_by_entity = this.open(SELECT_SERIES_BY_ENTITY, (DBObject)chronicle, this.select_series_by_entity);
                    this.select_series_by_entity.setInt(1, entityId);
                    ResultSet rs = this.select_series_by_entity.executeQuery();
                    HashMap<Integer, Integer> index = new HashMap<Integer, Integer>(numbers.length);
                    for (int i = 0; i < numbers.length; ++i) {
                        index.put(numbers[i], i);
                    }
                    while (rs.next()) {
                        Integer i = (Integer)index.get(rs.getInt(2));
                        if (i == null) continue;
                        result[i.intValue()] = new SeriesImpl(chronicle, names[i], numbers[i], this.makeSurrogate(chronicle.getSurrogate().getDatabase(), DBObjectType.SERIES, rs.getInt(1)));
                    }
                    rs.close();
                    return result;
                }
            }
        }
        catch (SQLException e) {
            throw T2DBMsg.exception((Throwable)e, (String)"E40121", (Object[])new Object[]{chronicle.getName(true)});
        }
        finally {
            this.select_series_by_entity_and_nr = this.close(this.select_series_by_entity_and_nr);
            this.select_series_by_entity = this.close(this.select_series_by_entity);
        }
    }
}

