/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.jdbc;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.T2DBMsg;
import ch.agent.crnickl.api.DBObject;
import ch.agent.crnickl.api.Property;
import ch.agent.crnickl.api.ValueType;
import ch.agent.crnickl.impl.DatabaseBackend;
import ch.agent.crnickl.impl.SchemaUpdatePolicyImpl;
import ch.agent.crnickl.jdbc.JDBCDatabase;
import ch.agent.crnickl.jdbc.JDBCDatabaseMethods;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class JDBCSchemaUpdatePolicy
extends SchemaUpdatePolicyImpl {
    private JDBCDatabaseMethods methods;
    private PreparedStatement count_default_values;
    private static final String COUNT_DEFAULT_VALUES = "select count(*) from schema_item s, property p where s.prop = p.id and p.type = ? and s.value = ?";
    private PreparedStatement count_actual_values;
    private static final String COUNT_ACTUAL_VALUES = "select count(*) from property p, attribute_value a  where a.value = ? and p.type = ? and p.id = a.prop";
    private PreparedStatement count_property;
    private static final String COUNT_PROPERTY = "select count(*) from property where type = ?";
    private PreparedStatement count_slot;
    private static final String COUNT_SLOT = "select count(*) from schema_item where prop = ?";

    public JDBCSchemaUpdatePolicy(JDBCDatabase database) {
        super((DatabaseBackend)database);
        this.methods = database.getReadMethodsForProperty();
    }

    public <T> void willDelete(Property<T> property) throws T2DBException {
        super.willDelete(property);
        if (this.countProperties(property) > 0) {
            throw T2DBMsg.exception((String)"E20119", (Object[])new Object[]{property.getName()});
        }
    }

    public <T> void willDelete(ValueType<T> valueType) throws T2DBException {
        super.willDelete(valueType);
        if (this.countProperties(valueType) > 0) {
            throw T2DBMsg.exception((String)"E10149", (Object[])new Object[]{valueType.getName()});
        }
    }

    public <T> void willDelete(ValueType<T> vt, T value) throws T2DBException {
        super.willDelete(vt, value);
        String name = vt.getName();
        if (this.countDefaultValues(vt, vt.toString(value)) > 0) {
            throw T2DBMsg.exception((String)"E10157", (Object[])new Object[]{name, value});
        }
        if (this.countActualValues(vt, vt.toString(value)) > 0) {
            throw T2DBMsg.exception((String)"E10158", (Object[])new Object[]{name, value});
        }
    }

    private <T> int countDefaultValues(ValueType<T> vt, String value) throws T2DBException {
        try {
            this.count_default_values = this.methods.open(COUNT_DEFAULT_VALUES, (DBObject)vt, this.count_default_values);
            this.count_default_values.setInt(1, this.methods.getId((DBObject)vt));
            this.count_default_values.setString(2, value);
            ResultSet rs = this.count_default_values.executeQuery();
            rs.next();
            int n = rs.getInt(1);
            return n;
        }
        catch (SQLException e) {
            throw T2DBMsg.exception((Throwable)e, (String)"E10107", (Object[])new Object[]{vt.getName()});
        }
        finally {
            this.count_default_values = this.methods.close(this.count_default_values);
        }
    }

    private <T> int countActualValues(ValueType<T> vt, String value) throws T2DBException {
        try {
            this.count_actual_values = this.methods.open(COUNT_ACTUAL_VALUES, (DBObject)vt, this.count_actual_values);
            this.count_actual_values.setString(1, value);
            this.count_actual_values.setInt(2, this.methods.getId((DBObject)vt));
            ResultSet rs = this.count_actual_values.executeQuery();
            rs.next();
            int n = rs.getInt(1);
            return n;
        }
        catch (SQLException e) {
            throw T2DBMsg.exception((Throwable)e, (String)"E10107", (Object[])new Object[]{vt.getName()});
        }
        finally {
            this.count_actual_values = this.methods.close(this.count_actual_values);
        }
    }

    private int countProperties(ValueType<?> vt) throws T2DBException {
        try {
            this.count_property = this.methods.open(COUNT_PROPERTY, (DBObject)vt, this.count_property);
            this.count_property.setInt(1, this.methods.getId((DBObject)vt));
            ResultSet rs = this.count_property.executeQuery();
            rs.next();
            int n = rs.getInt(1);
            return n;
        }
        catch (SQLException e) {
            throw T2DBMsg.exception((Throwable)e, (String)"E10107", (Object[])new Object[]{vt.getName()});
        }
        finally {
            this.count_property = this.methods.close(this.count_property);
        }
    }

    private <T> int countProperties(Property<T> property) throws T2DBException {
        try {
            this.count_slot = this.methods.open(COUNT_SLOT, (DBObject)property, this.count_slot);
            this.count_slot.setInt(1, this.methods.getId((DBObject)property));
            ResultSet rs = this.count_slot.executeQuery();
            rs.next();
            int n = rs.getInt(1);
            return n;
        }
        catch (SQLException e) {
            throw T2DBMsg.exception((Throwable)e, (String)"E20107", (Object[])new Object[]{property.getName()});
        }
        finally {
            this.count_slot = this.methods.close(this.count_slot);
        }
    }
}

