/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.jdbc;

import ch.agent.crnickl.api.DBObjectId;
import ch.agent.crnickl.jdbc.T2DBJException;
import ch.agent.crnickl.jdbc.T2DBJMsg;

public class JDBCObjectId
implements DBObjectId {
    private int id;

    public JDBCObjectId(int id) {
        if (id < 1) {
            throw new IllegalArgumentException("id < 1");
        }
        this.id = id;
    }

    private static int asInt(Object object) throws T2DBJException {
        try {
            return (Integer)object;
        }
        catch (Throwable discard) {
            try {
                return Integer.parseInt((String)object);
            }
            catch (Throwable t) {
                throw T2DBJMsg.exception(t, "D02105", object == null ? "null" : object.toString());
            }
        }
    }

    public JDBCObjectId(Object object) throws T2DBJException {
        this(JDBCObjectId.asInt(object));
    }

    public int value() {
        return this.id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JDBCObjectId other = (JDBCObjectId)obj;
        return this.id == other.id;
    }

    public String toString() {
        return "" + this.id;
    }
}

