/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.jdbc;

import ch.agent.core.KeyedException;
import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.T2DBMsg;
import ch.agent.crnickl.api.DBObject;
import ch.agent.crnickl.api.Series;
import ch.agent.crnickl.api.UpdatableSeries;
import ch.agent.crnickl.impl.ChronicleUpdatePolicy;
import ch.agent.crnickl.impl.Permission;
import ch.agent.crnickl.impl.ValueAccessMethods;
import ch.agent.crnickl.jdbc.JDBCDatabaseMethods;
import ch.agent.t2.time.Range;
import ch.agent.t2.time.TimeDomain;
import ch.agent.t2.time.TimeIndex;
import ch.agent.t2.timeseries.Observation;
import ch.agent.t2.timeseries.TimeAddressable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class AccessMethodsForNumber
extends JDBCDatabaseMethods
implements ValueAccessMethods<Double> {
    private PreparedStatement select_range;
    private static final String SELECT_RANGE = "select min(date), max(date) from value_double where series = ?";
    private PreparedStatement select_double_by_range;
    private static final String SELECT_DOUBLE_BY_RANGE = "select date, element from value_double where series = ? and date between ? and ? order by date";
    private PreparedStatement select_double;
    private static final String SELECT_DOUBLE = "select date, element from value_double where series = ? order by date";
    private PreparedStatement select_first_double1;
    private static final String SELECT_FIRST_DOUBLE_1 = "select date, element from value_double where series = ? and date = (select min(date) from value_double where series = ? and date >= ?)";
    private PreparedStatement select_first_double2;
    private static final String SELECT_FIRST_DOUBLE_2 = "select date, element from value_double where series = ? and date = (select min(date) from value_double where series = ?)";
    private PreparedStatement select_last_double1;
    private static final String SELECT_LAST_DOUBLE_1 = "select date, element from value_double where series = ? and date = (select max(date) from value_double where series = ? and date <= ?)";
    private PreparedStatement select_last_double2;
    private static final String SELECT_LAST_DOUBLE_2 = "select date, element from value_double where series = ? and date = (select max(date) from value_double where series = ?)";
    private PreparedStatement delete_values_by_t;
    private static final String DELETE_VALUES_BY_T = "delete from value_double where series = ? and date = ?";
    private PreparedStatement update_series_range;
    private static final String UPDATE_SERIES_RANGE = "delete from value_double where series = ? and (date < ? or date > ?)";
    private PreparedStatement insert_value;
    private static final String INSERT_VALUE = "insert into value_double (series, date, element) values(?, ?, ?)";
    private PreparedStatement update_value;
    private static final String UPDATE_VALUE = "update value_double set element = ? where series = ? and date = ? and element != ?";

    public Range getRange(Series<Double> series) throws T2DBException {
        Range range = null;
        TimeDomain timeDomain = series.getTimeDomain();
        try {
            this.select_range = this.open(SELECT_RANGE, (DBObject)series, this.select_range);
            this.select_range.setInt(1, this.getId((DBObject)series));
            ResultSet rs = this.select_range.executeQuery();
            if (rs.next()) {
                range = new Range(timeDomain.timeFromOffset((long)rs.getInt(1)), timeDomain.timeFromOffset((long)rs.getInt(2)));
                if (rs.wasNull()) {
                    range = null;
                }
            }
        }
        catch (Exception e) {
            throw T2DBMsg.exception((Throwable)e, (String)"E50122", (Object[])new Object[]{series.getName(true)});
        }
        finally {
            this.select_range = this.close(this.select_range);
        }
        if (range == null) {
            range = new Range(series.getTimeDomain());
        }
        return range;
    }

    public long getValues(Series<Double> series, Range range, TimeAddressable<Double> ts) throws T2DBException {
        if (range != null && range.isEmpty()) {
            return 0L;
        }
        long count = 0L;
        try {
            ResultSet rs;
            this.check(Permission.READ, (DBObject)series);
            if (range == null) {
                this.select_double = this.open(SELECT_DOUBLE, (DBObject)series, this.select_double);
                this.select_double.setInt(1, this.getId((DBObject)series));
                rs = this.select_double.executeQuery();
            } else {
                this.select_double_by_range = this.open(SELECT_DOUBLE_BY_RANGE, (DBObject)series, this.select_double_by_range);
                this.select_double_by_range.setInt(1, this.getId((DBObject)series));
                this.select_double_by_range.setInt(2, range.getFirst().asOffset());
                this.select_double_by_range.setInt(3, range.getLast().asOffset());
                rs = this.select_double_by_range.executeQuery();
            }
            while (rs.next()) {
                ts.put(ts.getTimeDomain().timeFromOffset((long)rs.getInt(1)), (Object)rs.getDouble(2));
                ++count;
            }
        }
        catch (Exception e) {
            if (range == null) {
                throw T2DBMsg.exception((Throwable)e, (String)"E50121", (Object[])new Object[]{series.getName(true)});
            }
            throw T2DBMsg.exception((Throwable)e, (String)"E50120", (Object[])new Object[]{series.getName(true), range.toString()});
        }
        finally {
            this.select_double = this.close(this.select_double);
            this.select_double_by_range = this.close(this.select_double_by_range);
        }
        return count;
    }

    public Observation<Double> getFirst(Series<Double> series, TimeIndex time) throws T2DBException {
        Observation obs = null;
        try {
            ResultSet rs;
            this.check(Permission.READ, (DBObject)series);
            int sid = this.getId((DBObject)series);
            if (time != null) {
                this.select_first_double1 = this.open(SELECT_FIRST_DOUBLE_1, (DBObject)series, this.select_first_double1);
                this.select_first_double1.setInt(1, sid);
                this.select_first_double1.setInt(2, sid);
                this.select_first_double1.setInt(3, time.asOffset());
                rs = this.select_first_double1.executeQuery();
            } else {
                this.select_first_double2 = this.open(SELECT_FIRST_DOUBLE_2, (DBObject)series, this.select_first_double2);
                this.select_first_double2.setInt(1, sid);
                this.select_first_double2.setInt(2, sid);
                rs = this.select_first_double2.executeQuery();
            }
            if (rs.next()) {
                TimeDomain dom = time == null ? series.getTimeDomain() : time.getTimeDomain();
                TimeIndex t = dom.timeFromOffset((long)rs.getInt(1));
                obs = new Observation(t, (Object)rs.getDouble(2));
            }
        }
        catch (Exception e) {
            throw T2DBMsg.exception((Throwable)e, (String)"E50123", (Object[])new Object[]{series.getName(true), time.toString()});
        }
        finally {
            this.select_first_double1 = this.close(this.select_first_double1);
            this.select_first_double2 = this.close(this.select_first_double2);
        }
        return obs;
    }

    public Observation<Double> getLast(Series<Double> series, TimeIndex time) throws T2DBException {
        Observation obs = null;
        try {
            ResultSet rs;
            this.check(Permission.READ, (DBObject)series);
            int sid = this.getId((DBObject)series);
            if (time != null) {
                this.select_last_double1 = this.open(SELECT_LAST_DOUBLE_1, (DBObject)series, this.select_last_double1);
                this.select_last_double1.setInt(1, sid);
                this.select_last_double1.setInt(2, sid);
                this.select_last_double1.setInt(3, time.asOffset());
                rs = this.select_last_double1.executeQuery();
            } else {
                this.select_last_double2 = this.open(SELECT_LAST_DOUBLE_2, (DBObject)series, this.select_last_double2);
                this.select_last_double2.setInt(1, sid);
                this.select_last_double2.setInt(2, sid);
                rs = this.select_last_double2.executeQuery();
            }
            if (rs.next()) {
                TimeDomain dom = time == null ? series.getTimeDomain() : time.getTimeDomain();
                TimeIndex t = dom.timeFromOffset((long)rs.getInt(1));
                obs = new Observation(t, (Object)rs.getDouble(2));
            }
        }
        catch (Exception e) {
            throw T2DBMsg.exception((Throwable)e, (String)"E50124", (Object[])new Object[]{series.getName(true), time.toString()});
        }
        finally {
            this.select_last_double1 = this.close(this.select_last_double1);
            this.select_last_double2 = this.close(this.select_last_double2);
        }
        return obs;
    }

    public boolean deleteValue(UpdatableSeries<Double> series, TimeIndex t, ChronicleUpdatePolicy policy) throws T2DBException {
        boolean done = false;
        try {
            this.check(Permission.MODIFY, (DBObject)series);
            policy.willDelete(series, t);
            policy.deleteValue(series, t);
            this.delete_values_by_t = this.open(DELETE_VALUES_BY_T, (DBObject)series, this.delete_values_by_t);
            this.delete_values_by_t.setInt(1, this.getId((DBObject)series));
            this.delete_values_by_t.setInt(2, t.asOffset());
            this.delete_values_by_t.execute();
            done = this.delete_values_by_t.getUpdateCount() > 0;
        }
        catch (Exception e) {
            throw T2DBMsg.exception((Throwable)e, (String)"E50113", (Object[])new Object[]{series.getName(true), t.toString()});
        }
        finally {
            this.delete_values_by_t = this.close(this.delete_values_by_t);
        }
        return done;
    }

    public boolean updateSeries(UpdatableSeries<Double> series, Range range, ChronicleUpdatePolicy policy) throws T2DBException {
        boolean done = false;
        try {
            int id = this.getId((DBObject)series);
            int first = 1;
            int last = 0;
            if (!range.isEmpty()) {
                first = range.getFirst().asOffset();
                last = range.getLast().asOffset();
            }
            this.check(Permission.MODIFY, (DBObject)series);
            policy.willUpdate(series, range);
            done = policy.update(series, range);
            this.update_series_range = this.open(UPDATE_SERIES_RANGE, (DBObject)series, this.update_series_range);
            this.update_series_range.setInt(1, id);
            this.update_series_range.setInt(2, first);
            this.update_series_range.setInt(3, last);
            this.update_series_range.execute();
            if (this.update_series_range.getUpdateCount() > 0) {
                done = true;
            }
        }
        catch (Exception e) {
            throw T2DBMsg.exception((Throwable)e, (String)"E50109", (Object[])new Object[]{series.getName(true)});
        }
        finally {
            this.update_series_range = this.close(this.update_series_range);
        }
        return done;
    }

    protected boolean insertOrUpdateValue(UpdatableSeries<Double> series, Observation<Double> obs, ChronicleUpdatePolicy policy) throws T2DBException {
        boolean done = false;
        Double v = (Double)obs.getValue();
        if (v == null || Double.isNaN(v)) {
            throw new IllegalArgumentException("value null or NaN");
        }
        try {
            this.check(Permission.MODIFY, (DBObject)series);
            this.insert_value = this.open(INSERT_VALUE, (DBObject)series, this.insert_value);
            this.insert_value.setInt(1, this.getId((DBObject)series));
            this.insert_value.setInt(2, obs.getTime().asOffset());
            this.insert_value.setDouble(3, v);
            this.insert_value.execute();
            done = this.insert_value.getUpdateCount() > 0;
        }
        catch (SQLException e) {
            done = this.updateValue(e, series, obs, policy);
        }
        catch (KeyedException e) {
            throw T2DBMsg.exception((Throwable)e, (String)"E50110", (Object[])new Object[]{series.getName(true), obs.getTime().toString()});
        }
        finally {
            this.insert_value = this.close(this.insert_value);
        }
        return done;
    }

    private boolean updateValue(SQLException originalException, UpdatableSeries<Double> series, Observation<Double> obs, ChronicleUpdatePolicy policy) throws T2DBException {
        boolean done = false;
        try {
            this.check(Permission.MODIFY, (DBObject)series);
            this.update_value = this.open(UPDATE_VALUE, (DBObject)series, this.update_value);
            this.update_value.setDouble(1, (Double)obs.getValue());
            this.update_value.setInt(2, this.getId((DBObject)series));
            this.update_value.setInt(3, obs.getTime().asOffset());
            this.update_value.setDouble(4, (Double)obs.getValue());
            this.update_value.execute();
            done = this.update_value.getUpdateCount() > 0;
        }
        catch (Exception e) {
            throw T2DBMsg.exception((Throwable)originalException, (String)"E50110", (Object[])new Object[]{series.getName(true), obs.getTime().toString()});
        }
        finally {
            this.update_value = this.close(this.update_value);
        }
        return done;
    }

    public long updateValues(UpdatableSeries<Double> series, TimeAddressable<Double> values, ChronicleUpdatePolicy policy) throws T2DBException {
        long count = 0L;
        for (Observation obs : values) {
            boolean done = false;
            done = values.isMissing(obs.getValue()) ? this.deleteValue(series, obs.getTime(), policy) : this.insertOrUpdateValue(series, (Observation<Double>)obs, policy);
            if (!done) continue;
            ++count;
        }
        return count;
    }
}

