/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.jdbc;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.T2DBMsg;
import ch.agent.crnickl.api.AttributeDefinition;
import ch.agent.crnickl.api.DBObject;
import ch.agent.crnickl.api.DBObjectType;
import ch.agent.crnickl.api.Database;
import ch.agent.crnickl.api.Property;
import ch.agent.crnickl.api.Schema;
import ch.agent.crnickl.api.SeriesDefinition;
import ch.agent.crnickl.api.Surrogate;
import ch.agent.crnickl.api.UpdatableSchema;
import ch.agent.crnickl.impl.AttributeDefinitionImpl;
import ch.agent.crnickl.impl.Permission;
import ch.agent.crnickl.impl.UpdatableSchemaImpl;
import ch.agent.crnickl.impl.UpdatableSchemaVisitor;
import ch.agent.crnickl.jdbc.JDBCDatabase;
import ch.agent.crnickl.jdbc.ReadMethodsForSchema;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class WriteMethodsForSchema
extends ReadMethodsForSchema {
    private UpdatableSchemaVisitor visitor = new Visitor(this);
    private PreparedStatement create_schema;
    private static final String CREATE_SCHEMA = "insert into schema_name(parent, label) values(?, ?)";
    private PreparedStatement delete_schema;
    private PreparedStatement delete_schema_components;
    private static final String DELETE_SCHEMA = "delete from schema_name where id = ?";
    private static final String DELETE_SCHEMA_COMPONENTS = "delete from schema_item where id = ?";
    private PreparedStatement create_schema_component;
    private static final String CREATE_SCHEMA_COMPONENT = "insert into schema_item(id, ssn, attrib, prop, value, descrip) values(?, ?, ?, ?, ?, ?)";
    private PreparedStatement update_schema;
    private static final String UPDATE_SCHEMA = "update schema_name set label = ?, parent = ? where id = ?";
    private PreparedStatement delete_schema_by_attribute;
    private static final String DELETE_SCHEMA_BY_ATTRIBUTE = "delete from schema_item where id = ? and ssn = ? and attrib = ?";
    private PreparedStatement delete_schema_by_series;
    private static final String DELETE_SCHEMA_BY_SERIES = "delete from schema_item where id = ? and ssn = ?";
    private PreparedStatement update_schema_by_attribute;
    private static final String UPDATE_SCHEMA_BY_ATTRIBUTE = "update schema_item set value = ?, descrip = ? where id = ? and ssn = ? and attrib = ?";
    private PreparedStatement find_entity_with_schema;
    private static final String FIND_ENTITY_WITH_SCHEMA = "select id from chronicle where schema_id = ?";
    private PreparedStatement find_entity_with_property;
    private static final String FIND_ENTITY_WITH_PROPERTY = "select chronicle from attribute_value where prop = ?";
    private PreparedStatement find_entity_with_series;
    private static final String FIND_ENTITY_WITH_SERIES = "select chronicle from series where ssn = ?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSchema(UpdatableSchema schema) throws T2DBException {
        Surrogate surrogate = null;
        Exception cause = null;
        try {
            this.check(Permission.CREATE, (DBObject)schema);
            UpdatableSchema base = schema.getBase();
            if (base != null) {
                this.check(Permission.READ, (DBObject)base);
            }
            this.create_schema = this.open(CREATE_SCHEMA, (DBObject)schema, this.create_schema);
            this.create_schema.setInt(1, this.getIdOrZero((DBObject)base));
            this.create_schema.setString(2, schema.getName());
            surrogate = this.makeSurrogate((DBObject)schema, this.executeAndGetNewId(this.create_schema));
            schema.getSurrogate().upgrade(surrogate);
            this.updateSchemaComponents(schema);
        }
        catch (Exception e) {
            cause = e;
        }
        finally {
            this.create_schema = this.close(this.create_schema);
        }
        if (surrogate == null || cause != null) {
            throw T2DBMsg.exception((Throwable)cause, (String)"E30122", (Object[])new Object[]{schema.getName()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSchema(UpdatableSchema schema) throws T2DBException {
        boolean done = false;
        Exception cause = null;
        try {
            this.check(Permission.MODIFY, (DBObject)schema);
            this.delete_schema_components = this.open(DELETE_SCHEMA_COMPONENTS, (DBObject)schema, this.delete_schema_components);
            int id = this.getId((DBObject)schema);
            this.delete_schema_components.setInt(1, id);
            this.delete_schema_components.execute();
            this.delete_schema = this.open(DELETE_SCHEMA, (DBObject)schema, this.delete_schema);
            this.delete_schema.setInt(1, id);
            this.delete_schema.execute();
            done = this.delete_schema.getUpdateCount() > 0;
        }
        catch (Exception e) {
            cause = e;
        }
        finally {
            this.delete_schema_components = this.close(this.delete_schema_components);
            this.delete_schema = this.close(this.delete_schema);
        }
        if (!done || cause != null) {
            throw T2DBMsg.exception((Throwable)cause, (String)"E30123", (Object[])new Object[]{schema.getName()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSchemaComponent(UpdatableSchema schema, int seriesNr, String description, AttributeDefinition<?> def) throws T2DBException {
        boolean done = false;
        try {
            this.check(Permission.MODIFY, (DBObject)schema);
            this.create_schema_component = this.open(CREATE_SCHEMA_COMPONENT, (DBObject)schema, this.create_schema_component);
            this.create_schema_component.setInt(1, this.getId((DBObject)schema));
            this.create_schema_component.setInt(2, seriesNr);
            this.create_schema_component.setInt(3, def.getNumber());
            if (def.isErasing()) {
                this.create_schema_component.setInt(4, 0);
                this.create_schema_component.setString(5, "");
                this.create_schema_component.setString(6, "");
            } else {
                Database database = schema.getSurrogate().getDatabase();
                Property<?> prop = ((JDBCDatabase)database).getReadMethodsForProperty().getProperty(def.getProperty().getSurrogate());
                if (prop == null) {
                    throw T2DBMsg.exception((String)"E30130", (Object[])new Object[0]);
                }
                this.create_schema_component.setInt(4, this.getId((DBObject)prop));
                String value = def.getProperty().getValueType().toString(def.getValue());
                this.create_schema_component.setString(5, value == null ? "" : value);
                this.create_schema_component.setString(6, description == null ? "" : description);
            }
            this.create_schema_component.execute();
            done = this.create_schema_component.getUpdateCount() > 0;
        }
        catch (Exception e) {
            if (!done) {
                if (seriesNr == 0) {
                    throw T2DBMsg.exception((Throwable)e, (String)"E30124", (Object[])new Object[]{def.getNumber()});
                }
                throw T2DBMsg.exception((Throwable)e, (String)"E30125", (Object[])new Object[]{def.getNumber(), seriesNr});
            }
        }
        finally {
            this.create_schema_component = this.close(this.create_schema_component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateSchema(UpdatableSchema schema) throws T2DBException {
        boolean done = false;
        Exception cause = null;
        ReadMethodsForSchema.RawSchema rawSchema = this.getRawSchema(schema.getSurrogate());
        boolean nameEdited = this.nameEdited(schema, rawSchema);
        boolean baseEdited = this.baseEdited(schema, rawSchema);
        if (nameEdited || baseEdited) {
            try {
                UpdatableSchema base = schema.getBase();
                this.check(Permission.MODIFY, (DBObject)schema);
                if (baseEdited && base != null) {
                    this.check(Permission.READ, (DBObject)base);
                }
                this.update_schema = this.open(UPDATE_SCHEMA, (DBObject)schema, this.update_schema);
                this.update_schema.setString(1, schema.getName());
                this.update_schema.setInt(2, this.getIdOrZero((DBObject)base));
                this.update_schema.setInt(3, this.getId((DBObject)schema));
                this.update_schema.execute();
                done = this.update_schema.getUpdateCount() > 0;
            }
            catch (Exception e) {
                cause = e;
            }
            finally {
                this.update_schema = this.close(this.update_schema);
            }
        }
        try {
            done |= this.updateSchemaComponents(schema);
        }
        catch (Exception e) {
            cause = e;
        }
        if (!done || cause != null) {
            throw T2DBMsg.exception((Throwable)cause, (String)"E30126", (Object[])new Object[]{schema});
        }
        return done;
    }

    private boolean updateSchemaComponents(UpdatableSchema schema) throws T2DBException {
        return ((UpdatableSchemaImpl)schema).traverse(false, this.visitor) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteSchemaComponent(UpdatableSchema schema, int seriesNr, int attribNr) throws T2DBException {
        boolean done = false;
        Exception cause = null;
        try {
            this.check(Permission.MODIFY, (DBObject)schema);
            this.delete_schema_by_attribute = this.open(DELETE_SCHEMA_BY_ATTRIBUTE, (DBObject)schema, this.delete_schema_by_attribute);
            this.delete_schema_by_attribute.setInt(1, this.getId((DBObject)schema));
            this.delete_schema_by_attribute.setInt(2, seriesNr);
            this.delete_schema_by_attribute.setInt(3, attribNr);
            this.delete_schema_by_attribute.execute();
            if (this.delete_schema_by_attribute.getUpdateCount() > 0) {
                done = true;
            }
        }
        catch (Exception e) {
            cause = e;
        }
        finally {
            this.delete_schema_by_attribute = this.close(this.delete_schema_by_attribute);
        }
        if (!done || cause != null) {
            throw T2DBMsg.exception((Throwable)cause, (String)"E30128", (Object[])new Object[]{schema, seriesNr, attribNr});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteSchemaComponents(UpdatableSchema schema, int seriesNr) throws T2DBException {
        boolean done = false;
        Exception cause = null;
        try {
            this.check(Permission.MODIFY, (DBObject)schema);
            this.delete_schema_by_series = this.open(DELETE_SCHEMA_BY_SERIES, (DBObject)schema, this.delete_schema_by_series);
            this.delete_schema_by_series.setInt(1, this.getId((DBObject)schema));
            this.delete_schema_by_series.setInt(2, seriesNr);
            this.delete_schema_by_series.execute();
            if (this.delete_schema_by_series.getUpdateCount() > 0) {
                done = true;
            }
        }
        catch (Exception e) {
            cause = e;
        }
        finally {
            this.delete_schema_by_series = this.close(this.delete_schema_by_series);
        }
        if (!done || cause != null) {
            throw T2DBMsg.exception((Throwable)cause, (String)"E30129", (Object[])new Object[]{schema, seriesNr});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSchemaComponent(UpdatableSchema schema, int seriesNr, String description, AttributeDefinition<?> def) throws T2DBException {
        boolean done = false;
        Exception cause = null;
        try {
            this.check(Permission.MODIFY, (DBObject)schema);
            this.update_schema_by_attribute = this.open(UPDATE_SCHEMA_BY_ATTRIBUTE, (DBObject)schema, this.update_schema_by_attribute);
            String value = def.getProperty().getValueType().toString(def.getValue());
            this.update_schema_by_attribute.setString(1, value == null ? "" : value);
            this.update_schema_by_attribute.setString(2, description == null ? "" : description);
            this.update_schema_by_attribute.setInt(3, this.getId((DBObject)schema));
            this.update_schema_by_attribute.setInt(4, seriesNr);
            this.update_schema_by_attribute.setInt(5, def.getNumber());
            this.update_schema_by_attribute.execute();
            if (this.update_schema_by_attribute.getUpdateCount() > 0) {
                done = true;
            }
        }
        catch (Exception e) {
            cause = e;
        }
        finally {
            this.update_schema_by_attribute = this.close(this.update_schema_by_attribute);
        }
        if (!done || cause != null) {
            throw T2DBMsg.exception((Throwable)cause, (String)"E30127", (Object[])new Object[]{schema, seriesNr, def.getNumber()});
        }
    }

    private boolean nameEdited(UpdatableSchema schema, ReadMethodsForSchema.RawSchema current) {
        return !schema.getName().equals(current.getName());
    }

    private boolean baseEdited(UpdatableSchema schema, ReadMethodsForSchema.RawSchema current) {
        int currentBaseId;
        UpdatableSchema base = schema.getBase();
        int editedBaseId = this.getIdOrZero((DBObject)base);
        return editedBaseId != (currentBaseId = current.getParent());
    }

    public Surrogate findChronicle(Schema schema) throws T2DBException {
        Surrogate result = null;
        Database database = schema.getSurrogate().getDatabase();
        try {
            this.find_entity_with_schema = this.open(FIND_ENTITY_WITH_SCHEMA, database, this.find_entity_with_schema);
            this.find_entity_with_schema.setInt(1, this.getId((DBObject)schema));
            ResultSet rs = this.find_entity_with_schema.executeQuery();
            if (rs.next()) {
                result = this.makeSurrogate(database, DBObjectType.CHRONICLE, rs.getInt(1));
            }
        }
        catch (Exception e) {
            throw T2DBMsg.exception((Throwable)e, (String)"E30117", (Object[])new Object[0]);
        }
        finally {
            this.find_entity_with_schema = this.close(this.find_entity_with_schema);
        }
        return result;
    }

    public Surrogate findChronicle(Property<?> property, Schema schema) throws T2DBException {
        Surrogate result = null;
        Database database = property.getSurrogate().getDatabase();
        try {
            this.find_entity_with_property = this.open(FIND_ENTITY_WITH_PROPERTY, (DBObject)property, this.find_entity_with_property);
            this.find_entity_with_property.setInt(1, this.getId((DBObject)property));
            ResultSet rs = this.find_entity_with_property.executeQuery();
            while (rs.next()) {
                Surrogate entityKey = this.makeSurrogate(database, DBObjectType.CHRONICLE, rs.getInt(1));
                Schema s = database.getChronicle(entityKey).getSchema(true);
                if (!s.dependsOnSchema(schema)) continue;
                result = entityKey;
                break;
            }
        }
        catch (Exception e) {
            throw T2DBMsg.exception((Throwable)e, (String)"E30117", (Object[])new Object[0]);
        }
        finally {
            this.find_entity_with_property = this.close(this.find_entity_with_property);
        }
        return result;
    }

    public Surrogate findChronicle(SeriesDefinition ss, Schema schema) throws T2DBException {
        Surrogate result = null;
        Database database = schema.getSurrogate().getDatabase();
        try {
            this.find_entity_with_series = this.open(FIND_ENTITY_WITH_SERIES, database, this.find_entity_with_series);
            this.find_entity_with_series.setInt(1, ss.getNumber());
            ResultSet rs = this.find_entity_with_series.executeQuery();
            while (rs.next()) {
                Surrogate entityKey = this.makeSurrogate(database, DBObjectType.CHRONICLE, rs.getInt(1));
                Schema s = database.getChronicle(entityKey).getSchema(true);
                if (!s.dependsOnSchema(schema)) continue;
                result = entityKey;
                break;
            }
        }
        catch (Exception e) {
            throw T2DBMsg.exception((Throwable)e, (String)"E30117", (Object[])new Object[0]);
        }
        finally {
            this.find_entity_with_series = this.close(this.find_entity_with_series);
        }
        return result;
    }

    private static class Visitor
    implements UpdatableSchemaVisitor {
        private WriteMethodsForSchema m;

        private Visitor(WriteMethodsForSchema methods) {
            this.m = methods;
        }

        public void visit(UpdatableSchema schema, SeriesDefinition def, SeriesDefinition original) throws T2DBException {
            if (def == null) {
                this.m.deleteSchemaComponents(schema, original.getNumber());
            } else if (def.isErasing()) {
                AttributeDefinitionImpl attribDef = new AttributeDefinitionImpl(def.getNumber(), 1, null, null);
                attribDef.edit();
                attribDef.setErasing(true);
                if (original == null) {
                    this.m.createSchemaComponent(schema, def.getNumber(), null, (AttributeDefinition)attribDef);
                } else if (!original.isErasing()) {
                    this.m.updateSchemaComponent(schema, def.getNumber(), null, (AttributeDefinition)attribDef);
                }
            }
        }

        public void visit(UpdatableSchema schema, SeriesDefinition seriesDef, AttributeDefinition<?> attrDef, AttributeDefinition<?> origAttrDef) throws T2DBException {
            int seriesNr;
            int n = seriesNr = seriesDef == null ? 0 : seriesDef.getNumber();
            if (attrDef == null) {
                this.m.deleteSchemaComponent(schema, seriesNr, origAttrDef.getNumber());
            } else {
                String description = null;
                if (seriesNr != 0 && attrDef.getNumber() == 1) {
                    description = seriesDef.getDescription();
                }
                if (origAttrDef == null) {
                    this.m.createSchemaComponent(schema, seriesNr, description, attrDef);
                } else {
                    this.m.updateSchemaComponent(schema, seriesNr, description, attrDef);
                }
            }
        }
    }
}

