/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.jdbc;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.T2DBMsg;
import ch.agent.crnickl.api.DBObject;
import ch.agent.crnickl.api.Property;
import ch.agent.crnickl.api.Surrogate;
import ch.agent.crnickl.api.ValueType;
import ch.agent.crnickl.impl.Permission;
import ch.agent.crnickl.impl.SchemaUpdatePolicy;
import ch.agent.crnickl.jdbc.ReadMethodsForProperty;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class WriteMethodsForProperty
extends ReadMethodsForProperty {
    private PreparedStatement create_property;
    private static final String CREATE_PROPERTY = "insert into property(type, label) values(?, ?)";
    private PreparedStatement delete_property;
    private static final String DELETE_PROPERTY = "delete from property where id = ?";
    private PreparedStatement update_property;
    private static final String UPDATE_PROPERTY = "update property set label = ? where id = ?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createProperty(Property<?> property) throws T2DBException {
        Surrogate surrogate = null;
        Exception cause = null;
        try {
            this.check(Permission.CREATE, (DBObject)property);
            this.create_property = this.open(CREATE_PROPERTY, (DBObject)property, this.create_property);
            ValueType vt = property.getValueType();
            this.create_property.setInt(1, this.getId((DBObject)vt));
            this.create_property.setString(2, property.getName());
            surrogate = this.makeSurrogate((DBObject)property, this.executeAndGetNewId(this.create_property));
        }
        catch (Exception e) {
            cause = e;
        }
        finally {
            this.create_property = this.close(this.create_property);
        }
        if (surrogate == null || cause != null) {
            throw T2DBMsg.exception((Throwable)cause, (String)"E20114", (Object[])new Object[]{property.getName()});
        }
        property.getSurrogate().upgrade(surrogate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteProperty(Property<?> property, SchemaUpdatePolicy policy) throws T2DBException {
        boolean done = false;
        SQLException cause = null;
        try {
            this.check(Permission.MODIFY, (DBObject)property);
            int id = this.getId((DBObject)property);
            if (id <= 9) {
                throw T2DBMsg.exception((String)"E20120", (Object[])new Object[]{property.getName()});
            }
            policy.willDelete(property);
            this.delete_property = this.open(DELETE_PROPERTY, (DBObject)property, this.delete_property);
            this.delete_property.setInt(1, id);
            this.delete_property.execute();
            done = this.delete_property.getUpdateCount() > 0;
        }
        catch (SQLException e) {
            cause = e;
        }
        finally {
            this.delete_property = this.close(this.delete_property);
        }
        if (!done || cause != null) {
            throw T2DBMsg.exception((Throwable)cause, (String)"E20115", (Object[])new Object[]{property.getName()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProperty(Property<?> property, SchemaUpdatePolicy policy) throws T2DBException {
        boolean done = false;
        Exception cause = null;
        try {
            this.check(Permission.MODIFY, (DBObject)property);
            this.update_property = this.open(UPDATE_PROPERTY, (DBObject)property, this.update_property);
            this.update_property.setString(1, property.getName());
            this.update_property.setInt(2, this.getId((DBObject)property));
            this.update_property.execute();
            done = this.update_property.getUpdateCount() > 0;
        }
        catch (Exception e) {
            cause = e;
        }
        finally {
            this.update_property = this.close(this.update_property);
        }
        if (!done || cause != null) {
            throw T2DBMsg.exception((Throwable)cause, (String)"E20116", (Object[])new Object[]{property.getName()});
        }
    }
}

