/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.jdbc;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.T2DBMsg;
import ch.agent.crnickl.api.AttributeDefinition;
import ch.agent.crnickl.api.Chronicle;
import ch.agent.crnickl.api.DBObject;
import ch.agent.crnickl.api.Schema;
import ch.agent.crnickl.api.Series;
import ch.agent.crnickl.api.Surrogate;
import ch.agent.crnickl.api.UpdatableChronicle;
import ch.agent.crnickl.api.UpdatableSeries;
import ch.agent.crnickl.impl.ChronicleUpdatePolicy;
import ch.agent.crnickl.impl.DatabaseBackend;
import ch.agent.crnickl.impl.Permission;
import ch.agent.crnickl.jdbc.ReadMethodsForChroniclesAndSeries;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class WriteMethodsForChroniclesAndSeries
extends ReadMethodsForChroniclesAndSeries {
    private PreparedStatement create_entity;
    private static final String CREATE_ENTITY = "insert into chronicle(parent, schema_id, name, descrip) values(?, ?, ?, ?)";
    private PreparedStatement delete_entity;
    private static final String DELETE_ENTITY = "delete from chronicle where id = ?";
    private PreparedStatement delete_entity_attributes;
    private static final String DELETE_ENTITY_ATTIBUTES = "delete from attribute_value where chronicle = ?";
    private PreparedStatement update_entity;
    private static final String UPDATE_ENTITY = "update chronicle set name = ?, descrip = ? where id = ?";
    private PreparedStatement insert_attribute;
    private static final String INSERT_ATTRIBUTE = "insert into attribute_value(chronicle, attrib, prop, value, descrip) values(?, ?, ?, ?, ?) ";
    private PreparedStatement update_attribute;
    private static final String UPDATE_ATTRIBUTE = "update attribute_value set value = ?, descrip = ? where chronicle = ? and prop = ?";
    private PreparedStatement delete_attribute;
    private static final String DELETE_ATTRIBUTE = "delete from attribute_value where chronicle = ? and prop = ?";
    private PreparedStatement create_series;
    private static final String CREATE_SERIES = "insert into series(chronicle, ssn) values(?, ?)";
    private PreparedStatement delete_series;
    private static final String DELETE_SERIES = "delete from series where id = ?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createChronicle(Chronicle chronicle) throws T2DBException {
        Surrogate surrogate = null;
        Exception cause = null;
        try {
            String name = chronicle.getName(false);
            ((DatabaseBackend)chronicle.getSurrogate().getDatabase()).getNamingPolicy().checkSimpleName(name, false);
            String description = chronicle.getDescription(false);
            if (description == null) {
                description = "";
            }
            Chronicle collection = chronicle.getCollection();
            Schema schema = chronicle.getSchema(false);
            if (collection != null) {
                this.check(Permission.MODIFY, (DBObject)collection);
                if (schema != null && schema.equals(collection.getSchema(true))) {
                    schema = null;
                }
            }
            if (schema != null) {
                this.check(Permission.READ, (DBObject)schema);
            }
            this.create_entity = this.open(CREATE_ENTITY, (DBObject)chronicle, this.create_entity);
            this.create_entity.setInt(1, this.getIdOrZero((DBObject)collection));
            this.create_entity.setInt(2, this.getIdOrZero((DBObject)schema));
            this.create_entity.setString(3, name);
            this.create_entity.setString(4, description);
            surrogate = this.makeSurrogate((DBObject)chronicle, this.executeAndGetNewId(this.create_entity));
        }
        catch (Exception e) {
            cause = e;
        }
        finally {
            this.create_entity = this.close(this.create_entity);
        }
        if (surrogate == null || cause != null) {
            throw T2DBMsg.exception((Throwable)cause, (String)"E40109", (Object[])new Object[]{chronicle.getName(true)});
        }
        chronicle.getSurrogate().upgrade(surrogate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteChronicle(UpdatableChronicle chronicle, ChronicleUpdatePolicy policy) throws T2DBException {
        boolean done = false;
        Exception cause = null;
        try {
            int id = this.getId((DBObject)chronicle);
            this.check(Permission.MODIFY, (DBObject)chronicle);
            policy.willDelete(chronicle);
            done = policy.deleteChronicle(chronicle);
            this.delete_entity_attributes = this.open(DELETE_ENTITY_ATTIBUTES, (DBObject)chronicle, this.delete_entity_attributes);
            this.delete_entity_attributes.setInt(1, id);
            this.delete_entity_attributes.execute();
            this.delete_entity = this.open(DELETE_ENTITY, (DBObject)chronicle, this.delete_entity);
            this.delete_entity.setInt(1, id);
            this.delete_entity.execute();
            done = this.delete_entity.getUpdateCount() > 0;
        }
        catch (Exception e) {
            cause = e;
        }
        finally {
            this.delete_entity = this.close(this.delete_entity);
            this.delete_entity_attributes = this.close(this.delete_entity_attributes);
        }
        if (!done || cause != null) {
            throw T2DBMsg.exception((Throwable)cause, (String)"E40110", (Object[])new Object[]{chronicle.getName(true)});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateChronicle(UpdatableChronicle chronicle, ChronicleUpdatePolicy policy) throws T2DBException {
        boolean done = false;
        Exception cause = null;
        String name = chronicle.getName(false);
        String description = chronicle.getDescription(false);
        if (description == null) {
            description = "";
        }
        try {
            int id = this.getId((DBObject)chronicle);
            this.check(Permission.MODIFY, (DBObject)chronicle);
            policy.willUpdate(chronicle);
            this.update_entity = this.open(UPDATE_ENTITY, (DBObject)chronicle, this.update_entity);
            this.update_entity.setString(1, name);
            this.update_entity.setString(2, description);
            this.update_entity.setInt(3, id);
            this.update_entity.execute();
            done = this.update_entity.getUpdateCount() > 0;
        }
        catch (Exception e) {
            cause = e;
        }
        finally {
            this.update_entity = this.close(this.update_entity);
        }
        if (!done || cause != null) {
            throw T2DBMsg.exception((Throwable)cause, (String)"E40111", (Object[])new Object[]{chronicle.getName(true)});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAttribute(UpdatableChronicle chronicle, AttributeDefinition<?> def, String value, String description) throws T2DBException {
        boolean done = false;
        try {
            this.check(Permission.MODIFY, (DBObject)chronicle);
            this.insert_attribute = this.open(INSERT_ATTRIBUTE, (DBObject)chronicle, this.insert_attribute);
            this.insert_attribute.setInt(1, this.getId((DBObject)chronicle));
            this.insert_attribute.setInt(2, def.getNumber());
            this.insert_attribute.setInt(3, this.getId((DBObject)def.getProperty()));
            this.insert_attribute.setString(4, value);
            this.insert_attribute.setString(5, description);
            this.insert_attribute.execute();
            done = this.insert_attribute.getUpdateCount() > 0;
        }
        catch (SQLException e) {
            done = this.updateAttribute(e, chronicle, def, value, description);
        }
        finally {
            this.insert_attribute = this.close(this.insert_attribute);
        }
        if (!done) {
            throw T2DBMsg.exception((String)"E40112", (Object[])new Object[]{chronicle.getName(true), def.getNumber()});
        }
    }

    private boolean updateAttribute(SQLException originalException, UpdatableChronicle entity, AttributeDefinition<?> def, String value, String description) throws T2DBException {
        boolean done = false;
        try {
            this.check(Permission.MODIFY, (DBObject)entity);
            this.update_attribute = this.open(UPDATE_ATTRIBUTE, (DBObject)entity, this.update_attribute);
            this.update_attribute.setString(1, value);
            this.update_attribute.setString(2, description);
            this.update_attribute.setInt(3, this.getId((DBObject)entity));
            this.update_attribute.setInt(4, this.getId((DBObject)def.getProperty()));
            this.update_attribute.execute();
            done = this.update_attribute.getUpdateCount() > 0;
        }
        catch (Exception e) {
            throw T2DBMsg.exception((Throwable)originalException, (String)"E40113", (Object[])new Object[]{entity.getName(true), def.getNumber()});
        }
        finally {
            this.update_attribute = this.close(this.update_attribute);
        }
        return done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAttribute(Chronicle chronicle, AttributeDefinition<?> def) throws T2DBException {
        boolean done = false;
        Exception cause = null;
        try {
            this.check(Permission.MODIFY, (DBObject)chronicle);
            this.delete_attribute = this.open(DELETE_ATTRIBUTE, (DBObject)chronicle, this.delete_attribute);
            this.delete_attribute.setInt(1, this.getId((DBObject)chronicle));
            this.delete_attribute.setInt(2, this.getId((DBObject)def.getProperty()));
            this.delete_attribute.execute();
            done = this.delete_attribute.getUpdateCount() > 0;
        }
        catch (Exception e) {
            cause = e;
        }
        finally {
            this.delete_attribute = this.close(this.delete_attribute);
        }
        if (!done || cause != null) {
            throw T2DBMsg.exception((Throwable)cause, (String)"E40114", (Object[])new Object[]{chronicle.getName(true), def.getNumber()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSeries(Series<?> series) throws T2DBException {
        Exception cause = null;
        Surrogate surrogate = null;
        Chronicle chronicle = series.getChronicle();
        try {
            this.check(Permission.MODIFY, (DBObject)chronicle, true);
            this.create_series = this.open(CREATE_SERIES, (DBObject)series, this.create_series);
            this.create_series.setInt(1, this.getId((DBObject)chronicle));
            this.create_series.setInt(2, series.getNumber());
            surrogate = this.makeSurrogate((DBObject)series, this.executeAndGetNewId(this.create_series));
        }
        catch (Exception e) {
            cause = e;
        }
        finally {
            this.create_series = this.close(this.create_series);
        }
        if (surrogate == null || cause != null) {
            throw T2DBMsg.exception((Throwable)cause, (String)"E50111", (Object[])new Object[]{series.getName(true)});
        }
        series.getSurrogate().upgrade(surrogate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSeries(UpdatableSeries<?> series, ChronicleUpdatePolicy policy) throws T2DBException {
        boolean done = false;
        Exception cause = null;
        try {
            int id = this.getId((DBObject)series);
            this.check(Permission.MODIFY, (DBObject)series);
            policy.willDelete(series);
            done = policy.deleteSeries(series);
            this.delete_series = this.open(DELETE_SERIES, (DBObject)series, this.delete_series);
            this.delete_series.setInt(1, id);
            this.delete_series.execute();
            if (this.delete_series.getUpdateCount() > 0) {
                done = true;
            }
        }
        catch (Exception e) {
            cause = e;
        }
        finally {
            this.delete_series = this.close(this.delete_series);
        }
        if (!done || cause != null) {
            throw T2DBMsg.exception((Throwable)cause, (String)"E50112", (Object[])new Object[]{series.getName(true)});
        }
    }
}

