/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.jdbc;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.T2DBMsg;
import ch.agent.crnickl.api.DBObject;
import ch.agent.crnickl.api.Surrogate;
import ch.agent.crnickl.api.ValueType;
import ch.agent.crnickl.impl.Permission;
import ch.agent.crnickl.impl.SchemaUpdatePolicy;
import ch.agent.crnickl.impl.ValueTypeImpl;
import ch.agent.crnickl.jdbc.JDBCDatabase;
import ch.agent.crnickl.jdbc.JDBCDatabaseMethods;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class WriteMethodsForValueType
extends JDBCDatabaseMethods {
    private PreparedStatement create_valuetype;
    private static final String CREATE_VALUETYPE = "insert into value_type (label, restricted, scanner) values(?, ?, ?)";
    private PreparedStatement delete_valuetype;
    private static final String DELETE_VALUETYPE = "delete from value_type where id = ?";
    private PreparedStatement update_valuetype;
    private static final String UPDATE_VALUETYPE = "update value_type set label = ? where id = ?";
    private PreparedStatement insert_valuelist;
    private static final String INSERT_VALUELIST = "insert into value_type_value(type, value, descrip) values(?, ?, ?)";
    private PreparedStatement update_valuelist;
    private static final String UPDATE_VALUELIST = "update value_type_value set descrip = ? where type = ? and value = ?";
    private PreparedStatement delete_valuelist;
    private static final String DELETE_VALUELIST = "delete from value_type_value where type = ? and value = ?";
    private PreparedStatement delete_values;
    private static final String DELETE_VALUES = "delete from value_type_value where type = ?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void createValueType(ValueType<T> vt) throws T2DBException {
        Surrogate surrogate = null;
        Exception cause = null;
        try {
            this.check(Permission.CREATE, (DBObject)vt);
            this.create_valuetype = this.open(CREATE_VALUETYPE, (DBObject)vt, this.create_valuetype);
            this.create_valuetype.setString(1, vt.getName());
            this.create_valuetype.setBoolean(2, vt.isRestricted());
            this.create_valuetype.setString(3, ((ValueTypeImpl)vt).getExternalRepresentation());
            surrogate = this.makeSurrogate((DBObject)vt, this.executeAndGetNewId(this.create_valuetype));
            vt.getSurrogate().upgrade(surrogate);
            this.updateValues(null, vt, null);
        }
        catch (Exception e) {
            cause = e;
        }
        finally {
            this.create_valuetype = this.close(this.create_valuetype);
        }
        if (surrogate == null || cause != null) {
            throw T2DBMsg.exception((Throwable)cause, (String)"E10114", (Object[])new Object[]{vt.getName()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void deleteValueType(ValueType<T> vt, SchemaUpdatePolicy policy) throws T2DBException {
        boolean done = false;
        Exception cause = null;
        try {
            this.check(Permission.MODIFY, (DBObject)vt);
            policy.willDelete(vt);
            if (vt.isRestricted()) {
                this.deleteValues(vt);
            }
            this.delete_valuetype = this.open(DELETE_VALUETYPE, (DBObject)vt, this.delete_valuetype);
            this.delete_valuetype.setInt(1, this.getId((DBObject)vt));
            this.delete_valuetype.execute();
            done = this.delete_valuetype.getUpdateCount() > 0;
        }
        catch (Exception e) {
            cause = e;
        }
        finally {
            this.delete_valuetype = this.close(this.delete_valuetype);
        }
        if (!done || cause != null) {
            throw T2DBMsg.exception((Throwable)cause, (String)"E10145", (Object[])new Object[]{vt.getName()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void updateValueType(ValueType<T> vt, SchemaUpdatePolicy policy) throws T2DBException {
        boolean done = false;
        Exception cause = null;
        try {
            this.check(Permission.MODIFY, (DBObject)vt);
            Surrogate s = vt.getSurrogate();
            ValueType original = ((JDBCDatabase)s.getDatabase()).getReadMethodsForValueType().getValueType(s);
            if (!original.getName().equals(vt.getName())) {
                this.update_valuetype = this.open(UPDATE_VALUETYPE, (DBObject)vt, this.update_valuetype);
                this.update_valuetype.setString(1, vt.getName());
                this.update_valuetype.setInt(2, this.getId((DBObject)vt));
                this.update_valuetype.execute();
                done = this.update_valuetype.getUpdateCount() > 0;
            }
            done |= this.updateValues(original, vt, policy);
        }
        catch (Exception e) {
            cause = e;
        }
        finally {
            this.update_valuetype = this.close(this.update_valuetype);
        }
        if (!done || cause != null) {
            throw T2DBMsg.exception((Throwable)cause, (String)"E10146", (Object[])new Object[]{vt.getName()});
        }
    }

    private <T> boolean updateValues(ValueType<T> original, ValueType<T> vt, SchemaUpdatePolicy policy) throws T2DBException {
        boolean done = false;
        if (vt.isRestricted()) {
            HashSet<Object> deleted;
            HashMap edited;
            HashMap added;
            HashMap updates = vt.getValueDescriptions();
            if (original == null) {
                added = updates;
                edited = new HashMap();
                deleted = new HashSet();
            } else {
                Map current = original.getValueDescriptions();
                HashSet addedKeys = new HashSet(updates.keySet());
                addedKeys.removeAll(current.keySet());
                added = new HashMap();
                for (Object key : addedKeys) {
                    added.put(key, updates.get(key));
                }
                deleted = new HashSet(current.keySet());
                deleted.removeAll(updates.keySet());
                edited = updates;
                for (Object key : addedKeys) {
                    edited.remove(key);
                }
            }
            done = this.updateValueType(vt, added, edited, deleted, policy);
        }
        return done;
    }

    private <T> boolean updateValueType(ValueType<T> vt, Map<T, String> added, Map<T, String> edited, Set<T> deleted, SchemaUpdatePolicy policy) throws T2DBException {
        int count = 0;
        for (Map.Entry<T, String> e : added.entrySet()) {
            this.insertValueTypeValue(vt, vt.getScanner().toString(e.getKey()), e.getValue());
            ++count;
        }
        for (Map.Entry<T, String> e : edited.entrySet()) {
            this.updateValueTypeValue(vt, vt.getScanner().toString(e.getKey()), e.getValue());
            ++count;
        }
        for (Map.Entry<Object, String> value : deleted) {
            this.deleteValueTypeValue(vt, value, policy);
            ++count;
        }
        return count > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void insertValueTypeValue(ValueType<T> vt, String value, String description) throws T2DBException {
        boolean done = false;
        Exception cause = null;
        if (value == null) {
            throw new IllegalArgumentException("value null");
        }
        if (description == null) {
            description = "";
        }
        try {
            this.insert_valuelist = this.open(INSERT_VALUELIST, (DBObject)vt, this.insert_valuelist);
            this.insert_valuelist.setInt(1, this.getId((DBObject)vt));
            this.insert_valuelist.setString(2, value);
            this.insert_valuelist.setString(3, description);
            this.insert_valuelist.execute();
            done = this.insert_valuelist.getUpdateCount() > 0;
        }
        catch (Exception e) {
            cause = e;
        }
        finally {
            this.insert_valuelist = this.close(this.insert_valuelist);
        }
        if (!done || cause != null) {
            throw T2DBMsg.exception((Throwable)cause, (String)"E10121", (Object[])new Object[]{vt.getName()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void updateValueTypeValue(ValueType<T> vt, String value, String description) throws T2DBException {
        boolean done = false;
        Exception cause = null;
        try {
            this.update_valuelist = this.open(UPDATE_VALUELIST, (DBObject)vt, this.update_valuelist);
            this.update_valuelist.setString(1, description);
            this.update_valuelist.setInt(2, this.getId((DBObject)vt));
            this.update_valuelist.setString(3, value);
            this.update_valuelist.execute();
            done = this.update_valuelist.getUpdateCount() > 0;
        }
        catch (Exception e) {
            cause = e;
        }
        finally {
            this.update_valuelist = this.close(this.update_valuelist);
        }
        if (!done || cause != null) {
            throw T2DBMsg.exception((Throwable)cause, (String)"E10122", (Object[])new Object[]{vt.getName()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void deleteValueTypeValue(ValueType<T> vt, T value, SchemaUpdatePolicy policy) throws T2DBException {
        boolean done = false;
        SQLException cause = null;
        String name = vt.getName();
        try {
            int id = this.getId((DBObject)vt);
            if (policy != null) {
                policy.willDelete(vt, value);
            }
            this.delete_valuelist = this.open(DELETE_VALUELIST, (DBObject)vt, this.delete_valuelist);
            this.delete_valuelist.setInt(1, id);
            this.delete_valuelist.setString(2, vt.toString(value));
            this.delete_valuelist.execute();
            done = this.delete_valuelist.getUpdateCount() > 0;
        }
        catch (SQLException e) {
            cause = e;
        }
        finally {
            this.delete_valuelist = this.close(this.delete_valuelist);
        }
        if (!done || cause != null) {
            throw T2DBMsg.exception((Throwable)cause, (String)"E10126", (Object[])new Object[]{name, value});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteValues(ValueType<?> vt) throws T2DBException, SQLException {
        try {
            this.delete_values = this.open(DELETE_VALUES, (DBObject)vt, this.delete_values);
            this.delete_values.setInt(1, this.getId((DBObject)vt));
            this.delete_values.execute();
        }
        finally {
            this.delete_values = this.close(this.delete_values);
        }
    }
}

