-- CREATE TABLES AND INDEXES
-- Idiom: HSQL
-- The sequence is important because of referential integrity.
-- 2012-06-20/jp

create table value_type (
  id int generated by default as identity (start with 10000) not null,
  lastmod timestamp default current_timestamp not null,
  label varchar(50) not null,
  restricted boolean not null,
  builtin boolean not null,
  scanner varchar(100) not null,
  constraint vt1 primary key(id),
  constraint vt2 unique(label)
);

create table value_type_value (
  type int not null,
  value varchar(25) not null,
  descrip varchar(100) not null,
  lastmod timestamp default current_timestamp not null,
  constraint vl1 primary key (type, value),
  constraint vl2 foreign key (type) references value_type (id)
);

create table property (
  id int generated by default as identity (start with 10000) not null,
  type int not null,
  label varchar(50) not null,
  lastmod timestamp default current_timestamp not null,
  constraint prop1 primary key(id),
  constraint prop2 unique(label),
  constraint prop3 foreign key (type) references value_type (id)
);

CREATE TABLE schema_name (
  id int generated by default as identity (start with 1000) not null,
  parent int not null,
  lastmod timestamp default current_timestamp not null,
  label varchar(50) not null,
  constraint t1 primary key (id),
  constraint t2 unique (label)
);

CREATE TABLE schema_item (
  id int not null,
  ssn int not null,
  attrib int not null,
  prop int not null,
  value varchar(50) not null,
  descrip varchar(100) not null,
  lastmod timestamp default current_timestamp not null,
  constraint sl1 primary key (id, ssn, attrib),
  constraint sl2 foreign key (id) references schema_name (id)
);

CREATE TABLE chronicle (
  id int generated by default as identity (start with 100000) not null,
  lastmod timestamp default current_timestamp not null,
  parent int not null,
  name varchar(25) not null,
  schema_id int not null,
  descrip varchar(100) not null,
  constraint n1 primary key (id),
  constraint n2 unique (parent, name)
);

create table series (
  id int generated by default as identity (start with 1000000) not null,
  lastmod timestamp default current_timestamp not null,
  chronicle int not null,
  ssn int not null,
  constraint ser1 primary key (id),
  constraint ser2 unique (chronicle, ssn),
  constraint ser3 foreign key (chronicle) references chronicle (id)
);

create table value_double (
  series int not null,
  date int not null,
  element double not null,
  constraint val1 primary key (series, date),
  constraint val2 foreign key (series) references series (id)
 );

create table attribute_value (
  chronicle int not null,
  attrib int not null,
  lastmod timestamp default current_timestamp not null,
  prop int not null,
  value varchar(50) not null,
  descrip varchar(100) not null,
  constraint nav1 primary key (chronicle, attrib),
  constraint nav2 foreign key (prop) references property (id),
  constraint nav3 foreign key (chronicle) references chronicle (id)
 );
create index valueprop on attribute_value(value, prop); -- not unique !

-- Initialize the database with some "built-in" values, these use magic numbers as keys (1, 2, 3)

insert into value_type (id, label, restricted, builtin, scanner) values(1, 'name', false, true, 'NAME');
insert into value_type (id, label, restricted, builtin, scanner) values(2, 'type', true, true, 'TYPE')
insert into value_type (id, label, restricted, builtin, scanner) values(3, 'timedomain', true, true, 'TIMEDOMAIN');
insert into value_type (id, label, restricted, builtin, scanner) values(4, 'binary', false, true, 'BOOLEAN');

-- add domain values
insert into value_type_value (type, value, descrip) values(3, 'daily', 'daily');
insert into value_type_value (type, value, descrip) values(3, 'datetime', 'date and time with second precision');
insert into value_type_value (type, value, descrip) values(3, 'monthly', 'monthly');
insert into value_type_value (type, value, descrip) values(3, 'workweek', 'working days Monday-Friday');
insert into value_type_value (type, value, descrip) values(3, 'yearly', 'yearly');

-- add corresponding built-in properties
insert into property (id, type, label) values(1, 1, 'Symbol');
insert into property (id, type, label) values(2, 2, 'Type');
insert into property (id, type, label) values(3, 3, 'Calendar');
insert into property (id, type, label) values(4, 4, 'Sparsity');

-- base system supports numeric series values out of the box (but it is not a built-in type, no magic number)
-- the generated value_type key should be 10000 (the first generated key)
-- [2012-06-26/jp This is now left out, but kept as a comment for info.]
--insert into value_type (label, restricted, builtin, scanner) values('numeric', false, false, 'NUMBER')
--insert into value_type_value (type, value, descrip) values(2, 'numeric', '');
