/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.jdbc;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.api.DBObject;
import ch.agent.crnickl.api.Surrogate;
import ch.agent.crnickl.api.ValueType;
import ch.agent.crnickl.impl.Permission;
import ch.agent.crnickl.impl.ValueTypeImpl;
import ch.agent.crnickl.jdbc.JDBCDatabaseMethods;
import ch.agent.crnickl.jdbc.T2DBJMsg;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;

public class WriteMethodsForValueType
extends JDBCDatabaseMethods {
    private PreparedStatement create_valuetype;
    private static final String CREATE_VALUETYPE = "insert into value_type (label, restricted, builtin, scanner) values(?, ?, ?, ?)";
    private PreparedStatement delete_valuetype;
    private static final String DELETE_VALUETYPE = "delete from value_type where id = ?";
    private PreparedStatement update_valuetype;
    private static final String UPDATE_VALUETYPE = "update value_type set label = ? where id = ?";
    private PreparedStatement insert_valuelist;
    private static final String INSERT_VALUELIST = "insert into value_type_value(type, value, descrip) values(?, ?, ?)";
    private PreparedStatement update_valuelist;
    private static final String UPDATE_VALUELIST = "update value_type_value set descrip = ? where type = ? and value = ?";
    private PreparedStatement delete_valuelist;
    private static final String DELETE_VALUELIST = "delete from value_type_value where type = ? and value = ?";
    private PreparedStatement count_property;
    private static final String COUNT_PROPERTY = "select count(*) from property where type = ?";
    private PreparedStatement count_default_values;
    private static final String COUNT_DEFAULT_VALUES = "select count(*) from schema_item s, property p where s.prop = p.id and p.type = ? and s.value = ?";
    private PreparedStatement count_actual_values;
    private static final String COUNT_ACTUAL_VALUES = "select count(*) from property p, attribute_value a  where a.value = ? and p.type = ? and p.id = a.prop";
    private PreparedStatement delete_values;
    private static final String DELETE_VALUES = "delete from value_type_value where type = ?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createValueType(ValueType<?> vt) throws T2DBException {
        Surrogate surrogate = null;
        Exception cause = null;
        try {
            this.check(Permission.CREATE, (DBObject)vt);
            this.create_valuetype = this.open(CREATE_VALUETYPE, (DBObject)vt, this.create_valuetype);
            this.create_valuetype.setString(1, vt.getName());
            this.create_valuetype.setBoolean(2, vt.isRestricted());
            this.create_valuetype.setBoolean(3, false);
            this.create_valuetype.setString(4, ((ValueTypeImpl)vt).getExternalRepresentation());
            surrogate = this.makeSurrogate((DBObject)vt, this.executeAndGetNewId(this.create_valuetype));
        }
        catch (Exception e) {
            cause = e;
        }
        finally {
            this.create_valuetype = this.close(this.create_valuetype);
        }
        if (surrogate == null || cause != null) {
            throw T2DBJMsg.exception(cause, "J10114", vt.getName());
        }
        vt.getSurrogate().upgrade(surrogate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteValueType(ValueType<?> vt) throws T2DBException {
        boolean done = false;
        SQLException cause = null;
        try {
            this.check(Permission.MODIFY, (DBObject)vt);
            if (vt.isBuiltIn()) {
                throw T2DBJMsg.exception("J10120", vt.getName());
            }
            int id = this.getId((DBObject)vt);
            if (id <= 9) {
                throw T2DBJMsg.exception("J10120", vt.getName());
            }
            int count = this.countProperties(vt);
            if (count > 0) {
                throw T2DBJMsg.exception("J10119", vt.getName(), count);
            }
            this.delete_valuetype = this.open(DELETE_VALUETYPE, (DBObject)vt, this.delete_valuetype);
            this.delete_valuetype.setInt(1, id);
            this.delete_valuetype.execute();
            boolean bl = done = this.delete_valuetype.getUpdateCount() > 0;
            if (done) {
                this.deleteValues(vt);
            }
        }
        catch (SQLException e) {
            cause = e;
        }
        finally {
            this.delete_valuetype = this.close(this.delete_valuetype);
        }
        if (!done || cause != null) {
            throw T2DBJMsg.exception(cause, "J10115", vt.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateValueType(ValueType<?> vt) throws T2DBException {
        boolean done = false;
        Exception cause = null;
        try {
            this.check(Permission.MODIFY, (DBObject)vt);
            this.update_valuetype = this.open(UPDATE_VALUETYPE, (DBObject)vt, this.update_valuetype);
            this.update_valuetype.setString(1, vt.getName());
            this.update_valuetype.setInt(2, this.getId((DBObject)vt));
            this.update_valuetype.execute();
            done = this.update_valuetype.getUpdateCount() > 0;
        }
        catch (Exception e) {
            cause = e;
        }
        finally {
            this.update_valuetype = this.close(this.update_valuetype);
        }
        if (!done || cause != null) {
            throw T2DBJMsg.exception(cause, "J10116", vt.getName());
        }
    }

    public <T> void updateValueType(ValueType<T> vt, Map<T, String> added, Map<T, String> edited, Set<T> deleted) throws T2DBException {
        this.check(Permission.MODIFY, (DBObject)vt);
        for (Map.Entry<T, String> e : added.entrySet()) {
            this.insertValueTypeValue(vt, vt.getScanner().toString(e.getKey()), e.getValue());
        }
        for (Map.Entry<T, String> e : edited.entrySet()) {
            this.updateValueTypeValue(vt, vt.getScanner().toString(e.getKey()), e.getValue());
        }
        for (Map.Entry<Object, String> value : deleted) {
            this.deleteValueTypeValue(vt, vt.toString(value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void insertValueTypeValue(ValueType<T> vt, String value, String description) throws T2DBException {
        boolean done = false;
        Exception cause = null;
        if (value == null) {
            throw new IllegalArgumentException("value null");
        }
        if (description == null) {
            description = "";
        }
        try {
            this.insert_valuelist = this.open(INSERT_VALUELIST, (DBObject)vt, this.insert_valuelist);
            this.insert_valuelist.setInt(1, this.getId((DBObject)vt));
            this.insert_valuelist.setString(2, value);
            this.insert_valuelist.setString(3, description);
            this.insert_valuelist.execute();
            done = this.insert_valuelist.getUpdateCount() > 0;
        }
        catch (Exception e) {
            cause = e;
        }
        finally {
            this.insert_valuelist = this.close(this.insert_valuelist);
        }
        if (!done || cause != null) {
            throw T2DBJMsg.exception(cause, "J10121", vt.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void updateValueTypeValue(ValueType<T> vt, String value, String description) throws T2DBException {
        boolean done = false;
        Exception cause = null;
        try {
            this.update_valuelist = this.open(UPDATE_VALUELIST, (DBObject)vt, this.update_valuelist);
            this.update_valuelist.setString(1, description);
            this.update_valuelist.setInt(2, this.getId((DBObject)vt));
            this.update_valuelist.setString(3, value);
            this.update_valuelist.execute();
            done = this.update_valuelist.getUpdateCount() > 0;
        }
        catch (Exception e) {
            cause = e;
        }
        finally {
            this.update_valuelist = this.close(this.update_valuelist);
        }
        if (!done || cause != null) {
            throw T2DBJMsg.exception(cause, "J10122", vt.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void deleteValueTypeValue(ValueType<T> vt, String value) throws T2DBException {
        boolean done = false;
        SQLException cause = null;
        String name = vt.getName();
        try {
            int id = this.getId((DBObject)vt);
            int count = this.countDefaultValues(vt, value);
            if (count > 0) {
                throw T2DBJMsg.exception("J10127", name, value, count);
            }
            count = this.countActualValues(vt, value);
            if (count > 0) {
                throw T2DBJMsg.exception("J10128", name, value, count);
            }
            this.delete_valuelist = this.open(DELETE_VALUELIST, (DBObject)vt, this.delete_valuelist);
            this.delete_valuelist.setInt(1, id);
            this.delete_valuelist.setString(2, value);
            this.delete_valuelist.execute();
            done = this.delete_valuelist.getUpdateCount() > 0;
        }
        catch (SQLException e) {
            cause = e;
        }
        finally {
            this.delete_valuelist = this.close(this.delete_valuelist);
        }
        if (!done || cause != null) {
            throw T2DBJMsg.exception(cause, "J10126", name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countProperties(ValueType<?> vt) throws T2DBException, SQLException {
        try {
            this.count_property = this.open(COUNT_PROPERTY, (DBObject)vt, this.count_property);
            this.count_property.setInt(1, this.getId((DBObject)vt));
            ResultSet rs = this.count_property.executeQuery();
            rs.next();
            int n = rs.getInt(1);
            return n;
        }
        finally {
            this.count_property = this.close(this.count_property);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> int countDefaultValues(ValueType<T> vt, String value) throws T2DBException, SQLException {
        try {
            this.count_default_values = this.open(COUNT_DEFAULT_VALUES, (DBObject)vt, this.count_default_values);
            this.count_default_values.setInt(1, this.getId((DBObject)vt));
            this.count_default_values.setString(2, value);
            ResultSet rs = this.count_default_values.executeQuery();
            rs.next();
            int n = rs.getInt(1);
            return n;
        }
        finally {
            this.count_default_values = this.close(this.count_default_values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> int countActualValues(ValueType<T> vt, String value) throws T2DBException, SQLException {
        try {
            this.count_actual_values = this.open(COUNT_ACTUAL_VALUES, (DBObject)vt, this.count_actual_values);
            this.count_actual_values.setString(1, value);
            this.count_actual_values.setInt(2, this.getId((DBObject)vt));
            ResultSet rs = this.count_actual_values.executeQuery();
            rs.next();
            int n = rs.getInt(1);
            return n;
        }
        finally {
            this.count_actual_values = this.close(this.count_actual_values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteValues(ValueType<?> vt) throws T2DBException, SQLException {
        try {
            this.delete_values = this.open(DELETE_VALUES, (DBObject)vt, this.delete_values);
            this.delete_values.setInt(1, this.getId((DBObject)vt));
            this.delete_values.execute();
        }
        finally {
            this.delete_values = this.close(this.delete_values);
        }
    }
}

