/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.jdbc;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.api.AttributeDefinition;
import ch.agent.crnickl.api.DBObject;
import ch.agent.crnickl.api.DBObjectType;
import ch.agent.crnickl.api.Database;
import ch.agent.crnickl.api.Property;
import ch.agent.crnickl.api.Schema;
import ch.agent.crnickl.api.SeriesDefinition;
import ch.agent.crnickl.api.Surrogate;
import ch.agent.crnickl.api.UpdatableSchema;
import ch.agent.crnickl.impl.Permission;
import ch.agent.crnickl.impl.SchemaUpdatePolicy;
import ch.agent.crnickl.impl.UpdatableSchemaImpl;
import ch.agent.crnickl.jdbc.ReadMethodsForSchema;
import ch.agent.crnickl.jdbc.T2DBJMsg;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public class WriteMethodsForSchema
extends ReadMethodsForSchema {
    private PreparedStatement create_schema;
    private static final String CREATE_SCHEMA = "insert into schema_name(parent, label) values(?, ?)";
    private PreparedStatement delete_schema;
    private PreparedStatement delete_schema_components;
    private static final String DELETE_SCHEMA = "delete from schema_name where id = ?";
    private static final String DELETE_SCHEMA_COMPONENTS = "delete from schema_item where id = ?";
    private PreparedStatement create_schema_component;
    private static final String CREATE_SCHEMA_COMPONENT = "insert into schema_item(id, ssn, attrib, prop, value, descrip) values(?, ?, ?, ?, ?, ?)";
    private PreparedStatement update_schema;
    private static final String UPDATE_SCHEMA = "update schema_name set label = ?, parent = ? where id = ?";
    private PreparedStatement delete_schema_by_attribute;
    private static final String DELETE_SCHEMA_BY_ATTRIBUTE = "delete from schema_item where id = ? and ssn = ? and attrib = ?";
    private PreparedStatement delete_schema_by_series;
    private static final String DELETE_SCHEMA_BY_SERIES = "delete from schema_item where id = ? and ssn = ?";
    private PreparedStatement update_schema_by_attribute;
    private static final String UPDATE_SCHEMA_BY_ATTRIBUTE = "update schema_item set value = ?, descrip = ? where id = ? and ssn = ? and attrib = ?";
    private PreparedStatement find_entity_with_schema;
    private static final String FIND_ENTITY_WITH_SCHEMA = "select id from chronicle where schema_id != 0";
    private PreparedStatement find_entity_with_property;
    private static final String FIND_ENTITY_WITH_PROPERTY = "select chronicle from attribute_value where prop = ?";
    private PreparedStatement find_entity_with_series;
    private static final String FIND_ENTITY_WITH_SERIES = "select chronicle from series where ssn = ?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSchema(UpdatableSchemaImpl schema, Schema base) throws T2DBException {
        Surrogate surrogate = null;
        Exception cause = null;
        try {
            this.check(Permission.CREATE, (DBObject)schema);
            if (base != null) {
                this.check(Permission.READ, (DBObject)base);
            }
            this.create_schema = this.open(CREATE_SCHEMA, (DBObject)schema, this.create_schema);
            this.create_schema.setInt(1, this.getIdOrZero((DBObject)base));
            this.create_schema.setString(2, schema.getName());
            surrogate = this.makeSurrogate((DBObject)schema, this.executeAndGetNewId(this.create_schema));
        }
        catch (Exception e) {
            cause = e;
        }
        finally {
            this.create_schema = this.close(this.create_schema);
        }
        if (surrogate == null || cause != null) {
            throw T2DBJMsg.exception(cause, "J30122", schema.getName());
        }
        schema.getSurrogate().upgrade(surrogate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSchema(UpdatableSchemaImpl schema, SchemaUpdatePolicy policy) throws T2DBException {
        boolean done = false;
        Exception cause = null;
        try {
            this.check(Permission.MODIFY, (DBObject)schema);
            policy.willDelete((UpdatableSchema)schema);
            this.delete_schema_components = this.open(DELETE_SCHEMA_COMPONENTS, (DBObject)schema, this.delete_schema_components);
            int id = this.getId((DBObject)schema);
            this.delete_schema_components.setInt(1, id);
            this.delete_schema_components.execute();
            this.delete_schema = this.open(DELETE_SCHEMA, (DBObject)schema, this.delete_schema);
            this.delete_schema.setInt(1, id);
            this.delete_schema.execute();
            done = this.delete_schema.getUpdateCount() > 0;
        }
        catch (Exception e) {
            cause = e;
        }
        finally {
            this.delete_schema_components = this.close(this.delete_schema_components);
            this.delete_schema = this.close(this.delete_schema);
        }
        if (!done || cause != null) {
            throw T2DBJMsg.exception(cause, "J30123", schema.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSchemaComponent(UpdatableSchema schema, int seriesNr, String description, AttributeDefinition<?> def) throws T2DBException {
        boolean done = false;
        try {
            this.check(Permission.MODIFY, (DBObject)schema);
            this.create_schema_component = this.open(CREATE_SCHEMA_COMPONENT, (DBObject)schema, this.create_schema_component);
            this.create_schema_component.setInt(1, this.getId((DBObject)schema));
            this.create_schema_component.setInt(2, seriesNr);
            this.create_schema_component.setInt(3, def.getNumber());
            if (def.isErasing()) {
                this.create_schema_component.setInt(4, 0);
                this.create_schema_component.setString(5, "");
                this.create_schema_component.setString(6, "");
            } else {
                Property prop = def.getProperty();
                if (prop == null) {
                    throw T2DBJMsg.exception("J30130", new Object[0]);
                }
                this.create_schema_component.setInt(4, this.getId((DBObject)prop));
                String value = def.getProperty().getValueType().toString(def.getValue());
                this.create_schema_component.setString(5, value == null ? "" : value);
                this.create_schema_component.setString(6, description == null ? "" : description);
            }
            this.create_schema_component.execute();
            done = this.create_schema_component.getUpdateCount() > 0;
        }
        catch (Exception e) {
            if (!done) {
                if (seriesNr == 0) {
                    throw T2DBJMsg.exception(e, "J30124", def.getNumber());
                }
                throw T2DBJMsg.exception(e, "J30125", def.getNumber(), seriesNr);
            }
        }
        finally {
            this.create_schema_component = this.close(this.create_schema_component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateSchema(UpdatableSchema schema, UpdatableSchema base, String name) throws T2DBException {
        boolean done = false;
        Exception cause = null;
        ReadMethodsForSchema.RawSchema rawSchema = this.getRawSchema(schema.getSurrogate());
        boolean nameEdited = this.nameEdited(schema, rawSchema);
        boolean baseEdited = this.baseEdited(schema, rawSchema);
        if (nameEdited || baseEdited) {
            try {
                this.check(Permission.MODIFY, (DBObject)schema);
                UpdatableSchema previousBase = ((UpdatableSchemaImpl)schema).getPreviousBase();
                if (schema.getBase() != null && !schema.getBase().equals(previousBase)) {
                    this.check(Permission.READ, (DBObject)schema.getBase());
                }
                this.update_schema = this.open(UPDATE_SCHEMA, (DBObject)schema, this.update_schema);
                this.update_schema.setString(1, name);
                this.update_schema.setInt(2, this.getIdOrZero((DBObject)base));
                this.update_schema.setInt(3, this.getId((DBObject)schema));
                this.update_schema.execute();
                done = this.update_schema.getUpdateCount() > 0;
            }
            catch (Exception e) {
                cause = e;
            }
            finally {
                this.update_schema = this.close(this.update_schema);
            }
            if (!done || cause != null) {
                throw T2DBJMsg.exception(cause, "J30126", schema);
            }
        }
        return done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSchemaComponent(UpdatableSchema schema, int seriesNr, int attribNr) throws T2DBException {
        boolean done = false;
        Exception cause = null;
        try {
            this.check(Permission.MODIFY, (DBObject)schema);
            this.delete_schema_by_attribute = this.open(DELETE_SCHEMA_BY_ATTRIBUTE, (DBObject)schema, this.delete_schema_by_attribute);
            this.delete_schema_by_attribute.setInt(1, this.getId((DBObject)schema));
            this.delete_schema_by_attribute.setInt(2, seriesNr);
            this.delete_schema_by_attribute.setInt(3, attribNr);
            this.delete_schema_by_attribute.execute();
            if (this.delete_schema_by_attribute.getUpdateCount() > 0) {
                done = true;
            }
        }
        catch (Exception e) {
            cause = e;
        }
        finally {
            this.delete_schema_by_attribute = this.close(this.delete_schema_by_attribute);
        }
        if (!done || cause != null) {
            throw T2DBJMsg.exception(cause, "J30128", schema, seriesNr, attribNr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSchemaComponents(UpdatableSchema schema, int seriesNr) throws T2DBException {
        boolean done = false;
        Exception cause = null;
        try {
            this.check(Permission.MODIFY, (DBObject)schema);
            this.delete_schema_by_series = this.open(DELETE_SCHEMA_BY_SERIES, (DBObject)schema, this.delete_schema_by_series);
            this.delete_schema_by_series.setInt(1, this.getId((DBObject)schema));
            this.delete_schema_by_series.setInt(2, seriesNr);
            this.delete_schema_by_series.execute();
            if (this.delete_schema_by_series.getUpdateCount() > 0) {
                done = true;
            }
        }
        catch (Exception e) {
            cause = e;
        }
        finally {
            this.delete_schema_by_series = this.close(this.delete_schema_by_series);
        }
        if (!done || cause != null) {
            throw T2DBJMsg.exception(cause, "J30129", schema, seriesNr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSchemaComponent(UpdatableSchema schema, int seriesNr, String description, AttributeDefinition<?> def) throws T2DBException {
        boolean done = false;
        Exception cause = null;
        try {
            this.check(Permission.MODIFY, (DBObject)schema);
            this.update_schema_by_attribute = this.open(UPDATE_SCHEMA_BY_ATTRIBUTE, (DBObject)schema, this.update_schema_by_attribute);
            String value = def.getProperty().getValueType().toString(def.getValue());
            this.update_schema_by_attribute.setString(1, value == null ? "" : value);
            this.update_schema_by_attribute.setString(2, description == null ? "" : description);
            this.update_schema_by_attribute.setInt(3, this.getId((DBObject)schema));
            this.update_schema_by_attribute.setInt(4, seriesNr);
            this.update_schema_by_attribute.setInt(5, def.getNumber());
            this.update_schema_by_attribute.execute();
            if (this.update_schema_by_attribute.getUpdateCount() > 0) {
                done = true;
            }
        }
        catch (Exception e) {
            cause = e;
        }
        finally {
            this.update_schema_by_attribute = this.close(this.update_schema_by_attribute);
        }
        if (!done || cause != null) {
            throw T2DBJMsg.exception(cause, "J30127", schema, seriesNr, def.getNumber());
        }
    }

    private boolean nameEdited(UpdatableSchema schema, ReadMethodsForSchema.RawSchema current) {
        return !schema.getName().equals(current.getName());
    }

    private boolean baseEdited(UpdatableSchema schema, ReadMethodsForSchema.RawSchema current) {
        int currentBaseId;
        UpdatableSchema base = schema.getBase();
        int editedBaseId = this.getIdOrZero((DBObject)base);
        return editedBaseId != (currentBaseId = current.getParent());
    }

    public Collection<Surrogate> findChronicles(Collection<UpdatableSchema> schemas) throws T2DBException {
        ArrayList<Surrogate> result = new ArrayList<Surrogate>();
        if (schemas.size() > 0) {
            HashSet<Integer> schemaIds = new HashSet<Integer>(schemas.size());
            for (UpdatableSchema s : schemas) {
                schemaIds.add(this.getId((DBObject)s));
            }
            Database database = schemas.iterator().next().getSurrogate().getDatabase();
            try {
                this.find_entity_with_schema = this.open(FIND_ENTITY_WITH_SCHEMA, database, this.find_entity_with_schema);
                ResultSet rs = this.find_entity_with_schema.executeQuery();
                while (rs.next()) {
                    if (!schemaIds.contains(rs.getInt(1))) continue;
                    result.add(this.makeSurrogate(database, DBObjectType.CHRONICLE, rs.getInt(1)));
                }
            }
            catch (Exception e) {
                throw T2DBJMsg.exception(e, "J30117", new Object[0]);
            }
            finally {
                this.find_entity_with_schema = this.close(this.find_entity_with_schema);
            }
        }
        return result;
    }

    public Collection<Surrogate> findChronicles(Property<?> property, Collection<UpdatableSchema> schemas) throws T2DBException {
        ArrayList<Surrogate> result = new ArrayList<Surrogate>();
        Database database = property.getSurrogate().getDatabase();
        HashSet<Integer> schemaIds = new HashSet<Integer>(schemas.size());
        for (UpdatableSchema s : schemas) {
            schemaIds.add(this.getId((DBObject)s));
        }
        try {
            this.find_entity_with_property = this.open(FIND_ENTITY_WITH_PROPERTY, (DBObject)property, this.find_entity_with_property);
            this.find_entity_with_property.setInt(1, this.getId((DBObject)property));
            ResultSet rs = this.find_entity_with_property.executeQuery();
            while (rs.next()) {
                Surrogate entityKey;
                Schema schema;
                if (!schemaIds.contains(rs.getInt(1)) || !schemaIds.contains(this.getId((DBObject)(schema = database.getChronicle(entityKey = this.makeSurrogate(database, DBObjectType.CHRONICLE, rs.getInt(1))).getSchema(true))))) continue;
                result.add(entityKey);
            }
        }
        catch (Exception e) {
            throw T2DBJMsg.exception(e, "J30117", new Object[0]);
        }
        finally {
            this.find_entity_with_property = this.close(this.find_entity_with_property);
        }
        return result;
    }

    public Collection<Surrogate> findChronicles(SeriesDefinition ss, Collection<UpdatableSchema> schemas) throws T2DBException {
        ArrayList<Surrogate> result = new ArrayList<Surrogate>();
        if (schemas.size() > 0) {
            HashSet<Integer> schemaIds = new HashSet<Integer>(schemas.size());
            for (UpdatableSchema s : schemas) {
                schemaIds.add(this.getId((DBObject)s));
            }
            Database database = schemas.iterator().next().getSurrogate().getDatabase();
            try {
                this.find_entity_with_series = this.open(FIND_ENTITY_WITH_SERIES, database, this.find_entity_with_series);
                this.find_entity_with_series.setInt(1, ss.getNumber());
                ResultSet rs = this.find_entity_with_series.executeQuery();
                while (rs.next()) {
                    Surrogate entityKey;
                    Schema schema;
                    if (!schemaIds.contains(rs.getInt(1)) || !schemaIds.contains(this.getId((DBObject)(schema = database.getChronicle(entityKey = this.makeSurrogate(database, DBObjectType.CHRONICLE, rs.getInt(1))).getSchema(true))))) continue;
                    result.add(entityKey);
                }
            }
            catch (Exception e) {
                throw T2DBJMsg.exception(e, "J30117", new Object[0]);
            }
            finally {
                this.find_entity_with_series = this.close(this.find_entity_with_series);
            }
        }
        return result;
    }
}

