/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.jdbc;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.api.DBObjectType;
import ch.agent.crnickl.api.Database;
import ch.agent.crnickl.api.Property;
import ch.agent.crnickl.api.Surrogate;
import ch.agent.crnickl.api.ValueType;
import ch.agent.crnickl.impl.PropertyImpl;
import ch.agent.crnickl.jdbc.JDBCDatabase;
import ch.agent.crnickl.jdbc.JDBCDatabaseMethods;
import ch.agent.crnickl.jdbc.ReadMethodsForValueType;
import ch.agent.crnickl.jdbc.T2DBJMsg;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;

public class ReadMethodsForProperty
extends JDBCDatabaseMethods {
    private PreparedStatement select_property_by_name;
    private static final String SELECT_PROPERTY_BY_NAME = "select id, type, label from property where label = ?";
    private PreparedStatement select_property_by_pattern;
    private static final String SELECT_PROPERTY_BY_PATTERN = "select id, type, label from property where label like ? order by label";
    private PreparedStatement select_property_by_id;
    private static final String SELECT_PROPERTY_BY_ID = "select id, type, label from property where id = ?";

    public Property<?> getProperty(Database database, String name) throws T2DBException {
        try {
            this.select_property_by_name = this.open(SELECT_PROPERTY_BY_NAME, database, this.select_property_by_name);
            this.select_property_by_name.setString(1, name);
            ResultSet rs = this.select_property_by_name.executeQuery();
            if (rs.next()) {
                Surrogate surrogate = this.makeSurrogate(database, DBObjectType.PROPERTY, rs.getInt(1));
                Property<?> property = this.getProperty(surrogate, rs.getString(3), rs.getInt(2));
                return property;
            }
            Property<?> property = null;
            return property;
        }
        catch (Exception e) {
            throw T2DBJMsg.exception(e, "J20104", name);
        }
        finally {
            this.select_property_by_name = this.close(this.select_property_by_name);
        }
    }

    public Collection<Property<?>> getProperties(Database database, String pattern) throws T2DBException {
        if (pattern == null) {
            pattern = "*";
        }
        pattern = pattern.replace('*', '%');
        ArrayList result = new ArrayList();
        try {
            this.select_property_by_pattern = this.open(SELECT_PROPERTY_BY_PATTERN, database, this.select_property_by_pattern);
            this.select_property_by_pattern.setString(1, pattern);
            ResultSet rs = this.select_property_by_pattern.executeQuery();
            while (rs.next()) {
                Surrogate surrogate = this.makeSurrogate(database, DBObjectType.PROPERTY, rs.getInt(1));
                result.add(this.getProperty(surrogate, rs.getString(3), rs.getInt(2)));
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        catch (Exception e) {
            throw T2DBJMsg.exception(e, "J20106", pattern);
        }
        finally {
            this.select_property_by_pattern = this.close(this.select_property_by_pattern);
        }
    }

    public Property<?> getProperty(Surrogate surrogate) throws T2DBException {
        try {
            this.select_property_by_id = this.open(SELECT_PROPERTY_BY_ID, surrogate, this.select_property_by_id);
            this.select_property_by_id.setInt(1, this.getId(surrogate));
            ResultSet rs = this.select_property_by_id.executeQuery();
            if (rs.next()) {
                Property<?> property = this.getProperty(surrogate, rs.getString(3), rs.getInt(2));
                return property;
            }
            Property<?> property = null;
            return property;
        }
        catch (Exception e) {
            throw T2DBJMsg.exception(e, "J20105", surrogate.toString());
        }
        finally {
            this.select_property_by_id = this.close(this.select_property_by_id);
        }
    }

    private ReadMethodsForValueType getVTRMethods(Surrogate surrogate) throws T2DBException {
        try {
            return ((JDBCDatabase)surrogate.getDatabase()).getReadMethodsForValueType();
        }
        catch (Exception e) {
            throw T2DBJMsg.exception("J01101", surrogate.getDatabase().getClass().getName(), JDBCDatabase.class.getName());
        }
    }

    private <T> Property<?> getProperty(Surrogate surrogate, String name, int valueTypeId) throws T2DBException, SQLException {
        Surrogate vtKey = this.makeSurrogate(surrogate.getDatabase(), DBObjectType.VALUE_TYPE, valueTypeId);
        ValueType vt = this.getVTRMethods(surrogate).getValueType(vtKey);
        return new PropertyImpl(name, vt, true, surrogate);
    }
}

