/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.jdbc;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.api.DatabaseConfiguration;
import ch.agent.crnickl.jdbc.T2DBJMsg;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public class JDBCSession {
    private DatabaseConfiguration configuration;
    private String url;
    private String user;
    private Connection connection = null;
    public static final String JDBC_DRIVER = "session.jdbcDriver";
    public static final String JDBC_URL = "session.jdbcUrl";
    public static final String JDBC_DB = "session.db";
    public static final String JDBC_USER = "session.user";
    public static final String JDBC_PASSWORD = "session.password";

    private JDBCSession() {
    }

    public JDBCSession(DatabaseConfiguration configuration) {
        if (Singleton.jdbc_connection.configuration != null) {
            throw new IllegalStateException("already initialized");
        }
        Singleton.jdbc_connection.configuration = configuration;
    }

    public static JDBCSession getInstance() {
        if (Singleton.jdbc_connection.configuration == null) {
            throw new IllegalStateException("not initialized");
        }
        return Singleton.jdbc_connection;
    }

    public static void rollbackIfAlive() {
        try {
            if (Singleton.jdbc_connection.configuration != null) {
                Singleton.jdbc_connection.rollback();
            }
        }
        catch (T2DBException t2DBException) {
            // empty catch block
        }
    }

    private void open() throws T2DBException {
        Properties prop = new Properties();
        String driver = null;
        try {
            driver = this.configuration.getParameter(JDBC_DRIVER, true);
            Class.forName(driver);
            String db = this.configuration.getParameter(JDBC_DB, true);
            this.url = String.format(this.configuration.getParameter(JDBC_URL, true), db);
            this.user = this.configuration.getParameter(JDBC_USER, true);
            prop.setProperty("user", this.user);
            prop.setProperty("password", this.configuration.getParameter(JDBC_PASSWORD, true));
            this.configuration.setParameter(JDBC_USER, "000000");
            this.configuration.setParameter(JDBC_PASSWORD, "000000");
            prop.setProperty("useServerPrepStmts", "false");
            this.connection = DriverManager.getConnection(this.url, prop);
            this.connection.setAutoCommit(false);
        }
        catch (ClassNotFoundException e) {
            throw T2DBJMsg.exception(e, "J00105", new Object[0]);
        }
        catch (SQLException e) {
            throw T2DBJMsg.exception(e, "J00104", driver, this.toString());
        }
        finally {
            prop.setProperty("user", "xxx");
            prop.setProperty("password", "xxx");
        }
    }

    public void close(boolean ignoreException) throws T2DBException {
        block3: {
            try {
                if (this.isOpen()) {
                    this.connection.close();
                }
                this.connection = null;
            }
            catch (Exception e) {
                if (ignoreException) break block3;
                throw T2DBJMsg.exception("J00110", this.toString());
            }
        }
    }

    public Connection getConnection() throws T2DBException {
        if (!this.isOpen()) {
            this.open();
        }
        return this.connection;
    }

    private boolean isOpen() {
        return this.connection != null;
    }

    public void commit() throws T2DBException {
        try {
            this.getConnection().commit();
        }
        catch (SQLException e) {
            throw T2DBJMsg.exception(e, "J00106", new Object[0]);
        }
    }

    public void rollback() throws T2DBException {
        try {
            this.getConnection().rollback();
        }
        catch (SQLException e) {
            throw T2DBJMsg.exception(e, "J00107", new Object[0]);
        }
    }

    public String getURL() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public String toString() {
        return String.format("%s@%s", this.user, this.url);
    }

    private static class Singleton {
        private static JDBCSession jdbc_connection = new JDBCSession();

        private Singleton() {
        }
    }
}

