/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.jdbc;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.api.DBObject;
import ch.agent.crnickl.api.Database;
import ch.agent.crnickl.api.Surrogate;
import ch.agent.crnickl.impl.DatabaseMethodsImpl;
import ch.agent.crnickl.jdbc.JDBCDatabase;
import ch.agent.crnickl.jdbc.T2DBJMsg;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class JDBCDatabaseMethods
extends DatabaseMethodsImpl {
    public int executeAndGetNewId(PreparedStatement stmt) throws T2DBException, SQLException {
        ResultSet rs;
        int id = -1;
        stmt.execute();
        if (stmt.getUpdateCount() > 0 && (rs = stmt.getGeneratedKeys()).next()) {
            id = rs.getInt(1);
        }
        if (id < 0) {
            throw T2DBJMsg.exception("J00108", new Object[0]);
        }
        return id;
    }

    public PreparedStatement open(String sql, Database database, PreparedStatement stmt) throws T2DBException {
        try {
            if (stmt != null && ((JDBCDatabase)database).getConnection().equals(stmt.getConnection())) {
                return stmt;
            }
            return ((JDBCDatabase)database).getConnection().prepareStatement(sql, 1);
        }
        catch (SQLException e) {
            throw T2DBJMsg.exception(e, "J00101", sql);
        }
    }

    public PreparedStatement open(String sql, DBObject dBObject, PreparedStatement stmt) throws T2DBException {
        return this.open(sql, dBObject.getSurrogate().getDatabase(), stmt);
    }

    public PreparedStatement open(String sql, Surrogate surrogate, PreparedStatement stmt) throws T2DBException {
        return this.open(sql, surrogate.getDatabase(), stmt);
    }

    public PreparedStatement close(PreparedStatement stmt) throws T2DBException {
        try {
            if (stmt != null) {
                stmt.close();
                stmt = null;
            }
            return stmt;
        }
        catch (SQLException e) {
            throw T2DBJMsg.exception(e, "J00102", new Object[0]);
        }
    }
}

