/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.jdbc;

import ch.agent.core.KeyedMessage;
import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.api.Attribute;
import ch.agent.crnickl.api.AttributeDefinition;
import ch.agent.crnickl.api.Chronicle;
import ch.agent.crnickl.api.DBObject;
import ch.agent.crnickl.api.DBObjectType;
import ch.agent.crnickl.api.Database;
import ch.agent.crnickl.api.DatabaseConfiguration;
import ch.agent.crnickl.api.Property;
import ch.agent.crnickl.api.Schema;
import ch.agent.crnickl.api.Series;
import ch.agent.crnickl.api.SeriesDefinition;
import ch.agent.crnickl.api.Surrogate;
import ch.agent.crnickl.api.UpdatableChronicle;
import ch.agent.crnickl.api.UpdatableProperty;
import ch.agent.crnickl.api.UpdatableSchema;
import ch.agent.crnickl.api.UpdatableSeries;
import ch.agent.crnickl.api.UpdatableValueType;
import ch.agent.crnickl.api.UpdateEvent;
import ch.agent.crnickl.api.UpdateEventOperation;
import ch.agent.crnickl.api.ValueType;
import ch.agent.crnickl.impl.DatabaseBackendImpl;
import ch.agent.crnickl.impl.UpdatableSchemaImpl;
import ch.agent.crnickl.impl.UpdateEventImpl;
import ch.agent.crnickl.impl.UpdateEventPublisherImpl;
import ch.agent.crnickl.jdbc.AccessMethodsForNumber;
import ch.agent.crnickl.jdbc.JDBCSession;
import ch.agent.crnickl.jdbc.ReadMethodsForChroniclesAndSeries;
import ch.agent.crnickl.jdbc.ReadMethodsForProperty;
import ch.agent.crnickl.jdbc.ReadMethodsForSchema;
import ch.agent.crnickl.jdbc.ReadMethodsForValueType;
import ch.agent.crnickl.jdbc.T2DBJMsg;
import ch.agent.crnickl.jdbc.WriteMethodsForChroniclesAndSeries;
import ch.agent.crnickl.jdbc.WriteMethodsForProperty;
import ch.agent.crnickl.jdbc.WriteMethodsForSchema;
import ch.agent.crnickl.jdbc.WriteMethodsForValueType;
import java.sql.Connection;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class JDBCDatabase
extends DatabaseBackendImpl {
    private ReadMethodsForChroniclesAndSeries esRMethods;
    private WriteMethodsForChroniclesAndSeries esWMethods;
    private ReadMethodsForValueType vtRMethods;
    private WriteMethodsForValueType vtWMethods;
    private ReadMethodsForProperty pRMethods;
    private WriteMethodsForProperty pWMethods;
    private ReadMethodsForSchema sRMethods;
    private WriteMethodsForSchema sWMethods;
    private JDBCSession session;

    public JDBCDatabase(String name) {
        super(name);
    }

    public void configure(DatabaseConfiguration configuration) throws T2DBException {
        new JDBCSession(configuration);
        super.configure(configuration);
        this.setAccessMethods(ValueType.StandardValueType.NUMBER.name(), new AccessMethodsForNumber());
    }

    private JDBCSession getJDBCSession() {
        if (this.session == null) {
            this.session = JDBCSession.getInstance();
        }
        return this.session;
    }

    public Connection getConnection() throws T2DBException {
        return this.getJDBCSession().getConnection();
    }

    public void commit() throws T2DBException {
        this.getJDBCSession().commit();
        ((UpdateEventPublisherImpl)this.getUpdateEventPublisher()).release();
    }

    public void rollback() throws T2DBException {
        JDBCSession.rollbackIfAlive();
        int count = ((UpdateEventPublisherImpl)this.getUpdateEventPublisher()).clear();
        this.getMessageListener().log(Level.FINER, (KeyedMessage)new T2DBJMsg("J00111", count));
    }

    protected ReadMethodsForChroniclesAndSeries getReadMethodsForChronicleAndSeries() {
        if (this.esRMethods == null) {
            this.esRMethods = new ReadMethodsForChroniclesAndSeries();
        }
        return this.esRMethods;
    }

    protected WriteMethodsForChroniclesAndSeries getWriteMethodsForChroniclesAndSeries() {
        if (this.esWMethods == null) {
            this.esWMethods = new WriteMethodsForChroniclesAndSeries();
        }
        return this.esWMethods;
    }

    public void create(UpdatableChronicle entity) throws T2DBException {
        this.getWriteMethodsForChroniclesAndSeries().createChronicle((Chronicle)entity);
        this.publish(new UpdateEventImpl(UpdateEventOperation.CREATE, (DBObject)entity).withComment(entity.getDescription(false)));
    }

    public void update(UpdatableChronicle entity) throws T2DBException {
        this.getWriteMethodsForChroniclesAndSeries().updateChronicle(entity, this.getChronicleUpdatePolicy());
        this.publish((UpdateEvent)new UpdateEventImpl(UpdateEventOperation.MODIFY, (DBObject)entity));
    }

    public void deleteAttributeValue(UpdatableChronicle entity, AttributeDefinition<?> def) throws T2DBException {
        this.getWriteMethodsForChroniclesAndSeries().deleteAttribute((Chronicle)entity, def);
        this.publish(new UpdateEventImpl(UpdateEventOperation.MODIFY, (DBObject)entity).withComment("delete attribute #" + def.getNumber()));
    }

    public void update(UpdatableChronicle entity, AttributeDefinition<?> def, String value, String description) throws T2DBException {
        this.getWriteMethodsForChroniclesAndSeries().updateAttribute(entity, def, value, description);
        this.publish(new UpdateEventImpl(UpdateEventOperation.MODIFY, (DBObject)entity).withComment(String.format("%s=%s", def.getProperty().getName(), value)));
    }

    public void deleteChronicle(UpdatableChronicle entity) throws T2DBException {
        this.getWriteMethodsForChroniclesAndSeries().deleteChronicle(entity, this.getChronicleUpdatePolicy());
        String comment = this.getNamingPolicy().joinValueAndDescription(entity.getName(true), entity.getDescription(false));
        this.publish(new UpdateEventImpl(UpdateEventOperation.DELETE, (DBObject)entity).withComment(comment));
    }

    public <T> void create(UpdatableSeries<T> series) throws T2DBException {
        this.getWriteMethodsForChroniclesAndSeries().createSeries((Series<?>)series);
        this.publish((UpdateEvent)new UpdateEventImpl(UpdateEventOperation.CREATE, series));
    }

    public <T> void deleteSeries(UpdatableSeries<T> series) throws T2DBException {
        this.getWriteMethodsForChroniclesAndSeries().deleteSeries(series, this.getChronicleUpdatePolicy());
        String comment = this.getNamingPolicy().joinValueAndDescription(series.getName(true), series.getDescription(false));
        this.publish(new UpdateEventImpl(UpdateEventOperation.DELETE, series).withComment(comment));
    }

    public Chronicle getChronicle(Chronicle chronicle) throws T2DBException {
        return this.getReadMethodsForChronicleAndSeries().getChronicle(chronicle.getSurrogate());
    }

    public Chronicle getChronicleOrNull(Chronicle parent, String simpleName) throws T2DBException {
        return this.getReadMethodsForChronicleAndSeries().getChronicleOrNull(parent, simpleName);
    }

    public Collection<Chronicle> getChroniclesByParent(Chronicle parent) throws T2DBException {
        return this.getReadMethodsForChronicleAndSeries().getChroniclesByParent(parent);
    }

    public <T> List<Chronicle> getChroniclesByAttributeValue(Property<T> property, T value, int maxSize) throws T2DBException {
        return this.getReadMethodsForChronicleAndSeries().getChroniclesByAttributeValue(property, value, maxSize);
    }

    public boolean getAttributeValue(List<Chronicle> chronicles, Attribute<?> attribute) throws T2DBException {
        return this.getReadMethodsForChronicleAndSeries().getAttributeValue(chronicles, attribute);
    }

    public <T> Series<T>[] getSeries(Chronicle chronicle, String[] names, int[] numbers) throws T2DBException {
        return this.getReadMethodsForChronicleAndSeries().getSeries(chronicle, names, numbers);
    }

    public <T> Series<T> getSeries(Surrogate surrogate) throws T2DBException {
        this.checkSurrogate(surrogate, DBObjectType.SERIES);
        Series series = this.getReadMethodsForChronicleAndSeries().getSeries(surrogate);
        if (series == null) {
            throw T2DBJMsg.exception("J50104", surrogate.toString());
        }
        return series;
    }

    protected ReadMethodsForProperty getReadMethodsForProperty() {
        if (this.pRMethods == null) {
            this.pRMethods = new ReadMethodsForProperty();
        }
        return this.pRMethods;
    }

    protected WriteMethodsForProperty getWriteMethodsForProperty() {
        if (this.pWMethods == null) {
            this.pWMethods = new WriteMethodsForProperty();
        }
        return this.pWMethods;
    }

    public Collection<Property<?>> getProperties(String pattern) throws T2DBException {
        return this.getReadMethodsForProperty().getProperties((Database)this, pattern);
    }

    public Property<?> getProperty(Surrogate surrogate) throws T2DBException {
        this.checkSurrogate(surrogate, DBObjectType.PROPERTY);
        Property<?> vt = this.getReadMethodsForProperty().getProperty(surrogate);
        if (vt == null) {
            throw T2DBJMsg.exception("J20109", surrogate.toString());
        }
        return vt;
    }

    public Property<?> getProperty(String name) throws T2DBException {
        return this.getReadMethodsForProperty().getProperty((Database)this, name);
    }

    public void create(UpdatableProperty<?> property) throws T2DBException {
        this.getWriteMethodsForProperty().createProperty((Property<?>)property);
        this.publish((UpdateEvent)new UpdateEventImpl(UpdateEventOperation.CREATE, property));
    }

    public void deleteProperty(UpdatableProperty<?> property) throws T2DBException {
        this.getWriteMethodsForProperty().deleteProperty((Property<?>)property);
        String comment = property.getName();
        this.publish(new UpdateEventImpl(UpdateEventOperation.DELETE, property).withComment(comment));
    }

    public void update(UpdatableProperty<?> property) throws T2DBException {
        this.getWriteMethodsForProperty().updateProperty((Property<?>)property);
        this.publish((UpdateEvent)new UpdateEventImpl(UpdateEventOperation.MODIFY, property));
    }

    protected ReadMethodsForValueType getReadMethodsForValueType() {
        if (this.vtRMethods == null) {
            this.vtRMethods = new ReadMethodsForValueType();
        }
        return this.vtRMethods;
    }

    protected WriteMethodsForValueType getWriteMethodsForValueType() {
        if (this.vtWMethods == null) {
            this.vtWMethods = new WriteMethodsForValueType();
        }
        return this.vtWMethods;
    }

    public Collection<ValueType<?>> getValueTypes(String pattern) throws T2DBException {
        return this.getReadMethodsForValueType().getValueTypes((Database)this, pattern);
    }

    public <T> ValueType<T> getValueType(String name) throws T2DBException {
        ValueType vt = this.getReadMethodsForValueType().getValueType((Database)this, name);
        if (vt == null) {
            throw T2DBJMsg.exception("J10109", name);
        }
        return vt;
    }

    public <T> ValueType<T> getValueType(Surrogate surrogate) throws T2DBException {
        this.checkSurrogate(surrogate, DBObjectType.VALUE_TYPE);
        ValueType vt = this.getReadMethodsForValueType().getValueType(surrogate);
        if (vt == null) {
            throw T2DBJMsg.exception("J10110", surrogate.toString());
        }
        return vt;
    }

    public <T> void create(UpdatableValueType<T> valueType) throws T2DBException {
        this.getWriteMethodsForValueType().createValueType((ValueType<?>)valueType);
        this.publish((UpdateEvent)new UpdateEventImpl(UpdateEventOperation.CREATE, valueType));
    }

    public void deleteValueType(UpdatableValueType<?> valueType) throws T2DBException {
        this.getWriteMethodsForValueType().deleteValueType((ValueType<?>)valueType);
        String comment = valueType.getName();
        this.publish(new UpdateEventImpl(UpdateEventOperation.DELETE, valueType).withComment(comment));
    }

    public void update(UpdatableValueType<?> valueType) throws T2DBException {
        this.getWriteMethodsForValueType().updateValueType((ValueType<?>)valueType);
        this.publish((UpdateEvent)new UpdateEventImpl(UpdateEventOperation.MODIFY, valueType));
    }

    public <T> void update(UpdatableValueType<T> valueType, Map<T, String> added, Map<T, String> edited, Set<T> deleted) throws T2DBException {
        this.getWriteMethodsForValueType().updateValueType(valueType, added, edited, deleted);
        this.publish((UpdateEvent)new UpdateEventImpl(UpdateEventOperation.MODIFY, valueType));
    }

    protected ReadMethodsForSchema getReadMethodsForSchema() {
        if (this.sRMethods == null) {
            this.sRMethods = new ReadMethodsForSchema();
        }
        return this.sRMethods;
    }

    protected WriteMethodsForSchema getWriteMethodsForSchema() {
        if (this.sWMethods == null) {
            this.sWMethods = new WriteMethodsForSchema();
        }
        return this.sWMethods;
    }

    public Collection<Surrogate> getSchemaSurrogates(String pattern) throws T2DBException {
        return this.getReadMethodsForSchema().getSchemaSurrogateList((Database)this, pattern);
    }

    public UpdatableSchema getUpdatableSchema(Surrogate surrogate) throws T2DBException {
        UpdatableSchema schema = this.getReadMethodsForSchema().getSchema(surrogate);
        if (schema == null) {
            throw T2DBJMsg.exception("J30109", surrogate.toString());
        }
        return schema;
    }

    public void create(UpdatableSchema schema) throws T2DBException {
        UpdatableSchema base = schema.getBase();
        this.getWriteMethodsForSchema().createSchema((UpdatableSchemaImpl)schema, (Schema)base);
        this.publish((UpdateEvent)new UpdateEventImpl(UpdateEventOperation.CREATE, (DBObject)schema));
    }

    public void create(UpdatableSchema schema, int seriesNr, String description, AttributeDefinition<?> def) throws T2DBException {
        this.getWriteMethodsForSchema().createSchemaComponent((UpdatableSchema)((UpdatableSchemaImpl)schema), seriesNr, description, def);
    }

    public boolean update(UpdatableSchema schema, UpdatableSchema base, String name) throws T2DBException {
        return this.getWriteMethodsForSchema().updateSchema((UpdatableSchema)((UpdatableSchemaImpl)schema), base, name);
    }

    public void update(UpdatableSchema schema, int seriesNr, String description, AttributeDefinition<?> def) throws T2DBException {
        this.getWriteMethodsForSchema().updateSchemaComponent(schema, seriesNr, description, def);
    }

    public void deleteAttributeInSchema(UpdatableSchema schema, int seriesNr, int attribNr) throws T2DBException {
        this.getWriteMethodsForSchema().deleteSchemaComponent(schema, seriesNr, attribNr);
    }

    public void deleteSeriesInSchema(UpdatableSchema schema, int seriesNr) throws T2DBException {
        this.getWriteMethodsForSchema().deleteSchemaComponents(schema, seriesNr);
    }

    public void deleteSchema(UpdatableSchema schema) throws T2DBException {
        this.getWriteMethodsForSchema().deleteSchema((UpdatableSchemaImpl)schema, this.getSchemaUpdatePolicy());
        String comment = schema.getName();
        this.publish(new UpdateEventImpl(UpdateEventOperation.DELETE, (DBObject)schema).withComment(comment));
    }

    public Collection<Surrogate> findChronicles(Collection<UpdatableSchema> schemas) throws T2DBException {
        return this.getWriteMethodsForSchema().findChronicles(schemas);
    }

    public Collection<Surrogate> findChronicles(Property<?> property, Collection<UpdatableSchema> schemas) throws T2DBException {
        return this.getWriteMethodsForSchema().findChronicles(property, schemas);
    }

    public Collection<Surrogate> findChronicles(SeriesDefinition ss, Collection<UpdatableSchema> schemas) throws T2DBException {
        return this.getWriteMethodsForSchema().findChronicles(ss, schemas);
    }

    public String toString() {
        return this.getJDBCSession().toString();
    }
}

