/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collections;

import androidx.annotation.NonNull;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.acra.collections.ImmutableList;
import org.acra.collections.ImmutableSet;

public final class ImmutableMap<K, V>
implements Map<K, V>,
Serializable {
    private final Map<K, V> mMap;

    public ImmutableMap(@NonNull Map<K, V> map) {
        this.mMap = new HashMap<K, V>(map);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.mMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.mMap.containsValue(value);
    }

    @Override
    @NonNull
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> original = this.mMap.entrySet();
        ImmutableSet.Builder<ImmutableEntryWrapper<K, V>> builder = new ImmutableSet.Builder<ImmutableEntryWrapper<K, V>>();
        for (Map.Entry<K, V> entry : original) {
            builder.add(new ImmutableEntryWrapper<K, V>(entry));
        }
        return builder.build();
    }

    @Override
    public V get(Object key) {
        return this.mMap.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.mMap.isEmpty();
    }

    @Override
    @NonNull
    public Set<K> keySet() {
        return new ImmutableSet<K>(this.mMap.keySet());
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(@NonNull Map<? extends K, ? extends V> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.mMap.size();
    }

    @Override
    @NonNull
    public Collection<V> values() {
        return new ImmutableList<V>(this.mMap.values());
    }

    private static class ImmutableEntryWrapper<K, V>
    implements Map.Entry<K, V> {
        private final Map.Entry<K, V> mEntry;

        ImmutableEntryWrapper(Map.Entry<K, V> mEntry) {
            this.mEntry = mEntry;
        }

        @Override
        public K getKey() {
            return this.mEntry.getKey();
        }

        @Override
        public V getValue() {
            return this.mEntry.getValue();
        }

        @Override
        @NonNull
        public V setValue(Object object) {
            throw new UnsupportedOperationException();
        }
    }
}

