/*
 * Decompiled with CFR 0.152.
 */
package org.acra.config;

import java.lang.reflect.Modifier;
import org.acra.config.ACRAConfigurationException;

public final class ClassValidator {
    private ClassValidator() {
    }

    public static void check(Class<?> ... classes) throws ACRAConfigurationException {
        for (Class<?> clazz : classes) {
            if (clazz.isInterface()) {
                throw new ACRAConfigurationException("Expected class, but found interface " + clazz.getName() + ".");
            }
            if (Modifier.isAbstract(clazz.getModifiers())) {
                throw new ACRAConfigurationException("Class " + clazz.getName() + " cannot be abstract.");
            }
            if (clazz.getEnclosingClass() != null && !Modifier.isStatic(clazz.getModifiers())) {
                throw new ACRAConfigurationException("Class " + clazz.getName() + " has to be static.");
            }
            try {
                clazz.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new ACRAConfigurationException("Class " + clazz.getName() + " is missing a no-args Constructor.", e);
            }
        }
    }
}

