/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collections;

import android.support.annotation.NonNull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.acra.collections.UnmodifiableIteratorWrapper;
import org.acra.collections.UnmodifiableListIteratorWrapper;

public final class ImmutableList<E>
implements List<E>,
Serializable {
    private final List<E> mList;

    @SafeVarargs
    public ImmutableList(E ... elements) {
        this(Arrays.asList(elements));
    }

    public ImmutableList(Collection<E> collection) {
        this.mList = new ArrayList<E>(collection);
    }

    @Override
    public void add(int location, E object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(E object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int location, @NonNull Collection<? extends E> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(@NonNull Collection<? extends E> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object object) {
        return this.mList.contains(object);
    }

    @Override
    public boolean containsAll(@NonNull Collection<?> collection) {
        return this.mList.containsAll(collection);
    }

    @Override
    public E get(int location) {
        return this.mList.get(location);
    }

    @Override
    public int indexOf(Object object) {
        return this.mList.indexOf(object);
    }

    @Override
    public boolean isEmpty() {
        return this.mList.isEmpty();
    }

    @Override
    @NonNull
    public Iterator<E> iterator() {
        return new UnmodifiableIteratorWrapper<E>(this.mList.iterator());
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.mList.lastIndexOf(object);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new UnmodifiableListIteratorWrapper<E>(this.mList.listIterator());
    }

    @Override
    @NonNull
    public ListIterator<E> listIterator(int location) {
        return new UnmodifiableListIteratorWrapper<E>(this.mList.listIterator(location));
    }

    @Override
    public E remove(int location) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(@NonNull Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(@NonNull Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E set(int location, E object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.mList.size();
    }

    @Override
    @NonNull
    public List<E> subList(int start, int end) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NonNull
    public Object[] toArray() {
        return this.mList.toArray();
    }

    @Override
    @NonNull
    public <T> T[] toArray(@NonNull T[] array) {
        return this.mList.toArray(array);
    }
}

