/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collections;

import android.support.annotation.NonNull;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.acra.collections.UnmodifiableIteratorWrapper;

public final class ImmutableSet<E>
implements Set<E>,
Serializable {
    private static final ImmutableSet<Object> EMPTY = new ImmutableSet();
    private final Set<E> mSet;

    public static <T> ImmutableSet<T> empty() {
        return EMPTY;
    }

    private ImmutableSet() {
        this.mSet = Collections.emptySet();
    }

    @SafeVarargs
    public ImmutableSet(E ... elements) {
        this(Arrays.asList(elements));
    }

    public ImmutableSet(Collection<E> collection) {
        this.mSet = new LinkedHashSet<E>(collection);
    }

    @Override
    public boolean add(E object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(@NonNull Collection<? extends E> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object object) {
        return this.mSet.contains(object);
    }

    @Override
    public boolean containsAll(@NonNull Collection<?> collection) {
        return this.mSet.containsAll(collection);
    }

    @Override
    public boolean isEmpty() {
        return this.mSet.isEmpty();
    }

    @Override
    @NonNull
    public Iterator<E> iterator() {
        return new UnmodifiableIteratorWrapper<E>(this.mSet.iterator());
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(@NonNull Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(@NonNull Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.mSet.size();
    }

    @Override
    @NonNull
    public Object[] toArray() {
        return this.mSet.toArray();
    }

    @Override
    @NonNull
    public <T> T[] toArray(@NonNull T[] array) {
        return this.mSet.toArray(array);
    }

    public static final class Builder<E> {
        private final Set<E> mSet = new LinkedHashSet();

        public void add(E element) {
            this.mSet.add(element);
        }

        public ImmutableSet<E> build() {
            return new ImmutableSet<E>(this.mSet);
        }
    }
}

