/*
 * Decompiled with CFR 0.152.
 */
package ch.acanda.maven.springbanner;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class PrintDirectionInterceptor
extends InputStream {
    private static final int POS_PRINT_DIR = 6;
    private final PushbackInputStream stream;
    private final boolean isFigFont;
    private boolean isHeader = true;
    private int position;

    public PrintDirectionInterceptor(InputStream stream) throws IOException {
        this.stream = new PushbackInputStream(stream, 5);
        byte[] signature = new byte[5];
        int bytesRead = this.stream.read(signature, 0, 5);
        this.stream.unread(signature, 0, bytesRead);
        this.isFigFont = bytesRead == 5 && signature[0] == 102 && signature[1] == 108 && signature[2] == 102 && signature[3] == 50 && signature[4] == 97;
    }

    @Override
    public int read() throws IOException {
        if (!this.isFigFont || !this.isHeader) {
            return this.stream.read();
        }
        int b = this.stream.read();
        if (b == 32) {
            ++this.position;
        } else if (b == 13 || b == 10) {
            this.isHeader = false;
            if (this.position == 5) {
                this.stream.unread(b);
                this.stream.unread(48);
                b = 32;
            }
        }
        return b;
    }
}

