/*
 * Decompiled with CFR 0.152.
 */
package ch.acanda.maven.springbanner;

import ch.acanda.maven.springbanner.Color;
import com.github.lalyos.jfiglet.FigletFont;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class GenerateMojo
extends AbstractMojo {
    public static final String TEXT_DEFAULT_VALUE = "${project.name}";
    public static final String OUTPUT_DIRECTORY_DEFAULT_VALUE = "${project.build.outputDirectory}";
    public static final String FILENAME_DEFAULT_VALUE = "banner.txt";
    public static final String INCLUDE_INFO_DEFAULT_VALUE = "true";
    public static final String COLOR_DEFAULT_VALUE = "default";
    public static final String INFO_DEFAULT_VALUE = "Version: ${application.version:${project.version}}, Server: ${server.address:localhost}:${server.port:8080}, Active Profiles: ${spring.profiles.active:none}";
    @Parameter(defaultValue="${project}")
    private MavenProject project;
    @Parameter(property="banner.text", required=true, defaultValue="${project.name}")
    private String text;
    @Parameter(property="banner.outputDirectory", required=true, defaultValue="${project.build.outputDirectory}")
    private File outputDirectory;
    @Parameter(property="banner.filename", required=true, defaultValue="banner.txt")
    private String filename;
    @Parameter(property="banner.includeInfo", defaultValue="true")
    private boolean includeInfo;
    @Parameter(property="banner.info", defaultValue="Version: ${application.version:${project.version}}, Server: ${server.address:localhost}:${server.port:8080}, Active Profiles: ${spring.profiles.active:none}")
    private String info;
    @Parameter(property="banner.color", defaultValue="default")
    private String color;

    public GenerateMojo() {
    }

    public GenerateMojo(MavenProject project, String text, File outputDirectory, String filename, boolean includeInfo, String info, String color) {
        this.project = project;
        this.text = text;
        this.outputDirectory = outputDirectory;
        this.filename = filename;
        this.includeInfo = includeInfo;
        this.info = info;
        this.color = color == null ? Color.DEFAULT.name() : color;
    }

    public void execute() throws MojoFailureException {
        try {
            this.getLog().info((CharSequence)"Generating Spring Boot banner...");
            String banner = this.generateBanner();
            this.writeBannerFile(banner);
        }
        catch (IOException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }

    private String generateBanner() throws IOException {
        InputStream fontStream = GenerateMojo.class.getResourceAsStream("/condensed.flf");
        String rawBanner = FigletFont.convertOneLine((InputStream)fontStream, (String)this.text);
        String[] lines = rawBanner.split("\n");
        StringBuilder banner = new StringBuilder(32);
        boolean isDefaultColor = Color.DEFAULT.getTagValue().equals(this.color);
        for (int i = 0; i < lines.length; ++i) {
            if (i > 0) {
                banner.append('\n');
            }
            if (!isDefaultColor) {
                Color.nameFromTagValue(this.color).ifPresent(name -> banner.append("${AnsiColor.").append(name).append('}'));
            }
            banner.append(StringUtils.stripEnd((String)lines[i], (String)" "));
        }
        if (!isDefaultColor) {
            banner.append("${AnsiColor.DEFAULT}");
        }
        if (this.includeInfo) {
            this.info = this.info == null ? null : this.info.replaceAll("\\$\\{project\\.version\\}", this.project.getVersion());
            banner.append('\n').append(this.info);
        }
        banner.append('\n');
        this.getLog().debug((CharSequence)('\n' + banner.toString()));
        return banner.toString();
    }

    private void writeBannerFile(String banner) throws IOException {
        Path bannerFile = this.outputDirectory.toPath().resolve(this.filename);
        this.getLog().debug((CharSequence)("Writing banner to file " + bannerFile));
        this.outputDirectory.mkdirs();
        Files.write(bannerFile, banner.getBytes("UTF-8"), new OpenOption[0]);
    }
}

