/*
 * Decompiled with CFR 0.152.
 */
package ch.abertschi.sct.transformer;

import ch.abertschi.sct.node.Node;
import ch.abertschi.sct.transformer.Transformer;
import ch.abertschi.sct.transformer.TransformerContext;
import java.util.List;

public class Transformers {
    public static void transform(Node node, List<Transformer> transformers, TransformerContext context) {
        if (node.isContainer()) {
            node.getChildren().forEach(child -> Transformers.transform(child, transformers, context));
        } else {
            transformers.stream().filter(t -> t.canTransform(context, node.getValue())).forEach(t -> node.setValue(t.transform(context, node.getValue())));
        }
    }

    public static String transform(String input, List<Transformer> transformers, TransformerContext context) {
        for (Transformer transformer : transformers) {
            if (!transformer.canTransform(context, input)) continue;
            input = transformer.transform(context, input);
        }
        return input;
    }
}

