/*
 * Decompiled with CFR 0.152.
 */
package ch.abertschi.sct.parse;

import ch.abertschi.sct.node.NodeUtils;
import ch.abertschi.sct.parse.ParserCall;
import ch.abertschi.sct.parse.ParserContext;
import ch.abertschi.sct.parse.StorageParser;
import ch.abertschi.sct.parse.XStreamProvider;
import ch.abertschi.sct.parse.XmlParser;
import ch.abertschi.sct.serial.Call;
import ch.abertschi.sct.serial.Request;
import ch.abertschi.sct.serial.Response;
import ch.abertschi.sct.serial.Storage;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageWriter {
    private static final Logger LOG = LoggerFactory.getLogger(StorageWriter.class);
    private File target;
    private static final XStream XSTREAM = XStreamProvider.createXStream();
    private ParserContext parserContext;
    private boolean skipDoubles = false;

    public StorageWriter(File target) {
        this.target = target;
    }

    public StorageWriter(File target, boolean skipDoubles) {
        this.target = target;
        this.skipDoubles = true;
    }

    public void dump(Call call) {
        FileOutputStream out;
        try {
            this.createFileIfNotExists(this.target);
            out = new FileOutputStream(this.target, true);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        XSTREAM.marshal((Object)call, (HierarchicalStreamWriter)new XStreamProvider.MyPrettyWriter(new OutputStreamWriter(out)));
        this.logAsXml(call);
    }

    public void write(Call call) {
        ArrayList<Call> calls = new ArrayList<Call>();
        calls.add(call);
        this.write(calls);
    }

    public void write(List<Call> calls) {
        ParserContext context = this.getParserContext();
        StorageParser parser = new StorageParser(context);
        calls.stream().filter(call -> !this.isDoubleAndSkip(parser, (Call)call)).map(call -> this.toParserCall((Call)call)).forEach(call -> context.getCalls().add((ParserCall)call));
        this.persist(this.toStorage(context));
    }

    public Storage toStorage(ParserContext context) {
        List<Call> calls = context.getCalls().stream().map(call -> this.toCall((ParserCall)call)).collect(Collectors.toList());
        return new Storage().setCalls(calls);
    }

    private Call toCall(ParserCall parserCall) {
        Request req = new Request().setPayload(NodeUtils.createObjectWithNode(parserCall.getRequest().getPayloadNode()));
        Response res = new Response().setPayload(NodeUtils.createObjectWithNode(parserCall.getResponse().getPayloadNode())).setScript(parserCall.getResponse().getScript()).setStacktrace(parserCall.getResponse().getStacktrace());
        return new Call().setRequest(req).setResponse(res);
    }

    private ParserContext getParserContext() {
        if (this.parserContext == null) {
            ParserContext context;
            if (!this.target.exists()) {
                context = new ParserContext();
            } else {
                XmlParser parser = new XmlParser();
                context = parser.parse(this.target);
            }
            this.parserContext = context;
        }
        return this.parserContext;
    }

    private void persist(Storage storage) {
        FileOutputStream out = null;
        try {
            this.createFileIfNotExists(this.target);
            out = new FileOutputStream(this.target);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        XSTREAM.marshal((Object)storage, (HierarchicalStreamWriter)new XStreamProvider.MyPrettyWriter(new OutputStreamWriter(out)));
        this.logAsXml(storage);
    }

    private void createFileIfNotExists(File file) {
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private boolean isDoubleAndSkip(StorageParser parser, Call call) {
        return this.skipDoubles && parser.containsObject(call.getRequest().getPayload());
    }

    private ParserCall toParserCall(Call call) {
        return ParserCall.createWithRawObjects(call.getRequest().getPayload(), call.getResponse().getPayload());
    }

    private void logAsXml(Object toLog) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(XSTREAM.toXML(toLog));
        }
    }
}

