/*
 * Decompiled with CFR 0.152.
 */
package ch.abertschi.sct.parse;

import ch.abertschi.sct.node.Node;
import ch.abertschi.sct.node.NodeUtils;
import ch.abertschi.sct.parse.ParserCall;
import ch.abertschi.sct.parse.ParserContext;
import ch.abertschi.sct.parse.ParserRequest;
import ch.abertschi.sct.parse.ParserResponse;
import com.github.underscore.$;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.LinkedList;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.XMLOutputter;

public class XmlParser {
    public ParserContext parse(File file) {
        try {
            byte[] encoded = Files.readAllBytes(Paths.get(file.getAbsolutePath(), new String[0]));
            return this.parse(new String(encoded));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ParserContext parse(String xml) {
        ParserContext context = new ParserContext();
        if ($.isNull((Object)xml)) {
            throw new IllegalArgumentException("Xml cant be null");
        }
        if (!xml.trim().isEmpty()) {
            Document document = NodeUtils.xmlToDocument(xml);
            Element rootElement = document.getRootElement();
            LinkedList<ParserCall> storageCalls = new LinkedList<ParserCall>();
            Element calls = rootElement.getChild("calls");
            if (!$.isNull((Object)calls)) {
                calls.getChildren("call").stream().map(callElement -> new ParserCall().setRequest(this.parseRequest((Element)callElement)).setResponse(this.parseResponse((Element)callElement))).forEach(call -> storageCalls.add((ParserCall)call));
            }
            context.setCalls(storageCalls);
        }
        return context;
    }

    private ParserRequest parseRequest(Element element) {
        XMLOutputter output = new XMLOutputter();
        Element request = element.getChild("request");
        Element payload = request.getChild("payload");
        Node payloadNode = null;
        if (!$.isNull((Object)payload)) {
            payloadNode = NodeUtils.parseDomToNode(payload);
            payloadNode.setClassType(payload.getAttributeValue("class"));
        }
        return new ParserRequest().setPayloadRaw(output.outputString(payload)).setPayloadNode(payloadNode);
    }

    private ParserResponse parseResponse(Element element) {
        XMLOutputter output = new XMLOutputter();
        Element response = element.getChild("response");
        Element payload = response.getChild("payload");
        Element stacktrace = response.getChild("stacktrace");
        Element script = response.getChild("script");
        Node payloadNode = null;
        if (!$.isNull((Object)payload)) {
            payloadNode = NodeUtils.parseDomToNode(payload);
            String typeValue = payload.getAttributeValue("class");
            payloadNode.setClassType(typeValue);
        }
        String stacktraceValue = $.isNull((Object)stacktrace) ? null : stacktrace.getText();
        String scriptValue = $.isNull((Object)script) ? null : script.getText();
        String payloadRaw = $.isNull((Object)payload) ? null : output.outputString(payload);
        return new ParserResponse().setPayloadRaw(payloadRaw).setScript(scriptValue).setStacktrace(stacktraceValue).setPayloadNode(payloadNode);
    }
}

