/*
 * Decompiled with CFR 0.152.
 */
package ch.abertschi.sct.parse;

import ch.abertschi.sct.node.NodeUtils;
import ch.abertschi.sct.parse.ParserCall;
import ch.abertschi.sct.parse.ParserContext;
import ch.abertschi.sct.parse.ParserResponse;
import ch.abertschi.sct.transformer.Transformer;
import ch.abertschi.sct.transformer.TransformerContext;
import ch.abertschi.sct.transformer.Transformers;
import ch.abertschi.unserialize.StackTraceUnserialize;
import com.github.underscore.$;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.util.List;

public class ResponseExecutor {
    private ParserContext parserContext;
    private List<Transformer> responseTransformers;

    public ResponseExecutor(ParserContext parserContext, List<Transformer> responseTransformers) {
        this.parserContext = parserContext;
        this.responseTransformers = responseTransformers;
    }

    public Object execute(ParserCall call, Object currentRequest) throws Throwable {
        Object execute;
        TransformerContext transformerContext = new TransformerContext().setParserContext(this.parserContext).setCall(call).setCurrentRequest(currentRequest);
        Throwable exception = this.createResponseStackTrace(call, transformerContext);
        Object payload = this.createResponsePayload(call, transformerContext);
        if (this.isScript(call)) {
            GroovyShell shell = this.createResponseScript(exception, payload, currentRequest);
            execute = shell.evaluate(call.getResponse().getScript());
        } else {
            if (this.isStackTrace(call)) {
                throw exception;
            }
            if (this.isPayload(call)) {
                execute = payload;
            } else {
                throw new RuntimeException("Invalid response configuration. Neither a script, nor stacktrace nor payload was set.");
            }
        }
        return execute;
    }

    private Throwable createResponseStackTrace(ParserCall call, TransformerContext transformerContext) {
        ParserResponse response = call.getResponse();
        Throwable exception = null;
        if (this.isStackTrace(call)) {
            String stacktrace = Transformers.transform(response.getStacktrace(), this.responseTransformers, transformerContext);
            response.setStacktrace(stacktrace);
            exception = StackTraceUnserialize.unserialize((String)stacktrace);
        }
        return exception;
    }

    private Object createResponsePayload(ParserCall call, TransformerContext transformerContext) {
        Object payload = null;
        ParserResponse response = call.getResponse();
        if (this.isPayload(call)) {
            Transformers.transform(response.getPayloadNode(), this.responseTransformers, transformerContext);
            payload = NodeUtils.createObjectWithNode(response.getPayloadNode());
        }
        return payload;
    }

    private GroovyShell createResponseScript(Throwable exception, Object payload, Object request) {
        Binding binding = new Binding();
        binding.setVariable("env", System.getenv());
        binding.setVariable("system", (Object)System.getProperties());
        binding.setVariable("request", request);
        binding.setVariable("stacktrace", (Object)exception);
        binding.setVariable("response", payload);
        return new GroovyShell(binding);
    }

    private boolean isScript(ParserCall call) {
        ParserResponse r = call.getResponse();
        return !$.isNull((Object)r.getScript()) && !r.getScript().trim().isEmpty();
    }

    private boolean isStackTrace(ParserCall call) {
        ParserResponse r = call.getResponse();
        return !$.isNull((Object)r.getStacktrace()) && !r.getStacktrace().trim().isEmpty();
    }

    private boolean isPayload(ParserCall call) {
        ParserResponse r = call.getResponse();
        return !$.isNull((Object)r.getPayloadNode());
    }
}

