/*
 * Decompiled with CFR 0.152.
 */
package ch.abertschi.sct.parse;

import ch.abertschi.sct.serial.Call;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.core.util.QuickWriter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import java.io.Writer;

public class XStreamProvider {
    public static XStream createXStream() {
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver(){

            public HierarchicalStreamWriter createWriter(Writer out) {
                return new MyPrettyWriter(out);
            }
        });
        XStreamProvider.applyDefaultConfig(xstream);
        XStreamProvider.registerAliases(xstream);
        return xstream;
    }

    private static void registerAliases(XStream xstream) {
        xstream.alias("call", Call.class);
    }

    private static void applyDefaultConfig(XStream xstream) {
        xstream.autodetectAnnotations(true);
        xstream.setClassLoader(Thread.currentThread().getContextClassLoader());
    }

    public static class MyPrettyWriter
    extends PrettyPrintWriter {
        public MyPrettyWriter(Writer writer) {
            super(writer);
        }

        protected void writeText(QuickWriter writer, String text) {
            if (text.indexOf(60) < 0) {
                writer.write(text);
            } else {
                writer.write("<![CDATA[");
                writer.write(text);
                writer.write("]]>");
            }
        }
    }
}

