/*
 * Decompiled with CFR 0.152.
 */
package ch.abertschi.sct;

import ch.abertschi.sct.FileStorageCollection;
import ch.abertschi.sct.api.Configuration;
import ch.abertschi.sct.api.Interceptor;
import ch.abertschi.sct.api.SctException;
import ch.abertschi.sct.api.invocation.InvocationContext;
import ch.abertschi.sct.util.ResultNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceCallTracker
implements Interceptor {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceCallTracker.class);
    private static final String CONFIG_SKIP = "sct.skip";
    private static final String CONFIG_SKIP_RECORDING = "sct.record.skip";
    private static final String CONFIG_SKIP_REPLAYING = "sct.replay.skip";
    private Configuration config;
    private FileStorageCollection storageCollection;

    public ServiceCallTracker(Configuration config) {
        if (config.isReplayingEnabled() || config.isRecordingEnabled()) {
            this.storageCollection = new FileStorageCollection(config);
        }
        this.config = config;
    }

    public Object invoke(InvocationContext ctx) {
        Object response;
        Object request = this.getInCorrectDimension(ctx.getParameters());
        if (this.isRecording() || this.isReplaying()) {
            if (this.isRecording() && this.isReplaying()) {
                LOG.info("recording and replaying call of {}", (Object)this.getTargetName(ctx));
                response = this.performRecordingAndReplaying(request, ctx);
            } else if (this.isReplaying()) {
                LOG.info("replaying call of {}", (Object)this.getTargetName(ctx));
                response = this.performReplaying(request, ctx, this.config.isThrowExceptionOnNotFound());
            } else {
                LOG.info("recording call of {}", (Object)this.getTargetName(ctx));
                response = this.performRecording(request, ctx);
            }
            if (!this.doesReturnTypeMatch(ctx, response)) {
                String msg = String.format("Stored response does not match with method signature %sThe method return type was changed.", this.getTargetName(ctx));
                LOG.error(msg);
                if (this.config.isThrowExceptionOnIncompatibleReturnType()) {
                    throw new SctException(msg, null);
                }
                response = this.proceed(ctx);
            }
        } else {
            response = this.proceed(ctx);
        }
        return response;
    }

    private boolean doesReturnTypeMatch(InvocationContext ctx, Object response) {
        return response == null || ctx.getMethod().getReturnType().isAssignableFrom(response.getClass());
    }

    private Object performRecordingAndReplaying(Object request, InvocationContext ctx) {
        Object response;
        try {
            response = this.performReplaying(request, ctx, true);
        }
        catch (ResultNotFoundException e) {
            response = this.proceed(ctx);
            this.storageCollection.add(request, response, ctx);
        }
        return response;
    }

    private Object performReplaying(Object request, InvocationContext ctx, boolean throwExceptionOnNotFound) {
        Object response;
        try {
            response = this.storageCollection.get(request, ctx);
        }
        catch (ResultNotFoundException e) {
            if (throwExceptionOnNotFound) {
                throw e;
            }
            response = this.proceed(ctx);
        }
        return response;
    }

    private Object performRecording(Object request, InvocationContext ctx) {
        Object response = this.proceed(ctx);
        this.storageCollection.add(request, response, ctx);
        return response;
    }

    private Object proceed(InvocationContext ctx) {
        try {
            return ctx.proceed();
        }
        catch (Exception e) {
            throw new SctException(e);
        }
    }

    private Object getInCorrectDimension(Object[] parameters) {
        Object result = null;
        if (parameters != null) {
            result = parameters.length > 1 ? parameters : parameters[0];
        }
        return result;
    }

    private boolean isSystemPropertyBooleanSet(String key) {
        String value = System.getProperty(key);
        boolean hasValue = value != null && !value.isEmpty();
        return hasValue && "true".equals(value.toLowerCase());
    }

    private String getTargetName(InvocationContext invocation) {
        String target = invocation.getMethod().getDeclaringClass().getName();
        String method = invocation.getMethod().getName();
        return String.format("%s.%s(...)", target, method);
    }

    private boolean isSkip() {
        return this.isSystemPropertyBooleanSet(CONFIG_SKIP);
    }

    private boolean isSkipRecording() {
        return this.isSkip() || this.isSystemPropertyBooleanSet(CONFIG_SKIP_RECORDING);
    }

    private boolean isSkipReplaying() {
        return this.isSkip() || this.isSystemPropertyBooleanSet(CONFIG_SKIP_REPLAYING);
    }

    private boolean isRecording() {
        return !this.isSkipRecording() && this.config.isRecordingEnabled();
    }

    private boolean isReplaying() {
        return !this.isSkipReplaying() && this.config.isReplayingEnabled();
    }
}

