/*
 * Decompiled with CFR 0.152.
 */
package ch.abertschi.sct;

import ch.abertschi.sct.api.Configuration;
import ch.abertschi.sct.api.invocation.InvocationContext;
import ch.abertschi.sct.parse.StorageParser;
import ch.abertschi.sct.parse.StorageWriter;
import ch.abertschi.sct.serial.Call;
import ch.abertschi.sct.serial.Request;
import ch.abertschi.sct.serial.Response;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class FileStorageCollection {
    private static final String DEFAULT = "DEFAULT_IMPL";
    private Map<String, StorageParser> parserMap = new HashMap<String, StorageParser>();
    private Map<String, StorageWriter> writerMap = new HashMap<String, StorageWriter>();
    private Configuration config;

    public FileStorageCollection(Configuration config) {
        this.config = config;
    }

    public Object get(Object request, InvocationContext invocation) {
        StorageParser parser;
        if (Configuration.INPUT_SOURCE.SINGLE_FILE == this.config.getReplayingSourceType()) {
            parser = this.parserMap.get(DEFAULT);
            if (parser == null) {
                parser = new StorageParser(this.config.getReplayingSource());
                this.parserMap.put(DEFAULT, parser);
            }
        } else {
            String key = this.createKey(invocation);
            parser = this.parserMap.get(key);
            if (parser == null) {
                this.createDirectory(this.config.getReplayingSource());
                File replaying = new File(this.config.getReplayingSource(), key);
                parser = new StorageParser(replaying);
                this.parserMap.put(key, parser);
            }
        }
        return parser.get(request);
    }

    public void add(Object request, Object response, InvocationContext invocation) {
        StorageWriter writer;
        if (this.config.getRecordingSourceType() == Configuration.INPUT_SOURCE.SINGLE_FILE) {
            writer = this.writerMap.get(DEFAULT);
            if (writer == null) {
                writer = new StorageWriter(this.config.getRecordingSource());
                this.writerMap.put(DEFAULT, writer);
            }
        } else {
            String key = this.createKey(invocation);
            writer = this.writerMap.get(key);
            if (writer == null) {
                this.createDirectory(this.config.getRecordingSource());
                File recording = new File(this.config.getRecordingSource(), key);
                writer = new StorageWriter(recording);
                this.writerMap.put(key, writer);
            }
        }
        Call call = new Call().setRequest(new Request().setPayload(request)).setResponse(new Response().setPayload(response));
        if (this.config.getRecordingMode() == Configuration.RECORDING_MODE.DUMP_CALLS) {
            writer.dump(call);
        } else {
            writer.write(call);
        }
    }

    private void createDirectory(File file) {
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    private String createKey(InvocationContext invocation) {
        String target = invocation.getMethod().getDeclaringClass().getCanonicalName().toLowerCase();
        String method = invocation.getMethod().getName().toLowerCase();
        return String.format("%s.%s.xml", target, method);
    }
}

