/*
 * Decompiled with CFR 0.152.
 */
package ch.abertschi.sct.util;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.StreamException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Serializer {
    private static final Logger LOG = LoggerFactory.getLogger(Serializer.class);
    private XStream xstream;

    public Serializer(XStream xstream) {
        this.xstream = xstream;
    }

    public <T> T unmarshal(File where) {
        Object object = null;
        try {
            object = this.xstream.fromXML(where);
        }
        catch (StreamException e) {
            throw new RuntimeException(e);
        }
        return (T)object;
    }

    public <T> void marshal(T object, File where) {
        FileOutputStream writer = null;
        try {
            writer = new FileOutputStream(where, false);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(String.format("File %s not found", where), e);
        }
        try {
            this.xstream.toXML(object, (OutputStream)writer);
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

