/*
 * Decompiled with CFR 0.152.
 */
package ch.abertschi.sct.transformer;

import ch.abertschi.sct.transformer.Transformer;
import ch.abertschi.sct.transformer.TransformerContext;
import de.odysseus.el.ExpressionFactoryImpl;
import de.odysseus.el.util.SimpleContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.PropertyNotFoundException;
import javax.el.ValueExpression;

public class VariableTransformer
implements Transformer {
    private static final Pattern PATTERN_IS_EXPRESSION = Pattern.compile("[#|\\{]([^}]*)}");
    private SimpleContext elContext;
    private ExpressionFactory factory;

    public VariableTransformer() {
        this.createElContext();
    }

    protected void createElContext() {
        this.factory = new ExpressionFactoryImpl();
        this.elContext = new SimpleContext();
        this.elContext.setVariable("env", this.factory.createValueExpression(System.getenv(), Map.class));
        this.elContext.setVariable("system", this.factory.createValueExpression((Object)System.getProperties(), Properties.class));
        this.elContext.setVariable("regex", this.factory.createValueExpression(this.getRegex(), Map.class));
    }

    protected Map<String, String> getRegex() {
        HashMap<String, String> regex = new HashMap<String, String>();
        regex.put("any", ".*");
        regex.put("numeric", "[0-9]*");
        return regex;
    }

    @Override
    public boolean canTransform(TransformerContext context, String input) {
        return PATTERN_IS_EXPRESSION.matcher(input).find();
    }

    @Override
    public String transform(TransformerContext context, String input) {
        String transformed;
        ValueExpression expression = this.factory.createValueExpression((ELContext)this.elContext, input, String.class);
        try {
            transformed = (String)expression.getValue((ELContext)this.elContext);
        }
        catch (PropertyNotFoundException e) {
            transformed = input;
        }
        return transformed;
    }
}

