/*
 * Decompiled with CFR 0.152.
 */
package ch.abertschi.sct.parse;

import ch.abertschi.sct.node.Node;
import ch.abertschi.sct.node.NodeUtils;
import ch.abertschi.sct.parse.ParserCall;
import ch.abertschi.sct.parse.ParserContext;
import ch.abertschi.sct.parse.ResponseExecutor;
import ch.abertschi.sct.parse.XmlParser;
import ch.abertschi.sct.transformer.FieldReferenceTransformer;
import ch.abertschi.sct.transformer.Transformer;
import ch.abertschi.sct.transformer.TransformerContext;
import ch.abertschi.sct.transformer.Transformers;
import ch.abertschi.sct.transformer.VariableTransformer;
import ch.abertschi.sct.util.ExceptionUtil;
import ch.abertschi.sct.util.ResultNotFoundException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class StorageParser {
    private ParserContext parserContext;
    private List<Transformer> requestAndResponseTransformers;
    private ResponseExecutor responseExecutor;

    public StorageParser(File source) {
        this.createFileIfNotExists(source);
        this.parserContext = new XmlParser().parse(source);
        this.init();
    }

    public StorageParser(InputStream source) {
        this(StorageParser.convertStreamToString(source));
    }

    public StorageParser(String source) {
        this.parserContext = new XmlParser().parse(source);
        this.init();
    }

    public StorageParser(ParserContext context) {
        this.parserContext = context;
        this.init();
    }

    private void init() {
        this.requestAndResponseTransformers = this.getRequestAndResponseTransformers();
        this.responseExecutor = new ResponseExecutor(this.parserContext, this.requestAndResponseTransformers);
    }

    public Object get(Object request) {
        Object response = null;
        ParserCall call = this.findCall(request);
        if (call != null) {
            try {
                response = this.executeResponse(call, request);
            }
            catch (Throwable throwable) {
                ExceptionUtil.throwException(throwable);
            }
        } else {
            throw new ResultNotFoundException();
        }
        return response;
    }

    public boolean containsObject(Object request) {
        return this.findCall(request) != null;
    }

    protected ParserCall findCall(Object currentRequest) {
        ParserCall found = null;
        TransformerContext context = new TransformerContext().setCurrentRequest(currentRequest);
        for (ParserCall call : this.parserContext.getCalls()) {
            context.setCall(call);
            Node node = call.getRequest().getPayloadNode();
            Transformers.transform(node, this.requestAndResponseTransformers, context);
            if (!NodeUtils.doesNodeMatchWithObject(node, context.getCurrentRequest())) continue;
            found = call;
            break;
        }
        return found;
    }

    protected Object executeResponse(ParserCall call, Object currentRequest) throws Throwable {
        return this.responseExecutor.execute(call, currentRequest);
    }

    protected List<Transformer> getRequestAndResponseTransformers() {
        ArrayList<Transformer> transformers = new ArrayList<Transformer>();
        transformers.add(new VariableTransformer());
        transformers.add(new FieldReferenceTransformer());
        return transformers;
    }

    private void createFileIfNotExists(File file) {
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static String convertStreamToString(InputStream is) {
        if (is == null) {
            return "";
        }
        Scanner s = new Scanner(is, "UTF-8").useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }
}

