/*
 * Decompiled with CFR 0.152.
 */
package ch.abertschi.sct.node;

import ch.abertschi.sct.node.Node;
import ch.abertschi.sct.parse.XStreamProvider;
import com.github.underscore.$;
import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class NodeUtils {
    private static final XStream XSTREAM = XStreamProvider.GET.createPreConfiguredXStream();

    private NodeUtils() {
    }

    public static Node createNodeFromObject(Object object) {
        Document document = NodeUtils.xmlToDocument(NodeUtils.toRawXml(object));
        Element rootElement = document.getRootElement();
        return NodeUtils.parseDomToNode(rootElement);
    }

    public static String toRawXml(Object object) {
        return XSTREAM.toXML(object);
    }

    public static boolean doesNodeMatchWithObject(Node node, Object object) {
        Node otherNode = NodeUtils.createNodeFromObject(object);
        return node.doesMatchWith(otherNode, true);
    }

    public static boolean doesNodeMatchWithObject(Node node, Object object, boolean ignoreMissingFieldsInNode) {
        Node otherNode = NodeUtils.createNodeFromObject(object);
        return node.doesMatchWith(otherNode, true);
    }

    public static Node parseDomToNode(Element element) {
        return NodeUtils.parseDomToNode(element, null);
    }

    private static Node parseDomToNode(Element element, Node parent) {
        Node node = new Node();
        node.setName(element.getName());
        if (!$.isNull((Object)parent)) {
            parent.getChildren().add(node);
        }
        LinkedList<Node> nodeChildren = new LinkedList<Node>();
        List children = element.getChildren();
        if ($.isEmpty((Iterable)children)) {
            node.setIsContainer(false);
            node.setValue(element.getValue());
        } else {
            node.setIsContainer(true);
            for (Element child : children) {
                nodeChildren.add(NodeUtils.parseDomToNode(child, node));
            }
        }
        node.setChildren(nodeChildren);
        return node;
    }

    public static Object createObjectWithNode(Node node) {
        String xml = node.toXml();
        return XSTREAM.fromXML(xml);
    }

    public static Node findNodeInTree(String key, Node rootNode) {
        return NodeUtils.findNodeInTree(key, rootNode, null);
    }

    public static Document xmlToDocument(String xml) {
        SAXBuilder builder = new SAXBuilder();
        Document document = null;
        try {
            document = builder.build((Reader)new StringReader(xml));
        }
        catch (JDOMException e) {
            throw new RuntimeException("Cant parse xml", e);
        }
        catch (IOException e) {
            throw new RuntimeException("IO Problems with xml", e);
        }
        return document;
    }

    protected static Node findNodeInTree(String key, Node node, LinkedList<Node> history) {
        Node found = null;
        if ($.isNull(history)) {
            history = new LinkedList();
        }
        history.add(node);
        String historyKey = NodeUtils.generateKey(history);
        if (key.equals(historyKey)) {
            found = node;
        } else if (key.contains(historyKey)) {
            if (!$.isEmpty(node.getChildren())) {
                Node child;
                Iterator<Node> iterator = node.getChildren().iterator();
                while (iterator.hasNext() && $.isNull((Object)(found = NodeUtils.findNodeInTree(key, child = iterator.next(), history)))) {
                }
            }
        } else {
            history.removeLast();
        }
        return found;
    }

    private static String generateKey(LinkedList<Node> history) {
        StringBuffer keyBuffer = new StringBuffer();
        history.forEach(node -> keyBuffer.append("." + node.getName()));
        String key = keyBuffer.toString();
        return key.length() > 0 ? key.substring(1) : null;
    }
}

