/*
 * Decompiled with CFR 0.152.
 */
package ch.abertschi.sct.node;

import com.github.underscore.$;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Node {
    private String name;
    private String value;
    private String classType;
    private boolean isContainer;
    private List<Node> children = new LinkedList<Node>();

    public boolean doesMatchWith(Node other) {
        return this.doesMatchWith(other, false);
    }

    public boolean doesMatchWith(Node other, boolean ignoreRootNames) {
        boolean success = true;
        System.out.println(String.format("comparing %s (%s) with other %s (%s)", this.getName(), this.getValue(), other.getName(), other.getValue()));
        if (this.name.equals(other.name) || ignoreRootNames) {
            if (this.isContainer && other.isContainer) {
                for (Node child : this.children) {
                    boolean matchChild = false;
                    for (Node otherChild : other.getChildren()) {
                        System.out.println(String.format("iterating through children %s (%s) with other %s (%s)", child.getName(), child.getValue(), otherChild.getName(), otherChild.getValue()));
                        if (!child.doesMatchWith(otherChild)) continue;
                        System.out.println("match TRUE " + child.getName() + " " + child.getValue() + " " + otherChild.getName() + " " + otherChild.getValue());
                        matchChild = true;
                        break;
                    }
                    if (matchChild) continue;
                    System.out.println("nothing machted " + child.getName() + child.getValue());
                    success = false;
                    return false;
                }
            } else {
                success = other.isContainer ? !$.isNull((Object)this.value) && other.toXml().matches(this.value) : !$.isNull((Object)other.getValue()) && !$.isNull((Object)this.value) && other.getValue().matches(this.value);
            }
        } else {
            success = false;
        }
        System.out.println(String.format("comparing %s (%s) with other %s (%s): %s", this.getName(), this.getValue(), other.getName(), other.getValue(), success ? "true" : "false"));
        return success;
    }

    public String toXml() {
        return this.toXml(null);
    }

    public String toXml(Map<String, String> attributes) {
        if ($.isNull(attributes)) {
            attributes = new HashMap<String, String>();
        }
        if (!$.isNull((Object)this.classType) && !this.classType.isEmpty()) {
            attributes.put("class", this.classType);
        }
        StringBuilder attributeBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            attributeBuilder.append(String.format(" %s=\"%s\"", entry.getKey(), entry.getValue()));
        }
        StringBuilder childrenXml = new StringBuilder();
        if (!$.isEmpty(this.children)) {
            for (Node child : this.children) {
                childrenXml.append(child.toXml());
            }
        } else {
            childrenXml.append(this.value);
        }
        return String.format("<%s%s>%s</%s>", this.name, attributeBuilder.toString(), childrenXml.toString(), this.name);
    }

    public List<Node> getChildren() {
        return this.children;
    }

    public Node setChildren(List<Node> children) {
        this.children = children;
        return this;
    }

    public boolean isContainer() {
        return this.isContainer;
    }

    public Node setIsContainer(boolean isContainer) {
        this.isContainer = isContainer;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Node setName(String name) {
        this.name = name;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public Node setValue(String value) {
        this.value = value;
        return this;
    }

    public String getClassType() {
        return this.classType;
    }

    public Node setClassType(String classType) {
        this.classType = classType;
        return this;
    }
}

