package ch.abertschi.sct.node;

import com.github.underscore.$;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

/**
 * Created by abertschi on 11/05/16.
 */
public class Node
{
    private String name;
    private String value;
    private String classType;

    private boolean isContainer;
    private List<Node> children = new LinkedList<>();

    public Node()
    {
    }


    public boolean doesMatchWith(Node other)
    {
        return doesMatchWith(other, false);
    }

    public boolean doesMatchWith(Node other, boolean ignoreRootNames)
    {
        // matching strategy:
        // this: node from storage
        // other: request object
        //
        // if this object contains different values than other, objects do not match
        // TODO: if other object contains fields not set in this, objects do match - Feature ?
        boolean success = true;

        if (this.name.equals(other.name) || ignoreRootNames) // outer names are not compatible
        {
            if (this.isContainer && other.isContainer)
            {
                for (Node child : children)
                {
                    boolean childDoesMatch = false;
                    for (Node otherChild : other.getChildren())
                    {
                        boolean c = child.doesMatchWith(otherChild);
                        System.out.println(String.format("%s with %s: %s", child.getValue(), otherChild.getValue(), c ? "match" : "not"));
                        if (c)
                        {
                            childDoesMatch = true;
                            break;
                        }
                    }
                    if (!childDoesMatch) {
                        success = false;
                        break;
                    }
                }
            }
            else if (other.isContainer)
            {
                // regex
                success = !$.isNull(this.value) && other.toXml().matches(this.value);
            }
            else
            {
                // compare values
                success = !$.isNull(other.getValue()) && !$.isNull(this.value)
                        && other.getValue().matches(this.value);
            }
        }
        else {
            success = false;
        }
        return success ;
    }

    public String toXml()
    {
        return toXml(null);
    }

    public String toXml(Map<String, String> attributes)
    {
        if ($.isNull(attributes))
        {
            attributes = new HashMap<>();
        }
        if (!$.isNull(classType) && !classType.isEmpty())
        {
            attributes.put("class", classType);
        }
        StringBuilder attributeBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : attributes.entrySet())
        {
            attributeBuilder.append(String.format(" %s=\"%s\"", entry.getKey(), entry.getValue()));
        }
        StringBuilder childrenXml = new StringBuilder();
        if (!$.isEmpty(children))
        {
            for (Node child : children)
            {
                childrenXml.append(child.toXml());
            }
        }
        else
        {
            childrenXml.append(this.value);
        }
        return String.format("<%s%s>%s</%s>", name, attributeBuilder.toString(), childrenXml.toString(), name);
    }

    public List<Node> getChildren()
    {
        return children;
    }

    public Node setChildren(List<Node> children)
    {
        this.children = children;
        return this;
    }

    public boolean isContainer()
    {
        return isContainer;
    }

    public Node setIsContainer(boolean isContainer)
    {
        this.isContainer = isContainer;
        return this;
    }

    public String getName()
    {
        return name;
    }

    public Node setName(String name)
    {
        this.name = name;
        return this;
    }


    public String getValue()
    {
        return value;
    }

    public Node setValue(String value)
    {
        this.value = value;
        return this;
    }

    public String getClassType()
    {
        return classType;
    }

    public Node setClassType(String classType)
    {
        this.classType = classType;
        return this;
    }
}