/*
 * Decompiled with CFR 0.152.
 */
package ch.abertschi.sct.node;

import com.github.underscore.$;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Node {
    private String name;
    private String value;
    private String classType;
    private boolean isContainer;
    private List<Node> children = new LinkedList<Node>();

    public boolean doesMatchWith(Node other) {
        return this.doesMatchWith(other, false);
    }

    public boolean doesMatchWith(Node other, boolean ignoreRootNames) {
        boolean success = false;
        if (this.name.equals(other.name) || ignoreRootNames) {
            if (this.isContainer && other.isContainer) {
                block0: for (Node child : this.children) {
                    for (Node otherChild : other.getChildren()) {
                        if (!child.doesMatchWith(otherChild)) continue;
                        success = true;
                        continue block0;
                    }
                }
            } else {
                success = other.isContainer ? !$.isNull((Object)this.value) && other.toXml().matches(this.value) : !$.isNull((Object)other.getValue()) && !$.isNull((Object)this.value) && other.getValue().matches(this.value);
            }
        }
        return success;
    }

    public String toXml() {
        return this.toXml(null);
    }

    public String toXml(Map<String, String> attributes) {
        if ($.isNull(attributes)) {
            attributes = new HashMap<String, String>();
        }
        if (!$.isNull((Object)this.classType) && !this.classType.isEmpty()) {
            attributes.put("class", this.classType);
        }
        StringBuilder attributeBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            attributeBuilder.append(String.format(" %s=\"%s\"", entry.getKey(), entry.getValue()));
        }
        StringBuilder childrenXml = new StringBuilder();
        if (!$.isEmpty(this.children)) {
            for (Node child : this.children) {
                childrenXml.append(child.toXml());
            }
        } else {
            childrenXml.append(this.value);
        }
        return String.format("<%s%s>%s</%s>", this.name, attributeBuilder.toString(), childrenXml.toString(), this.name);
    }

    public List<Node> getChildren() {
        return this.children;
    }

    public Node setChildren(List<Node> children) {
        this.children = children;
        return this;
    }

    public boolean isContainer() {
        return this.isContainer;
    }

    public Node setIsContainer(boolean isContainer) {
        this.isContainer = isContainer;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Node setName(String name) {
        this.name = name;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public Node setValue(String value) {
        this.value = value;
        return this;
    }

    public String getClassType() {
        return this.classType;
    }

    public Node setClassType(String classType) {
        this.classType = classType;
        return this;
    }
}

