/*
 * Decompiled with CFR 0.152.
 */
package ch.abertschi.sct;

import ch.abertschi.sct.api.Configuration;
import ch.abertschi.sct.api.SctException;
import ch.abertschi.sct.api.invocation.InvocationContext;
import ch.abertschi.sct.parse.StorageParser;
import ch.abertschi.sct.parse.StorageWriter;
import ch.abertschi.sct.serial.Call;
import ch.abertschi.sct.serial.Request;
import ch.abertschi.sct.serial.Response;
import ch.abertschi.sct.util.ResultNotFoundException;
import com.github.underscore.$;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStorageCollection {
    private static final String DEFAULT = "DEFAULT_IMPL";
    private static final Logger LOG = LoggerFactory.getLogger(FileStorageCollection.class);
    private Map<String, StorageParser> parserMap = new HashMap<String, StorageParser>();
    private Map<String, StorageWriter> writerMap = new HashMap<String, StorageWriter>();
    private Configuration config;

    public FileStorageCollection(Configuration config) {
        this.config = config;
    }

    public Object get(Object request, InvocationContext invocation) {
        StorageParser parser;
        if (Configuration.INPUT_SOURCE.SINGLE_FILE == this.config.getReplayingSourceType()) {
            parser = this.parserMap.get(DEFAULT);
            if (parser == null) {
                try {
                    parser = new StorageParser(this.config.getReplayingSource().openStream());
                }
                catch (IOException e) {
                    String msg = String.format("Can not read replaying source %s", this.config.getReplayingSource().getPath());
                    throw new SctException(msg, (Exception)e);
                }
                this.parserMap.put(DEFAULT, parser);
            }
        } else {
            String key = this.createKey(invocation);
            parser = this.parserMap.get(key);
            if (parser == null) {
                InputStream stream = null;
                try {
                    URL source = this.config.getReplayingSource();
                    if (!source.toString().endsWith("/")) {
                        source = new URL(source.toString() + "/");
                    }
                    source = new URL(source, key);
                    stream = source.openStream();
                }
                catch (MalformedURLException e) {
                    LOG.error("Replaying file {} not existing. Nothing to replay", (Object)key);
                }
                catch (IOException e) {
                    LOG.error("Replaying file {} not existing. Nothing to replay", (Object)key);
                }
                if ($.isNull(stream)) {
                    throw new ResultNotFoundException();
                }
                parser = new StorageParser(stream);
                this.parserMap.put(key, parser);
            }
        }
        return parser.get(request);
    }

    public void add(Object request, Object response, InvocationContext invocation) {
        StorageWriter writer;
        if (this.config.getRecordingSourceType() == Configuration.INPUT_SOURCE.SINGLE_FILE) {
            writer = this.writerMap.get(DEFAULT);
            if (writer == null) {
                writer = new StorageWriter(this.config.getRecordingSource(), this.config.isRecordingSkipDoubles());
                this.writerMap.put(DEFAULT, writer);
            }
        } else {
            String key = this.createKey(invocation);
            writer = this.writerMap.get(key);
            if (writer == null) {
                this.createDirectory(this.config.getRecordingSource());
                File recording = new File(this.config.getRecordingSource(), key);
                writer = new StorageWriter(recording, this.config.isRecordingSkipDoubles());
                this.writerMap.put(key, writer);
            }
        }
        Call call = new Call().setRequest(new Request().setPayload(request)).setResponse(new Response().setPayload(response));
        if (this.config.getRecordingMode() == Configuration.RECORDING_MODE.DUMP_CALLS) {
            writer.dump(call);
        } else {
            writer.write(call);
        }
    }

    private void createDirectory(File file) {
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    private String createKey(InvocationContext invocation) {
        String key;
        if (!$.isNull((Object)invocation.getMethod())) {
            String target = invocation.getMethod().getDeclaringClass().getCanonicalName().toLowerCase();
            String method = invocation.getMethod().getName().toLowerCase();
            key = String.format("%s.%s.xml", target, method);
        } else if (!$.isNull((Object)invocation.getTarget())) {
            String target = invocation.getTarget().getClass().getCanonicalName().toLowerCase();
            key = String.format("%s.xml", target);
        } else {
            key = "storage.xml";
        }
        return key;
    }
}

