/*
 * Decompiled with CFR 0.152.
 */
package ch.abertschi.sct.parse;

import ch.abertschi.sct.node.Node;
import ch.abertschi.sct.node.NodeUtils;
import ch.abertschi.sct.parse.ParserCall;
import ch.abertschi.sct.parse.ParserContext;
import ch.abertschi.sct.parse.ResponseExecutor;
import ch.abertschi.sct.parse.XmlParser;
import ch.abertschi.sct.transformer.FieldReferenceTransformer;
import ch.abertschi.sct.transformer.Transformer;
import ch.abertschi.sct.transformer.TransformerContext;
import ch.abertschi.sct.transformer.Transformers;
import ch.abertschi.sct.transformer.VariableTransformer;
import ch.abertschi.sct.util.ExceptionUtil;
import ch.abertschi.sct.util.ResultNotFoundException;
import com.github.underscore.$;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class StorageParser {
    private ParserContext parserContext;
    private List<Transformer> requestAndResponseTransformers;
    private ResponseExecutor responseExecutor;

    public StorageParser(File source) {
        this.createFileIfNotExists(source);
        this.parserContext = new XmlParser().parse(source);
        this.requestAndResponseTransformers = this.getRequestAndResponseTransformers();
        this.responseExecutor = new ResponseExecutor(this.parserContext, this.requestAndResponseTransformers);
    }

    public Object get(Object request) {
        Object response = null;
        ParserCall call = this.findCall(request);
        if (!$.isNull((Object)call)) {
            try {
                response = this.executeResponse(call, request);
            }
            catch (Throwable throwable) {
                ExceptionUtil.throwException(throwable);
            }
        } else {
            throw new ResultNotFoundException();
        }
        return response;
    }

    protected ParserCall findCall(Object currentRequest) {
        ParserCall found = null;
        TransformerContext context = new TransformerContext().setCurrentRequest(currentRequest);
        for (ParserCall call : this.parserContext.getCalls()) {
            context.setCall(call);
            Node node = call.getRequest().getPayloadNode();
            Transformers.transform(node, this.requestAndResponseTransformers, context);
            if (!NodeUtils.doesNodeMatchWithObject(node, context.getCurrentRequest())) continue;
            found = call;
            break;
        }
        return found;
    }

    protected Object executeResponse(ParserCall call, Object currentRequest) throws Throwable {
        return this.responseExecutor.execute(call, currentRequest);
    }

    protected List<Transformer> getRequestAndResponseTransformers() {
        ArrayList<Transformer> transformers = new ArrayList<Transformer>();
        transformers.add(new VariableTransformer());
        transformers.add(new FieldReferenceTransformer());
        return transformers;
    }

    private void createFileIfNotExists(File file) {
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

