/*
 * Decompiled with CFR 0.152.
 */
package ch.abertschi.sct.xstream.path;

import ch.abertschi.sct.xstream.exclusion.WriterContext;
import ch.abertschi.sct.xstream.path.PathTracker;
import com.thoughtworks.xstream.io.AbstractWriter;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.WriterWrapper;

public class PathTrackerWriter
extends WriterWrapper {
    private PathTracker pathTracker;
    private boolean isNameEncoding;
    private WriterContext context;

    public PathTrackerWriter(HierarchicalStreamWriter writer, WriterContext context) {
        super(writer);
        this.context = context;
        this.isNameEncoding = writer.underlyingWriter() instanceof AbstractWriter;
        if (context.getPathTrackerContext() != null) {
            this.pathTracker = context.getPathTrackerContext().getTracker();
        }
    }

    public void startNode(String name) {
        if (this.isActive()) {
            this.pathTracker.pushElement(this.isNameEncoding ? ((AbstractWriter)this.wrapped.underlyingWriter()).encodeNode(name) : name);
        }
        super.startNode(name);
    }

    public void startNode(String name, Class clazz) {
        if (this.isActive()) {
            this.pathTracker.pushElement(this.isNameEncoding ? ((AbstractWriter)this.wrapped.underlyingWriter()).encodeNode(name) : name);
        }
        super.startNode(name, clazz);
    }

    public void endNode() {
        super.endNode();
        if (this.isActive()) {
            this.pathTracker.popElement();
        }
    }

    protected boolean isActive() {
        if (this.context.getPathTrackerContext() != null) {
            return this.context.getPathTrackerContext().isActive();
        }
        return false;
    }
}

